/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;

public class SHAlterTable
extends DDLStatementHandler
implements AlterTableHandler {
    protected Table table;
    protected List statemensList = new ArrayList();
    protected static final Logger LOGGER = new Logger(SHAlterTable.class);
    protected String name = "";

    public SHAlterTable(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHAlterTable.clearCR(string);
        if (Token.startsWithString(string2, "alter table") && (this.isUK(string2) || this.isPK(string2) || this.isFK(string2) || this.isCheck(string2))) {
            try {
                if (this.isPK(string2) || this.isUK(string2) || this.isCheck(string2) || this.isFK(string2)) {
                    this.parseAlterTable(string2);
                } else {
                    this.statemensList.add(string2);
                }
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for DB2 failed!", exception);
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseAlterTable(String string2) {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        if (!abstractStorageDesignDB2.importStorageObjectsOnly()) {
            this.initTable(string2);
            if (this.table != null) {
                String[] stringArray = string2.split(" ADD ");
                if (stringArray.length == 1) {
                    stringArray = string2.split(" add ");
                }
                for (String string2 : Arrays.asList(stringArray)) {
                    if (this.isPK(string2)) {
                        this.initPK(string2);
                        continue;
                    }
                    if (this.isUK(string2)) {
                        this.initUnique(string2);
                        continue;
                    }
                    if (this.isFK(string2)) {
                        this.initForeignKey(string2);
                        continue;
                    }
                    if (!this.isCheck(string2)) continue;
                    this.initCheck(string2);
                }
            }
        }
    }

    protected void initTable(String string) {
        String string2 = Token.getNameAfterToken(string, "TABLE", '\"', '\"').trim();
        String string3 = this.getNameFor(string2);
        this.table = this.getTableFor(string3);
    }

    protected void initForeignKey(String string) {
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        boolean bl = false;
        String string2 = string;
        bl = Token.hasToken(string2, "FOREIGN");
        while (bl) {
            String string3;
            int n = string2.indexOf("FOREIGN");
            String string4 = string2.substring(n);
            String string5 = "FK_ASS";
            String string6 = Token.getTokenBefore(string2, "FOREIGN");
            if (!"".equalsIgnoreCase(string6)) {
                string5 = string6;
            } else {
                String string7 = this.table.getName();
                if (string7.length() > 13) {
                    string7 = string7.substring(0, 13);
                }
                string5 = string7 + "_FK" + this.table.getFKAssociationsCount();
            }
            this.name = string5;
            int n2 = string4.indexOf(41);
            String string8 = string4.substring(0, n2 + 1).trim();
            String string9 = Token.getValBetweenBrackets(string8);
            List list = this.getColumnNames(string9);
            ArrayList<Column> arrayList = new ArrayList<Column>();
            Column[] columnArray = (Column[])this.table.getElements();
            for (String string10 : list) {
                for (int i = 0; i < columnArray.length; ++i) {
                    string3 = columnArray[i].getName().trim();
                    if (!string10.equalsIgnoreCase(string3)) continue;
                    arrayList.add(columnArray[i]);
                }
            }
            int n3 = string4.indexOf("REFERENCES");
            String string11 = Token.getTokenAfter(string4 = string4.substring(n3), "REFERENCES");
            string3 = this.getNameFor(string11);
            Table table = this.getTableFor(string3);
            if (table != null) {
                Object object;
                PropertyMap propertyMap;
                Object object2;
                Object object3;
                boolean bl2 = Token.hasString(string4, "(");
                if (bl2) {
                    object3 = Token.getValBetweenBrackets(string4);
                    object2 = this.getColumnNames((String)object3);
                    propertyMap = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    Index index = this.getUniqueIndexForColumnNames(table, (List)object2);
                    if (index != null) {
                        object = this.table.addFK(index, null, (FKIndexAssociationReference)propertyMap);
                        ((FKIndexAssociation)object).setName(string5);
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
                        ((FKIndexAssociation)object).getLocalFKIndex().setName(string5);
                        if (this.design.isPropagatePKChahges()) {
                            this.replaceAllColumns((FKIndexAssociation)object, arrayList, index);
                        } else {
                            this.fixFKColumns((FKIndexAssociation)object, arrayList, index);
                        }
                        boolean bl3 = Token.hasToken(string4, "DELETE");
                        if (bl3) {
                            String string12 = Token.getTokenAfter(string4, "DELETE").trim();
                            if ("SET".equalsIgnoreCase(string12)) {
                                string12 = "SET NULL";
                            }
                            String[] stringArray = ((FKIndexAssociation)object).getDeleteRuleChoices();
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!string12.equalsIgnoreCase(stringArray[i])) continue;
                                ((FKIndexAssociation)object).setDeleteRule(stringArray[i]);
                                break;
                            }
                        }
                    }
                } else {
                    object3 = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    object2 = (Index)table.getPK();
                    if (object2 != null) {
                        propertyMap = this.table.addFK((KeyObject)object2, null, (FKIndexAssociationReference)object3);
                        ((FKIndexAssociation)propertyMap).setName(string5);
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)((Object)propertyMap));
                        ((FKIndexAssociation)propertyMap).getLocalFKIndex().setName(string5);
                        if (this.design.isPropagatePKChahges()) {
                            this.replaceAllColumns((FKIndexAssociation)propertyMap, arrayList, (Index)object2);
                        } else {
                            this.fixFKColumns((FKIndexAssociation)propertyMap, arrayList, (Index)object2);
                        }
                        boolean bl4 = Token.hasToken(string4, "DELETE");
                        if (bl4) {
                            object = Token.getTokenAfter(string4, "DELETE").trim();
                            if ("SET".equalsIgnoreCase((String)object)) {
                                object = "SET NULL";
                            }
                            if ("NO".equalsIgnoreCase((String)object)) {
                                object = "NO ACTION";
                            }
                            String[] stringArray = ((FKIndexAssociation)propertyMap).getDeleteRuleChoices();
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!((String)object).equalsIgnoreCase(stringArray[i])) continue;
                                ((FKIndexAssociation)propertyMap).setDeleteRule(stringArray[i]);
                                break;
                            }
                        }
                    }
                }
            }
            string2 = string4;
            bl = Token.hasToken(string2, "FOREIGN");
        }
    }

    protected boolean isCheck(String string) {
        return Token.hasToken(string, "CHECK");
    }

    private void initCheck(String string) {
        Object object;
        String string2;
        this.statement = string;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        String string3 = null;
        if (Token.hasToken(this.statement.toUpperCase(), "CHECK")) {
            string2 = Token.getTokenBefore(this.statement, "CHECK").trim();
            if (!"".equalsIgnoreCase(string2)) {
                string3 = string2;
            } else {
                object = this.table.getName();
                if (((String)object).length() > 13) {
                    object = ((String)object).substring(0, 13);
                }
                string3 = (String)object + "_CK" + this.table.getCheckConstraints().size();
            }
        }
        string2 = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "CHECK"), 1).trim();
        object = this.table.createCheckConstraint(string3, string2);
        this.table.addCheckConstraint((TableLevelConstraint)object);
        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
    }

    protected List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    protected String getNameFor(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = null;
            do {
                String string3;
                string2 = string3 = stringTokenizer.nextToken().trim();
            } while (stringTokenizer.hasMoreTokens());
            int n2 = string2.indexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        int n3 = string.indexOf(59);
        if (n3 > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected Table getTableFor(String string) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private Column getColumnFor(Table table, String string) {
        Column column = null;
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column2 = columnArray[i];
            if (!column2.getName().equalsIgnoreCase(string)) continue;
            column = column2;
            break;
        }
        return column;
    }

    protected void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        Column[] columnArray2 = (Column[])index2.getElements();
        if (columnArray.length != list.size()) {
            this.importLog.addError("Foreign key columns don't match Primary key columns\ntab_ch " + index2.getContainerWithKeyObject().getName() + " index " + index2.getName() + "  parent_tab " + index.getContainerWithKeyObject().getName());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            if (column.isPartOfFKIndexAssociation(fKIndexAssociation)) continue;
            Column column2 = columnArray2[n];
            fKIndexAssociation.swapAndRemoveFKColumn(column2, column, columnArray[n]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append("  parent_tab ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    protected boolean isPK(String string) {
        return Token.hasToken(string, "PRIMARY");
    }

    protected boolean isUK(String string) {
        return Token.hasToken(string, "UNIQUE");
    }

    protected boolean isFK(String string) {
        return Token.hasToken(string, "FOREIGN");
    }

    protected void initPK(String string) {
        String string2;
        List list;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        if ((list = this.getColumnNames(string2 = Token.getValBetweenBrackets(Token.getStringAfter(string, "PRIMARY KEY"), 1).trim())).size() > 0) {
            Index index = this.table.createIndex();
            String string3 = Token.getTokenBefore(string, "PRIMARY");
            if (!"".equalsIgnoreCase(string3)) {
                index.setName(string3);
            } else {
                Object object = this.table.getName();
                if (((String)object).length() > 15) {
                    object = ((String)object).substring(0, 15);
                }
                index.setName((String)object + "_PK");
            }
            for (String string4 : list) {
                Column column = this.getColumnFor(this.table, string4);
                if (column == null) continue;
                index.add(column);
            }
            index.makePK();
            this.design.getRelationalDesign().stampModelObjectDDL(index);
        }
    }

    protected void initUnique(String string) {
        String string2;
        List list;
        if (string.trim().startsWith("(")) {
            string = Token.getValBetweenBrackets(string);
        }
        if ((list = this.getColumnNames(string2 = Token.getValBetweenBrackets(Token.getStringAfter(string, "UNIQUE"), 1).trim())).size() > 0) {
            Index index = this.table.createIndex();
            String string3 = Token.getTokenBefore(string, "UNIQUE");
            if (!"".equalsIgnoreCase(string3)) {
                index.setName(string3);
            } else {
                Object object = this.table.getName();
                if (((String)object).length() > 13) {
                    object = ((String)object).substring(0, 13);
                }
                index.setName((String)object + "_UK" + this.table.getUKeys().size());
            }
            for (String string4 : list) {
                Column column = this.getColumnFor(this.table, string4 = Token.getName(string4));
                if (column == null) continue;
                index.add(column);
            }
            index.setUnique(true);
            this.design.getRelationalDesign().stampModelObjectDDL(index);
        }
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    protected Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    @Override
    public void processForeignKeys() {
        for (String string : this.statemensList) {
            this.parseAlterTable(string);
        }
    }
}

