/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.db2.SHColumnElements;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateDistinctTypeDB2;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class DomainHandlerReadDDLDB2
implements StatementsConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;
    private LogicalDatatypeFactory factoryLogical;

    public DomainHandlerReadDDLDB2(Design design) {
        this.design = design;
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    public void createDomains(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = DDLStatementHandler.clearCR((String)iterator.next());
            if (Token.startsWithString(string = string.replaceAll("\"", ""), "create distinct type")) {
                object = new SHCreateDistinctTypeDB2(this.design, this.factoryLogical);
                ((SHCreateDistinctTypeDB2)object).parseDistinctType(string);
            }
            if (!Token.startsWithString(string, "create table")) continue;
            object = this.getColumns(string);
            Iterator iterator2 = ((ArrayList)object).iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                this.createOneDomain(string2);
            }
        }
    }

    private ArrayList getColumns(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Token.getValBetweenBrackets(string, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracket(string3)) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                while (Token.hasOpenBracket(string3) && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(", ").append(stringTokenizer.nextToken().trim());
                    string3 = stringBuffer.toString();
                }
            }
            arrayList.add(string3.trim());
        }
        return arrayList;
    }

    private void createOneDomain(String string) {
        SHColumnElements sHColumnElements = new SHColumnElements();
        Map map = sHColumnElements.getElementsColumn(string);
        String string2 = (String)map.get("columnname");
        if (!"".equalsIgnoreCase(string2)) {
            String string3 = (String)map.get("datatype");
            String[] stringArray = new String[]{(String)map.get("precision"), (String)map.get("scale"), (String)map.get("size")};
            if (string3 != null) {
                String string4 = StandardDatatypeNames.getUsedDatatypeName(string3);
                LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignDB2v70.RDBMS_TYPE, string4);
                this.factory.getInstance(this.design, logicalDatatype, null, 2, stringArray, null);
            }
        }
    }
}

