/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.parser.ScriptParser;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class DDLStatementHandler
implements StatementsConstants {
    private DDLStatementHandler successor = null;
    protected String statement = null;
    protected Design design = null;
    private Owner owner;
    protected ImportLogger importLog;
    private boolean asSelectOnly = true;

    public DDLStatementHandler(Design design) {
        this.design = design;
    }

    public void add(DDLStatementHandler dDLStatementHandler) {
        DDLStatementHandler dDLStatementHandler2 = this;
        while (dDLStatementHandler2.successor != null) {
            dDLStatementHandler2 = dDLStatementHandler2.successor;
        }
        dDLStatementHandler2.successor = dDLStatementHandler;
    }

    public void handle(String string) {
        this.nextHandler(string);
    }

    public void nextHandler(String string) {
        if (this.successor != null) {
            this.successor.setImportLog(this.importLog);
            this.successor.handle(string);
        } else {
            String string2 = DDLStatementHandler.clearCR(string).toUpperCase();
            if (!string2.startsWith("SET CURRENT SCHEMA") && !string2.startsWith("SET CURRENT SQLID")) {
                this.importLog.addNotRecognized(string);
            }
        }
    }

    public static String clearCR(String string) {
        string = ScriptParser.removeComments(string);
        return string.replaceAll("[ \t\n\f\r\u000b]+", " ");
    }

    public static String FormatCR(String string, String string2) {
        return string;
    }

    public void setStatement(String string) {
        this.statement = string;
    }

    public void setAsSelectOnly(boolean bl) {
        this.asSelectOnly = bl;
    }

    public boolean isAsSelectOnly() {
        return this.asSelectOnly;
    }

    protected void determineAndCutLength(String string) {
        int n = string.length();
        if (n < this.statement.length()) {
            ++n;
        }
        this.statement = this.statement.substring(n).trim();
    }

    protected String cutStringFromFront(String string, String string2) {
        int n = string2.length();
        if (n < this.statement.length()) {
            ++n;
        }
        String string3 = string.substring(n).trim();
        return string3;
    }

    public Table getTableFromDesign(String string) {
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Table[] tableArray = (Table[])tableSet.toArray();
        for (int i = 0; i < tableArray.length; ++i) {
            if (!tableArray[i].getName().equalsIgnoreCase(string)) continue;
            return tableArray[i];
        }
        return null;
    }

    public Column getColumnFromTable(Table table, String string) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getName().equalsIgnoreCase(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    public String getNameOnly(String string) {
        if (string.indexOf(46) > 0) {
            return Token.getValAfterCharacter(string, '.').trim();
        }
        return string;
    }

    public CreateTableHandler getCreateTableHandler() {
        if (this instanceof CreateTableHandler) {
            return (CreateTableHandler)((Object)this);
        }
        if (this.successor != null) {
            return this.successor.getCreateTableHandler();
        }
        return null;
    }

    public AlterTableHandler getAlterTableHandler() {
        if (this instanceof AlterTableHandler) {
            return (AlterTableHandler)((Object)this);
        }
        if (this.successor != null) {
            return this.successor.getAlterTableHandler();
        }
        return null;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
        if (this.successor != null) {
            this.successor.setOwner(owner);
        }
    }

    public ImportLogger getImportLog() {
        return this.importLog;
    }

    public void setImportLog(ImportLogger importLogger) {
        this.importLog = importLogger;
    }

    public StorageDesign getStorageDesign() {
        return this.design.getStorageDesign(this.design.getSelectedRDBMSSite());
    }
}

