/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.compare.CompareMappingDialog;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class DDLFilesCollector
extends CustomDialog {
    private JList list;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private JButton okButton;
    private JButton btnRemove;
    private JComboBox cbImportTo;
    private JCheckBox chbReverseTarget;
    private JCheckBox chbSkipMerge;
    private int minWidth = 440;
    private int minHeight = 350;
    private static List<File> allFiles = new ArrayList<File>();
    private static File lastFolder = null;

    public DDLFilesCollector(ApplicationView applicationView) {
        super(applicationView);
        this.setLayout(new BorderLayout());
        this.add(this.initMainPanel());
        this.addAllFiles();
    }

    private JPanel initMainPanel() {
        Object object;
        URLFilter uRLFilter = new URLFilter(){

            public boolean accept(URL uRL) {
                File file = new File(uRL.getPath());
                return file.getName().toLowerCase().endsWith(".ddl") || file.getName().toLowerCase().endsWith(".sql") || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("DDLFilesCollector.DDLFiles");
            }
        };
        final URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setSelectionScope(0);
        uRLChooser.setSelectionMode(2);
        uRLChooser.setShowJarsAsDirs(false);
        uRLChooser.setURLFilter(uRLFilter);
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("ADD_ICON", 16));
        jButton.setToolTipText(Messages.getString("DDLFilesCollector.AddDDLFiles"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                if (lastFolder != null) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
                } else {
                    String string = DDLFilesCollector.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null && string.length() > 0) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        serializable = DDLFilesCollector.this.getApplicationView().getUserHomeDirectory();
                        if (serializable != null) {
                            uRLChooser.setSelectedURL((URL)serializable);
                        }
                    }
                }
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DDLFilesCollector.SelectDDLFiles"));
                if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                    lastFolder = ((File)serializable).getParentFile();
                    URL[] uRLArray = uRLChooser.getSelectedURLs();
                    for (int i = 0; i < uRLArray.length; ++i) {
                        File file = new File(uRLArray[i].getPath());
                        if (DDLFilesCollector.containsFile(file)) continue;
                        allFiles.add(file);
                        DDLFilesCollector.this.listModel.addElement(file);
                    }
                }
                DDLFilesCollector.this.okButton.setEnabled(!DDLFilesCollector.this.listModel.isEmpty());
                DDLFilesCollector.this.btnRemove.setEnabled(!DDLFilesCollector.this.listModel.isEmpty());
            }
        });
        this.btnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", 16));
        this.btnRemove.setToolTipText(Messages.getString("DDLFilesCollector.RemoveDDLFiles"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = DDLFilesCollector.this.list.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    DDLFilesCollector.this.listModel.removeElement(objectArray[i]);
                    allFiles.remove(objectArray[i]);
                }
                DDLFilesCollector.this.okButton.setEnabled(!DDLFilesCollector.this.listModel.isEmpty());
                DDLFilesCollector.this.btnRemove.setEnabled(!DDLFilesCollector.this.listModel.isEmpty());
            }
        });
        jToolBar.add(jButton);
        jToolBar.add(this.btnRemove);
        jPanel.add((Component)jToolBar, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(360, 150));
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1, 10, 10));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("DDLFilesCollector.Options")));
        Dimension dimension = new Dimension(180, 20);
        Dimension dimension2 = new Dimension(220, 20);
        JLabel jLabel = new JLabel(Messages.getString("DDLFilesCollector.ImportTo"));
        jLabel.setPreferredSize(dimension);
        this.cbImportTo = new JComboBox();
        this.cbImportTo.setPreferredSize(dimension2);
        jPanel4.add(this.createRow(jLabel, this.cbImportTo));
        Object object2 = null;
        Iterator iterator = this.getApplicationView().getCurrentDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            object = (RelationalDesign)iterator.next();
            this.cbImportTo.addItem(object);
            if (!((RelationalDesign)object).isEmpty() || object2 != null) continue;
            object2 = object;
        }
        this.cbImportTo.addItem(Messages.getString("DDLFilesCollector.NewRelationalModel"));
        if (object2 != null) {
            this.cbImportTo.setSelectedItem(object2);
        }
        object = new JLabel();
        this.chbReverseTarget = new JCheckBox(this.removeLastDots(Messages.getString("DDLFilesCollector.SwapTargetModel")));
        this.chbReverseTarget.setEnabled(!this.emptySelected());
        jPanel4.add(this.createRow(this.chbReverseTarget, (Component)object));
        jPanel3.add(jPanel4);
        jPanel2.add((Component)jPanel3, "South");
        JLabel jLabel2 = new JLabel();
        this.chbSkipMerge = new JCheckBox(this.removeLastDots(Messages.getString("DDLFilesCollector.SkipMergeDialog")));
        this.chbSkipMerge.setEnabled(this.emptySelected());
        jPanel4.add(this.createRow(this.chbSkipMerge, jLabel2));
        JButton jButton2 = new JButton(Messages.getString("DDLFilesCollector.ViewCompareMapping"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareMappingDialog compareMappingDialog = new CompareMappingDialog(DDLFilesCollector.this.getApplicationView());
                compareMappingDialog.show();
            }
        });
        JLabel jLabel3 = new JLabel(Messages.getString("DDLFilesCollector.CompareMapping"));
        jLabel3.setPreferredSize(dimension);
        jPanel4.add(this.createRow(jLabel3, jButton2));
        this.cbImportTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DDLFilesCollector.this.chbReverseTarget.setEnabled(!DDLFilesCollector.this.emptySelected());
                if (!DDLFilesCollector.this.chbReverseTarget.isEnabled()) {
                    DDLFilesCollector.this.chbReverseTarget.setSelected(false);
                }
                DDLFilesCollector.this.chbSkipMerge.setEnabled(DDLFilesCollector.this.emptySelected());
                if (!DDLFilesCollector.this.chbSkipMerge.isEnabled()) {
                    DDLFilesCollector.this.chbSkipMerge.setSelected(false);
                }
            }
        });
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(Messages.getString("DDLFilesCollector.OK"));
        this.okButton.setMnemonic(79);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DDLFilesCollector.this.result = true;
                DDLFilesCollector.this.close();
            }
        });
        jPanel5.add(this.okButton);
        JButton jButton3 = new JButton(Messages.getString("DDLFilesCollector.Cancel"));
        jButton3.setMnemonic(67);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DDLFilesCollector.this.result = false;
                DDLFilesCollector.this.close();
            }
        });
        jPanel5.add(jButton3);
        JButton jButton4 = new JButton(this.getHelpAction());
        jButton4.setMnemonic(72);
        jPanel5.add(jButton4);
        this.okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton4.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private boolean emptySelected() {
        if (this.cbImportTo.getSelectedItem() instanceof RelationalDesign) {
            return ((RelationalDesign)this.cbImportTo.getSelectedItem()).isEmpty();
        }
        return true;
    }

    private String removeLastDots(String string) {
        String string2 = string.trim();
        if (string2.endsWith(":")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    protected JPanel createRow(Component component, Component component2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(component, "West");
        jPanel.add(component2, "Center");
        return jPanel;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("DDLFilesCollector.SelectDDLFiles"));
            this.dialog.setModal(true);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = DDLFilesCollector.this.dialog.getWidth();
                    int n2 = DDLFilesCollector.this.dialog.getHeight();
                    n = Math.max(DDLFilesCollector.this.minWidth, n);
                    n2 = Math.max(DDLFilesCollector.this.minHeight, n2);
                    DDLFilesCollector.this.dialog.setSize(n, n2);
                }
            });
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_DDL_FILES_DIALOG";
    }

    public boolean showDialog() {
        this.result = false;
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    public Object[] getDDLFiles() {
        return this.listModel.toArray();
    }

    public RelationalDesign getSelectedModel() {
        Object object = this.cbImportTo.getSelectedItem();
        if (object instanceof RelationalDesign) {
            return (RelationalDesign)object;
        }
        return null;
    }

    public boolean swapTargetModel() {
        return this.chbReverseTarget.isSelected();
    }

    public boolean skipMergeDialog() {
        return this.chbSkipMerge.isSelected();
    }

    private static boolean containsFile(File file) {
        for (File file2 : allFiles) {
            if (!file2.getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private void addAllFiles() {
        for (File file : allFiles) {
            if (!file.exists()) continue;
            this.listModel.addElement(file);
        }
        this.okButton.setEnabled(!this.listModel.isEmpty());
        this.btnRemove.setEnabled(!this.listModel.isEmpty());
    }

    public static void clearFileList() {
        allFiles.clear();
    }
}

