/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.cwddesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.ddl.AbstractDDLObjectHandler;
import oracle.dbtools.crest.imports.ddl.DDLRelationalDesign;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class DDLExtractionHandler {
    private static DDLExtractionHandler ddlExtractionHandler;
    private ApplicationView view;
    private List ddlHObjects = null;
    private Design oldDesign;
    private Map importedObjects = new TreeMap();
    private static final Logger LOGGER;

    protected DDLExtractionHandler(ApplicationView applicationView, Design design) {
        this.view = applicationView;
        this.oldDesign = design;
    }

    public static DDLExtractionHandler getInstance(ApplicationView applicationView, Design design) {
        if (ddlExtractionHandler == null) {
            ddlExtractionHandler = new DDLExtractionHandler(applicationView, design);
        }
        return ddlExtractionHandler;
    }

    public List getDDLHObjects() {
        if (this.ddlHObjects == null) {
            this.ddlHObjects = new ArrayList();
            this.ddlHObjects.add(new DDLRelationalDesign(this, this.view));
        }
        return this.ddlHObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getODObjects(List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        List list2 = this.getDDLHObjects();
        if (list2.size() > 0) {
            for (AbstractObjectHandler abstractObjectHandler : list2) {
                List list3 = abstractObjectHandler.extract(list);
                arrayList.addAll(list3);
            }
        }
        return arrayList;
    }

    public void generateDesign(List list, ImportLogger importLogger) {
        try {
            this.clearImportedObjects();
            List list2 = this.getDDLHObjects();
            for (AbstractDDLObjectHandler abstractDDLObjectHandler : list2) {
                abstractDDLObjectHandler.generate(list, importLogger);
            }
        }
        catch (Exception exception) {
            LOGGER.error("DDLExtractionHandler.insertDesign()", exception);
        }
    }

    public Design getOldDesign() {
        return this.oldDesign;
    }

    public void addToImportedObjects(String string, ModelIDObject modelIDObject) {
        this.importedObjects.put(string, modelIDObject);
    }

    public void clearImportedObjects() {
        this.importedObjects.clear();
    }

    public Object getImportedObject(String string) {
        return this.importedObjects.get(string);
    }

    public Object getElementByImportID(ContainerObject containerObject, String string) {
        ContainedObject[] containedObjectArray = containerObject.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            ContainedObject containedObject = containedObjectArray[i];
            if (!containedObject.getImportedId().equalsIgnoreCase(string)) continue;
            return containedObject;
        }
        return null;
    }

    static {
        LOGGER = new Logger(DDLExtractionHandler.class);
    }
}

