/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cwddesigner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.cwddesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.cwddesigner.CWDDesignObj;
import oracle.dbtools.crest.imports.cwddesigner.CWDExtractionHandler;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class CWDRelationalDesign
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "Relational Model";

    public CWDRelationalDesign(CWDExtractionHandler cWDExtractionHandler, ApplicationView applicationView) {
        super(cWDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (CWDDesignObj cWDDesignObj : list) {
            RelationalDesign relationalDesign;
            if (!cWDDesignObj.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            if (cWDDesignObj.isSelected()) {
                relationalDesign = (RelationalDesign)cWDDesignObj.getModel();
                if (relationalDesign.isLoaded()) continue;
                relationalDesign.setShouldBeOpen(true);
                this.getDesign().setClosing(true);
                this.getDesign().setClosing(false);
                if (relationalDesign.getDesign().isOldRepositoryType()) {
                    relationalDesign.load();
                } else {
                    relationalDesign.getAppView().getXMLTransformationManager().openDesignPart(relationalDesign);
                    RMExtendedMap rMExtendedMap = relationalDesign.getRMExtendedMap();
                    relationalDesign.getAppView().getXMLTransformationManager().transformFromXMLToObject(rMExtendedMap, new File(rMExtendedMap.getStorageName()), relationalDesign.getDesign().isCompressedDesign());
                }
                relationalDesign.getDesign().getExtendedMap().distributenMappings(relationalDesign);
                if (cWDDesignObj.getImportTo() instanceof RelationalDesign) {
                    relationalDesign.setImportTo((RelationalDesign)cWDDesignObj.getImportTo());
                    continue;
                }
                relationalDesign.setImportTo(null);
                continue;
            }
            relationalDesign = (RelationalDesign)cWDDesignObj.getModel();
            relationalDesign.setShouldBeOpen(false);
        }
        return arrayList;
    }

    @Override
    public void generate(List list, ImportLogger importLogger) throws Exception {
        for (CWDDesignObj cWDDesignObj : list) {
            if (!cWDDesignObj.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            RelationalDesign relationalDesign = (RelationalDesign)cWDDesignObj.getModel();
            if (relationalDesign.getImportTo() == null) {
                relationalDesign.setName(relationalDesign.getName() + "_" + relationalDesign.getDesign().getName());
                RelationalDesign relationalDesign2 = this.getOldDesign().addRelationalDesign(relationalDesign.getName());
                relationalDesign2.setShouldEngineer(relationalDesign.getShouldEngineer());
                relationalDesign2.setComment(relationalDesign.getComment());
                relationalDesign.setImportTo(relationalDesign2);
            }
            this.importNotes(relationalDesign, relationalDesign.getImportTo());
            importLogger.incrementImportedStatements();
        }
    }

    private void importNotes(RelationalDesign relationalDesign, RelationalDesign relationalDesign2) {
        for (int i = 0; i < relationalDesign.getNoteSet().size(); ++i) {
            Note note;
            Note note2 = (Note)relationalDesign.getNoteSet().getElement(i);
            if (relationalDesign2.getNoteSet().getByName(note2.getName()) != null) {
                if (!this.canImport()) continue;
                String string = this.getPrefix() + note2.getName();
                note = relationalDesign2.getNoteSet().createNote(null);
                note.copy(note);
                note.setText(note2.getText());
                note.setName(string);
                note.setImportedDesign(relationalDesign.getDesign());
                note.setImportedId(note2.getObjectID());
                continue;
            }
            note = relationalDesign2.getNoteSet().createNote(null);
            note.copy(note);
            note.setText(note2.getText());
            note.setImportedDesign(relationalDesign.getDesign());
            note.setImportedId(note2.getObjectID());
        }
    }
}

