/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cwddesigner;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.cwddesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.cwddesigner.CWDDesignObj;
import oracle.dbtools.crest.imports.cwddesigner.CWDExtractionHandler;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class CWDLogicalDesign
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "Logical Model";

    public CWDLogicalDesign(CWDExtractionHandler cWDExtractionHandler, ApplicationView applicationView) {
        super(cWDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(List list, ImportLogger importLogger) throws Exception {
        for (CWDDesignObj cWDDesignObj : list) {
            if (!cWDDesignObj.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            if (cWDDesignObj.isSelected()) {
                LogicalDesign logicalDesign = (LogicalDesign)cWDDesignObj.getModel();
                logicalDesign.setShouldBeOpen(true);
            }
            importLogger.incrementImportedStatements();
        }
    }

    @Override
    public List extract(List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (CWDDesignObj cWDDesignObj : list) {
            LogicalDesign logicalDesign;
            if (!cWDDesignObj.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            if (cWDDesignObj.isSelected()) {
                logicalDesign = (LogicalDesign)cWDDesignObj.getModel();
                if (!logicalDesign.isLoaded()) {
                    logicalDesign.setShouldBeOpen(true);
                    if (logicalDesign.getDesign().isOldRepositoryType()) {
                        logicalDesign.load();
                    } else {
                        logicalDesign.getAppView().getXMLTransformationManager().openDesignPart(logicalDesign);
                    }
                }
                if (!logicalDesign.getDesign().isOldRepositoryType()) continue;
                logicalDesign.getDesign().getExtendedMap().load();
                continue;
            }
            logicalDesign = (LogicalDesign)cWDDesignObj.getModel();
            logicalDesign.setShouldBeOpen(false);
        }
        return arrayList;
    }
}

