/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cwddesigner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.cwddesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.cwddesigner.CWDBusinessInfoDesign;
import oracle.dbtools.crest.imports.cwddesigner.CWDDataTypeDesign;
import oracle.dbtools.crest.imports.cwddesigner.CWDLogicalDesign;
import oracle.dbtools.crest.imports.cwddesigner.CWDRelationalDesign;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class CWDExtractionHandler {
    private static CWDExtractionHandler cwdExtractionHandler;
    private ApplicationView view;
    private List cwdHObjects = null;
    private Design oldDesign;
    private Map importedObjects = new TreeMap();
    private static final Logger LOGGER;

    protected CWDExtractionHandler(ApplicationView applicationView, Design design) {
        this.view = applicationView;
        this.oldDesign = design;
    }

    public static CWDExtractionHandler getInstance(ApplicationView applicationView, Design design) {
        if (cwdExtractionHandler == null) {
            cwdExtractionHandler = new CWDExtractionHandler(applicationView, design);
        }
        return cwdExtractionHandler;
    }

    public List getCWDHObjects() {
        if (this.cwdHObjects == null) {
            this.cwdHObjects = new ArrayList();
            this.cwdHObjects.add(new CWDBusinessInfoDesign(this, this.view));
            this.cwdHObjects.add(new CWDDataTypeDesign(this, this.view));
            this.cwdHObjects.add(new CWDLogicalDesign(this, this.view));
            this.cwdHObjects.add(new CWDRelationalDesign(this, this.view));
        }
        return this.cwdHObjects;
    }

    public void clearCWDHObjects() {
        if (this.cwdHObjects != null) {
            this.cwdHObjects.clear();
            this.cwdHObjects = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getODObjects(List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        List list2 = this.getCWDHObjects();
        if (list2.size() > 0) {
            for (AbstractObjectHandler abstractObjectHandler : list2) {
                List list3 = abstractObjectHandler.extract(list);
                arrayList.addAll(list3);
            }
        }
        return arrayList;
    }

    public void generateDesign(List list, ImportLogger importLogger) {
        try {
            this.clearImportedObjects();
            List list2 = this.getCWDHObjects();
            for (AbstractObjectHandler abstractObjectHandler : list2) {
                abstractObjectHandler.generate(list, importLogger);
            }
        }
        catch (Exception exception) {
            LOGGER.error("CWDExtractionHandler.insertDesign()", exception);
        }
    }

    public Design getOldDesign() {
        return this.oldDesign;
    }

    public void addToImportedObjects(String string, ModelIDObject modelIDObject) {
        this.importedObjects.put(string, modelIDObject);
    }

    public void clearImportedObjects() {
        this.importedObjects.clear();
    }

    public Object getImportedObject(String string) {
        return this.importedObjects.get(string);
    }

    public Object getElementByImportID(ContainerObject containerObject, String string) {
        ContainedObject[] containedObjectArray = containerObject.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            ContainedObject containedObject = containedObjectArray[i];
            if (!containedObject.getImportedId().equalsIgnoreCase(string)) continue;
            return containedObject;
        }
        return null;
    }

    static {
        LOGGER = new Logger(CWDExtractionHandler.class);
    }
}

