/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports;

import java.awt.Frame;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.SyncObject;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.relational.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.JListDialog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.jdeveloper.db.DatabaseConnections;

public class SyncUtils {
    private static final Logger LOGGER = new Logger(SyncUtils.class);

    public static void syncDataDictionary(RelationalDesign relationalDesign, boolean bl, Map map) {
        block12: {
            try {
                Object object;
                relationalDesign.getDesign().setRelationalDesign(relationalDesign);
                relationalDesign.getAppView().setCurrentDesign(relationalDesign.getDesign());
                if (relationalDesign.getImportConnectionStamps().isEmpty()) break block12;
                int n = 0;
                DBConnectionStamp dBConnectionStamp = relationalDesign.getImportConnectionStamp(n);
                if (relationalDesign.getImportConnectionStamps().size() > 1) {
                    object = relationalDesign.getImportConnectionStamps().toArray();
                    dBConnectionStamp = (DBConnectionStamp)JListDialog.showDialog((Frame)Ide.getMainWindow(), Messages.getString("ControllerRelational.SelectConnection"), Messages.getString("ControllerRelational.DataDictionaryConnections"), object, dBConnectionStamp);
                    if (dBConnectionStamp == null) {
                        return;
                    }
                    n = relationalDesign.findImportConnectionStamp(dBConnectionStamp.getConnName());
                }
                if (dBConnectionStamp.getConnType() != 1 && dBConnectionStamp.getConnType() != 2 && dBConnectionStamp.getConnType() != 3 && dBConnectionStamp.getConnType() != 4) {
                    return;
                }
                relationalDesign.setImportConnectionStampIndex(n);
                object = dBConnectionStamp.getConnName();
                int n2 = dBConnectionStamp.getConnType();
                if ("".equals(object)) break block12;
                try {
                    Connection connection = DatabaseConnections.getInstance().getUniqueConnection((String)object);
                    if (connection != null) {
                        Properties properties = new Properties();
                        DBMExtractionController dBMExtractionController = new DBMExtractionController(relationalDesign.getAppView());
                        AbstractDBMExtractionHandler abstractDBMExtractionHandler = dBMExtractionController.getDBMExtractionHandler(n2);
                        abstractDBMExtractionHandler.init(connection);
                        if (abstractDBMExtractionHandler instanceof DBMExtractionHandlerOracle) {
                            ((DBMExtractionHandlerOracle)abstractDBMExtractionHandler).setDBAUser(connection);
                        }
                        RDBMSSite rDBMSSite = abstractDBMExtractionHandler.getRDBMSSite();
                        relationalDesign.setSelectedRDBMSSite(rDBMSSite);
                        List list = SyncUtils.getSelectedObjects(relationalDesign, map, dBConnectionStamp.getConnName(), dBConnectionStamp.getConnType(), connection, abstractDBMExtractionHandler);
                        try {
                            if (bl) {
                                FKIndexAssociation.RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = false;
                            }
                            dBMExtractionController.generateDesign(connection, properties, list, relationalDesign, bl, rDBMSSite, true, map);
                        }
                        catch (Throwable throwable) {
                            MessageDialogs.showErrorMessage(throwable.getMessage());
                            LOGGER.error(throwable);
                        }
                        break block12;
                    }
                    object = "";
                }
                catch (SQLException sQLException) {
                    object = "";
                    MessageDialogs.showErrorMessage(sQLException.getMessage());
                    LOGGER.error(sQLException);
                }
            }
            catch (Throwable throwable) {
                MessageDialogs.showErrorMessage(throwable.getMessage());
                LOGGER.error(throwable);
            }
        }
    }

    public static List getSelectedObjects(RelationalDesign relationalDesign, Map map, String string, int n, Connection connection, AbstractDBMExtractionHandler abstractDBMExtractionHandler) throws Exception {
        Settings settings = relationalDesign.getDesign().getAppView().getSettings();
        Iterator iterator = settings.getSyncObjects().iterator();
        ArrayList arrayList = new ArrayList();
        StorageDesign storageDesign = relationalDesign.getStorageDesign();
        if (map != null) {
            ModelIDObject modelIDObject;
            Object object;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                object = (ModelIDObject)iterator2.next();
                if (!map.containsKey(((ModelIDObject)object).getObjectID())) continue;
                arrayList2.add(object);
            }
            object = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, arrayList2.iterator(), "TABLE");
            arrayList.addAll(object);
            arrayList2.clear();
            iterator2 = relationalDesign.getTableViewSet().iterator();
            while (iterator2.hasNext()) {
                modelIDObject = (ModelIDObject)iterator2.next();
                if (!map.containsKey(modelIDObject.getObjectID())) continue;
                arrayList2.add(modelIDObject);
            }
            object = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, arrayList2.iterator(), "VIEW");
            arrayList.addAll(object);
            if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
                modelIDObject = (StorageDesignOracle)storageDesign;
                iterator2 = ((StorageDesignOracle)modelIDObject).getTableSpaceSet().iterator();
                object = SyncUtils.getSelectedObjectsNoSchema(string, n, connection, abstractDBMExtractionHandler, iterator2, "TABLESPACE");
                arrayList.addAll(object);
            }
        } else {
            Iterator iterator3 = relationalDesign.getTableSet().iterator();
            List list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "TABLE");
            arrayList.addAll(list);
            iterator3 = relationalDesign.getTableViewSet().iterator();
            list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "VIEW");
            arrayList.addAll(list);
            if (n == 4) {
                iterator3 = relationalDesign.getTableSet().iterator();
                list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "SUMMARY TABLE");
                arrayList.addAll(list);
                iterator3 = relationalDesign.getTableSet().iterator();
                list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "TYPED TABLE");
                arrayList.addAll(list);
            }
            if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
                Object object;
                StorageDesignOracle storageDesignOracle = (StorageDesignOracle)storageDesign;
                while (iterator.hasNext()) {
                    object = (SyncObject)iterator.next();
                    if (!((SyncObject)object).getDatabase().equals("Oracle")) continue;
                    if (((SyncObject)object).getType().equals("TABLESPACE") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getTableSpaceSet().iterator();
                        list = SyncUtils.getSelectedObjectsNoSchema(string, n, connection, abstractDBMExtractionHandler, iterator3, "TABLESPACE");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("TEMP TABLESPACE") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getTemporaryTablespaceSet().iterator();
                        list = SyncUtils.getSelectedObjectsNoSchema(string, n, connection, abstractDBMExtractionHandler, iterator3, "TEMP TABLESPACE");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("UNDO TABLESPACE") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getUndoTablespaceSet().iterator();
                        list = SyncUtils.getSelectedObjectsNoSchema(string, n, connection, abstractDBMExtractionHandler, iterator3, "UNDO TABLESPACE");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("ROLE") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getRoleSet().iterator();
                        list = SyncUtils.getSelectedObjectsNoSchema(string, n, connection, abstractDBMExtractionHandler, iterator3, "ROLE");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("USER") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getUserSet().iterator();
                        list = SyncUtils.getSelectedObjectsNoSchema(string, n, connection, abstractDBMExtractionHandler, iterator3, "USER");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("DIRECTORY") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getDirectorySet().iterator();
                        list = SyncUtils.getSelectedObjectsNoSchema(string, n, connection, abstractDBMExtractionHandler, iterator3, "DIRECTORY");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("EXTERNAL TABLE") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getExternalTableSet().iterator();
                        list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "EXTERNAL TABLE");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("CONTEXT") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getContextSet().iterator();
                        list = SyncUtils.getSelectedObjectsNoSchema(string, n, connection, abstractDBMExtractionHandler, iterator3, "CONTEXT");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("CLUSTER") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getClusterSet().iterator();
                        list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "CLUSTER");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("SEQUENCE") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getSequenceSet().iterator();
                        list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "SEQUENCE");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("SYNONYM") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getSynonymSet().iterator();
                        list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "SYNONYM");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("DIMENSION") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getDimensionSet().iterator();
                        list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "DIMENSION");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("PACKAGE") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getPackageSet().iterator();
                        list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "PACKAGE");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (((SyncObject)object).getType().equals("PROCEDURE") && ((SyncObject)object).isUsed()) {
                        iterator3 = storageDesignOracle.getStoredProcedureSet().iterator();
                        list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "PROCEDURE");
                        arrayList.addAll(list);
                        continue;
                    }
                    if (!((SyncObject)object).getType().equals("FUNCTION") || !((SyncObject)object).isUsed()) continue;
                    iterator3 = storageDesignOracle.getFunctionSet().iterator();
                    list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "FUNCTION");
                    arrayList.addAll(list);
                }
                object = new ArrayList();
                storageDesignOracle.getCollectionTypeProxySet().addAllElementsTo((Collection)object);
                storageDesignOracle.getStructuredTypeProxySet().addAllElementsTo((Collection)object);
                iterator3 = object.iterator();
                list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "OBJECT");
                arrayList.addAll(list);
            }
            if (n == 2) {
                iterator3 = relationalDesign.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "DATATYPE");
                arrayList.addAll(list);
            } else if (n == 3) {
                iterator3 = relationalDesign.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "DATATYPE");
                arrayList.addAll(list);
            } else if (n == 4) {
                iterator3 = relationalDesign.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "DATATYPE");
                arrayList.addAll(list);
                iterator3 = relationalDesign.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "TYPE");
                arrayList.addAll(list);
                iterator3 = relationalDesign.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                list = SyncUtils.getSelectedObjects(string, n, connection, abstractDBMExtractionHandler, iterator3, "TYPE");
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public static List getSelectedObjects(String string, int n, Connection connection, AbstractDBMExtractionHandler abstractDBMExtractionHandler, Iterator iterator, String string2) throws Exception {
        String string3;
        String string4;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        List list = new ArrayList();
        while (iterator.hasNext()) {
            Object object;
            ModelObject modelObject = (ModelObject)iterator.next();
            RelationalDesign relationalDesign = modelObject.getDesign().getRelationalDesign();
            if (!"".equals(modelObject.getSourceConnName()) && !relationalDesign.isSameDB(string, modelObject.getSourceConnName())) continue;
            string4 = "";
            string3 = "";
            if (!"".equals(modelObject.getSourceConnName())) {
                string4 = modelObject.getSourceObjName().toUpperCase();
                string3 = modelObject.getSourceObjSchema().toUpperCase();
            } else {
                string4 = modelObject.getName().toUpperCase();
                if (modelObject instanceof DesignObject) {
                    string3 = ((DesignObject)modelObject).getSchema().toUpperCase();
                }
                if ("".equals(string3)) {
                    string3 = relationalDesign.getImportConnectionStamp(relationalDesign.findImportConnectionStamp(string)).getConnUser().toUpperCase();
                }
            }
            if (!"".equals(string3) && !treeMap.containsKey(string3)) {
                if (n != 2) {
                    treeMap.put(string3, new DBObject(true, string3));
                } else if (n == 2) {
                    Object object2;
                    String string5;
                    Object object3;
                    ModelIDObject modelIDObject;
                    object = relationalDesign.getStorageDesign();
                    if (object != null && object instanceof StorageDesignSqlServerv2k5) {
                        modelIDObject = (StorageDesignSqlServerv2k5)object;
                        object3 = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)modelIDObject).getSchemaSet().getByName(string3);
                        if (object3 != null) {
                            string5 = ((ModelObject)object3).getSourceObjSchema();
                            object2 = ((SchemaSqlServer)object3).getUid();
                            DBUserSqlServer dBUserSqlServer = new DBUserSqlServer(true, string3, "Schema");
                            dBUserSqlServer.setDb(string5);
                            dBUserSqlServer.setId((String)object2);
                            dBUserSqlServer.setUid((String)object2);
                            treeMap.put(string3, dBUserSqlServer);
                        }
                    } else if (object != null && object instanceof StorageDesignSqlServerv2k && (modelIDObject = (SchemaObject)relationalDesign.getSchemaObjectSet().getByName(string3)) != null) {
                        object3 = modelIDObject.getSourceObjSchema();
                        string5 = modelIDObject.getObjectID();
                        object2 = new DBUserSqlServer(true, string3, "Schema");
                        ((DBObjectSqlServer)object2).setDb((String)object3);
                        ((DBObjectSqlServer)object2).setId(string5);
                        ((DBUserSqlServer)object2).setUid(string5);
                        treeMap.put(string3, object2);
                    }
                }
            }
            object = (!"".equals(string3) ? string3 + "." : "") + string4;
            arrayList2.add(object);
        }
        if (!treeMap.isEmpty()) {
            list = abstractDBMExtractionHandler.getDBObjects(connection, new ArrayList(treeMap.values()), string2);
            for (DBObject dBObject : list) {
                string4 = dBObject.getSchema().toUpperCase();
                string3 = (!"".equals(string4) ? string4 + "." : "") + dBObject.getName().toUpperCase();
                if (!arrayList2.contains(string3)) continue;
                arrayList.add(dBObject);
            }
        }
        return arrayList;
    }

    public static List getSelectedObjectsNoSchema(String string, int n, Connection connection, AbstractDBMExtractionHandler abstractDBMExtractionHandler, Iterator iterator, String string2) throws Exception {
        String string3;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        TreeMap treeMap = new TreeMap();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List list = new ArrayList();
        while (iterator.hasNext()) {
            ModelObject modelObject = (ModelObject)iterator.next();
            RelationalDesign relationalDesign = modelObject.getDesign().getRelationalDesign();
            if (!"".equals(modelObject.getSourceConnName()) && !relationalDesign.isSameDB(string, modelObject.getSourceConnName())) continue;
            string3 = "";
            string3 = !"".equals(modelObject.getSourceConnName()) ? modelObject.getSourceObjName().toUpperCase() : modelObject.getName().toUpperCase();
            arrayList2.add(string3);
        }
        list = abstractDBMExtractionHandler.getDBObjects(connection, new ArrayList(treeMap.values()), string2);
        for (DBObject dBObject : list) {
            string3 = dBObject.getName().toUpperCase();
            if (!arrayList2.contains(string3)) continue;
            arrayList.add(dBObject);
        }
        return arrayList;
    }
}

