/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports;

import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.design.LogicalDataTypeStrings;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class MappingDatatypeNameLogicalDataType
implements LogicalDataTypeStrings {
    private static final Hashtable NAME_LOGICAL = new Hashtable();
    private static final Hashtable NAME_DESIGNER = new Hashtable();
    private static final Hashtable NAME_ERWIN = new Hashtable();
    private static final Logger LOGGER;
    private static Map rdbmsMap;
    private static Map ud_nativeMap;

    public static String getNameLogicalDatatype(String string) {
        if (string != null) {
            String string2 = (String)NAME_LOGICAL.get(string);
            if (string2 == null) {
                string2 = (String)NAME_LOGICAL.get(string.toUpperCase());
                if (string2 == null) {
                    return "unknown";
                }
                return string2;
            }
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer("null passed as parameter ");
        stringBuffer.append(" in MappingDatatypeNameLogicalDataType.getNameLogicalDatatype");
        LOGGER.error(stringBuffer.toString());
        return "unknown";
    }

    public static String getNameLogicalDatatype(RDBMSType rDBMSType, String string) {
        if (string != null) {
            LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(rDBMSType, string);
            if (logicalDatatype != null) {
                return logicalDatatype.getName();
            }
            return MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(string);
        }
        StringBuffer stringBuffer = new StringBuffer("null passed as parameter ");
        stringBuffer.append(" in MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(rdbms,nativeType)");
        LOGGER.error(stringBuffer.toString());
        return "unknown";
    }

    public static void addNativeToLogicalMapping(RDBMSType rDBMSType, String string, LogicalDatatype logicalDatatype) {
        TreeMap<String, LogicalDatatype> treeMap = (TreeMap<String, LogicalDatatype>)rdbmsMap.get(rDBMSType);
        if (treeMap == null) {
            treeMap = new TreeMap<String, LogicalDatatype>();
            rdbmsMap.put(rDBMSType, treeMap);
        }
        treeMap.put(string, logicalDatatype);
    }

    public static void removeNativeToLogicalMapping(RDBMSType rDBMSType, String string) {
        TreeMap treeMap = (TreeMap)rdbmsMap.get(rDBMSType);
        if (treeMap == null) {
            treeMap = new TreeMap();
            rdbmsMap.put(rDBMSType, treeMap);
        }
        treeMap.remove(string);
    }

    public static LogicalDatatype getLogicalDatatype(RDBMSType rDBMSType, String string) {
        LogicalDatatype logicalDatatype;
        Map map = null;
        for (RDBMSType rDBMSType2 = rDBMSType; rDBMSType2 != null; rDBMSType2 = rDBMSType2.getParentType()) {
            map = (Map)rdbmsMap.get(rDBMSType2);
            if (map == null || (logicalDatatype = (LogicalDatatype)map.get(string)) == null) continue;
            return logicalDatatype;
        }
        if (map != null) {
            logicalDatatype = (LogicalDatatype)map.get(string);
            return logicalDatatype;
        }
        return null;
    }

    public static String getDesignerMappedName(String string) {
        return (String)NAME_DESIGNER.get(string.toUpperCase());
    }

    public static String getERWinMappedName(String string) {
        return (String)NAME_ERWIN.get(string.toUpperCase());
    }

    public static Map getMappingsForRDBMSType(RDBMSType rDBMSType) {
        return (Map)rdbmsMap.get(rDBMSType);
    }

    public static void clearMappings() {
        rdbmsMap.clear();
    }

    public static void addUD_NativeType(RDBMSType rDBMSType, NativeDBType nativeDBType) {
        TreeMap<String, NativeDBType> treeMap = (TreeMap<String, NativeDBType>)ud_nativeMap.get(rDBMSType);
        if (treeMap == null) {
            treeMap = new TreeMap<String, NativeDBType>();
            ud_nativeMap.put(rDBMSType, treeMap);
        }
        treeMap.put(nativeDBType.getName(), nativeDBType);
    }

    public static void removeUD_NativeType(RDBMSType rDBMSType, NativeDBType nativeDBType) {
        Map map = (Map)ud_nativeMap.get(rDBMSType);
        if (map != null) {
            map.remove(nativeDBType.getName());
        }
    }

    static {
        rdbmsMap = new TreeMap();
        ud_nativeMap = new TreeMap();
        LOGGER = new Logger(MappingDatatypeNameLogicalDataType.class);
        NAME_LOGICAL.put("UNKNOWN", "unknown");
        NAME_LOGICAL.put("VARCHAR2", "VARCHAR");
        NAME_LOGICAL.put("VARCHAR", "VARCHAR");
        NAME_LOGICAL.put("CHAR", "CHAR");
        NAME_LOGICAL.put("SMALLINT", "SMALLINT");
        NAME_LOGICAL.put("INTEGER", "integer");
        NAME_LOGICAL.put("BIGINT", "BIGINT");
        NAME_LOGICAL.put("DECIMAL", "DECIMAL");
        NAME_LOGICAL.put("NUMERIC", "NUMERIC");
        NAME_LOGICAL.put("TIMESTAMP", "timestamp");
        NAME_LOGICAL.put("DATE", "date");
        NAME_LOGICAL.put("TIME", "time");
        NAME_LOGICAL.put("DOUBLE", "DOUBLE");
        NAME_LOGICAL.put("FLOAT", "FLOAT");
        NAME_LOGICAL.put("REAL", "REAL");
        NAME_LOGICAL.put("CLOB", "CLOB");
        NAME_LOGICAL.put("BLOB", "BLOB");
        NAME_LOGICAL.put("GRAPHIC", "doublebyte");
        NAME_LOGICAL.put("DATALINK", "DATALINK");
        NAME_LOGICAL.put("VARGRAPHIC", "image");
        NAME_LOGICAL.put("LONG", "NUMERIC");
        NAME_LOGICAL.put("LONG VARCHAR", "VARCHAR");
        NAME_LOGICAL.put("NUMBER", "NUMERIC");
        NAME_LOGICAL.put("ROWID", "ROWID");
        NAME_LOGICAL.put("BOOLEAN", "boolean");
        NAME_LOGICAL.put("TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH TIME ZONE");
        NAME_LOGICAL.put("TIMESTAMP WITH LOCAL TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE");
        NAME_LOGICAL.put("INTERVAL YEAR TO MONTH", "INTERVAL YEAR TO MONTH");
        NAME_LOGICAL.put("INTERVAL DAY TO SECOND", "INTERVAL DAY TO SECOND");
        NAME_LOGICAL.put("XMLTYPE", "XMLType");
        NAME_LOGICAL.put("URITYPE", "URIType");
        NAME_LOGICAL.put("HTTPURITYPE", "HTTPURIType");
        NAME_LOGICAL.put("XDBURITYPE", "XDBURIType");
        NAME_LOGICAL.put("DBURITYPE", "DBURIType");
        NAME_LOGICAL.put("SYS.ANYDATASET", "SYS_ANYDATASET");
        NAME_LOGICAL.put("SYS.ANYDATA", "SYS_ANYDATA");
        NAME_LOGICAL.put("SYS.ANYTYPE", "SYS_ANYTYPE");
        NAME_LOGICAL.put("ANYDATASET", "SYS_ANYDATASET");
        NAME_LOGICAL.put("ANYDATA", "SYS_ANYDATA");
        NAME_LOGICAL.put("ANYTYPE", "SYS_ANYTYPE");
        NAME_LOGICAL.put("ORDSYS.ORDAudio".toUpperCase(), "ORDSYS_ORDAUDIO");
        NAME_LOGICAL.put("ORDSYS.ORDImage".toUpperCase(), "ORDSYS_ORDIMAGE");
        NAME_LOGICAL.put("ORDSYS.ORDImageSignature".toUpperCase(), "ORDSYS_ORDIMAGE_SIGNATURE");
        NAME_LOGICAL.put("ORDSYS.ORDVideo".toUpperCase(), "ORDSYS_ORDVIDEO");
        NAME_LOGICAL.put("ORDSYS.ORDDoc".toUpperCase(), "ORDSYS_ORDDOC");
        NAME_LOGICAL.put("ORDAudio".toUpperCase(), "ORDSYS_ORDAUDIO");
        NAME_LOGICAL.put("ORDImage".toUpperCase(), "ORDSYS_ORDIMAGE");
        NAME_LOGICAL.put("ORDImageSignature".toUpperCase(), "ORDSYS_ORDIMAGE_SIGNATURE");
        NAME_LOGICAL.put("ORDVideo".toUpperCase(), "ORDSYS_ORDVIDEO");
        NAME_LOGICAL.put("ORDDoc".toUpperCase(), "ORDSYS_ORDDOC");
        NAME_LOGICAL.put("BINARY_FLOAT", "BINARY_FLOAT");
        NAME_LOGICAL.put("BINARY_DOUBLE", "BINARY_DOUBLE");
        NAME_LOGICAL.put("NCLOB", "NCLOB");
        NAME_LOGICAL.put("UNIQUEIDENTIFIER", "UNIQUEIDENTIFIER");
        NAME_LOGICAL.put("TEXT", "TEXT");
        NAME_LOGICAL.put("NVARCHAR", "NVARCHAR");
        NAME_LOGICAL.put("NTEXT", "NTEXT");
        NAME_LOGICAL.put("TINYINT", "TINYINT");
        NAME_LOGICAL.put("BIT", "BIT");
        NAME_LOGICAL.put("MONEY", "MONEY");
        NAME_LOGICAL.put("SMALLMONEY", "SMALLMONEY");
        NAME_LOGICAL.put("DATETIME", "datetime");
        NAME_LOGICAL.put("SMALLDATETIME", "SMALLDATETIME");
        NAME_LOGICAL.put("BINARY", "BINARY");
        NAME_LOGICAL.put("VARBINARY", "VARBINARY");
        NAME_LOGICAL.put("IMAGE", "image");
        NAME_LOGICAL.put("SQL_VARIANT", "SQL_VARIANT");
        NAME_LOGICAL.put("SYSNAME", "SYSNAME");
        NAME_LOGICAL.put("NCHAR", "NCHAR");
        NAME_LOGICAL.put("XML", "XMLType");
        NAME_DESIGNER.put("VARGRAPHIC", "VARCHAR2");
        NAME_DESIGNER.put("TEXT", "CLOB");
        NAME_DESIGNER.put("IMAGE", "BLOB");
        NAME_DESIGNER.put("SOUND", "BLOB");
        NAME_DESIGNER.put("GRAPHIC", "BLOB");
        NAME_DESIGNER.put("VIDEO", "BLOB");
        NAME_DESIGNER.put("MONEY", "NUMERIC");
        NAME_DESIGNER.put("PHOTOGRAPH", "BLOB");
        NAME_DESIGNER.put("TIME", "timestamp");
        NAME_ERWIN.put("ORDAudio".toUpperCase(), "ORDAUDIO");
        NAME_ERWIN.put("ORDDoc".toUpperCase(), "ORDDOC");
        NAME_ERWIN.put("ORDImage".toUpperCase(), "ORDIMAGE");
        NAME_ERWIN.put("ORDImageSignature".toUpperCase(), "ORDIMAGE_SIGNATURE");
        NAME_ERWIN.put("ORDVideo".toUpperCase(), "ORDVIDEO");
    }
}

