/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands.compare;

import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareFrame;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.ide.Ide;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;

public abstract class SVNAbstractCompareCommand
extends AbstractSVNOperation {
    protected static final String CURRENT_REVISION = Messages.getString("SVNAbstractCompareCommand.CurrentRevision");
    protected static final String HEAD_REVISION = Messages.getString("SVNAbstractCompareCommand.HeadRevision");
    protected static final String LAST_LOCAL_REVISION = Messages.getString("SVNAbstractCompareCommand.LastLocalRevision");
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    protected SVNAbstractCompareCommand(String string) {
        super(string);
    }

    protected abstract InputStream getLeftText(File var1) throws FileNotFoundException;

    protected abstract String getLeftTextTitle();

    protected boolean isCompareAsText() {
        return false;
    }

    public XMLMetadataComparator getComparator(VersioningTreeNode versioningTreeNode) throws FileNotFoundException {
        File file = versioningTreeNode.getFilePath();
        InputStream inputStream = this.getLeftText(file);
        FileInputStream fileInputStream = new FileInputStream(file);
        if (inputStream != null) {
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            Design design = storableObjectStatus.getDesign();
            String string = storableObjectStatus.getStorableObjectID();
            StorageDesign storageDesign = SVN_CLIENT_HELPER.findStorageDesign(design, string);
            return new XMLMetadataComparator(storableObjectStatus.getDesign(), storageDesign, inputStream, this.getLeftTextTitle(), fileInputStream, CURRENT_REVISION, true);
        }
        return null;
    }

    public boolean isAvailable() {
        String string;
        DataModelerChangeList dataModelerChangeList;
        StorableObjectStatus storableObjectStatus;
        return SVN_CLIENT_HELPER.actionsEnabled(null, this.context, true, true, true, false, false, true, false, true) && (storableObjectStatus = (dataModelerChangeList = (DataModelerChangeList)((SVNChangeListWindow)this.context.getView()).getContextChangeList()).getPanel().getSelectedNode().getStorableObjectStatus()) != null && ("M".equals(string = storableObjectStatus.getTextStatus()) || "C".equals(string));
    }

    protected int doitImpl(VCSProfile vCSProfile) throws Exception {
        DataModelerChangeList dataModelerChangeList = (DataModelerChangeList)((SVNChangeListWindow)this.context.getView()).getContextChangeList();
        VersioningTreeNode versioningTreeNode = dataModelerChangeList.getPanel().getSelectedNode();
        this.compare(versioningTreeNode);
        return 0;
    }

    protected void compare(VersioningTreeNode versioningTreeNode) throws FileNotFoundException {
        if (this.isCompareAsText()) {
            this.compareAsText(versioningTreeNode);
        } else {
            this.compareAsObject(versioningTreeNode);
        }
    }

    protected void compareAsText(VersioningTreeNode versioningTreeNode) throws FileNotFoundException {
        final File file = versioningTreeNode.getFilePath();
        InputStream inputStream = this.getLeftText(file);
        if (inputStream != null) {
            FileInputStream fileInputStream = new FileInputStream(file);
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            VCSTextCompareFrame vCSTextCompareFrame = new VCSTextCompareFrame((Window)Ide.getMainWindow(), file, inputStream, this.getLeftTextTitle(), fileInputStream, CURRENT_REVISION, true, false, storableObjectStatus){

                @Override
                public void beforeSave() {
                    SVNAbstractCompareCommand.this.resolveConflict(file);
                }
            };
            vCSTextCompareFrame.showModal();
        }
    }

    protected void compareAsObject(VersioningTreeNode versioningTreeNode) throws FileNotFoundException {
        Map map;
        File file = versioningTreeNode.getFilePath();
        StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
        XMLMetadataComparator xMLMetadataComparator = this.getComparator(versioningTreeNode);
        if (xMLMetadataComparator != null && (map = xMLMetadataComparator.showModal()) != null) {
            this.resolveConflict(file);
            SVN_CLIENT_HELPER.merge(storableObjectStatus, file, map);
            SVNChangeListWindow.getSVNOutgoingChangesChangeList().refresh();
        }
    }

    protected void resolveConflict(File file) {
        SVN_CLIENT_HELPER.doUpdate(new File[]{file}, true);
        SVN_CLIENT_HELPER.doResolved(file);
        this.updateChangeLists(file);
    }

    private void updateChangeLists(File file) {
        IChangeListPanel iChangeListPanel = SVNChangeListWindow.getSVNIncomingChangesChangeList().getPanel();
        List<StorableObjectStatus> list = iChangeListPanel.getStatuses();
        if (list != null) {
            boolean bl = false;
            for (int i = list.size() - 1; i >= 0; --i) {
                StorableObjectStatus storableObjectStatus = list.get(i);
                if (!storableObjectStatus.getFilePath().equals(file)) continue;
                list.remove(storableObjectStatus);
                bl = true;
            }
            if (bl) {
                iChangeListPanel.update(list);
            }
        }
    }
}

