/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.VersionOperationPanel;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.UnLockOptionsCustomizer;

public class SVNUnlockCommand
extends AbstractSVNOperation {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.unlock" : SVNUnlockCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.unlock", SVNUnlockCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNUnlockCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    protected boolean isAvailableImpl() throws Exception {
        return SVN_CLIENT_HELPER.actionsEnabled(null, this.getContext(), true, true, false, false, false, true, false, true);
    }

    protected int doitImpl() throws Exception {
        CommandState commandState = VCSClientHelper.createCommandState(this.context.getView(), true);
        super.invokeCommand(this.getProfile(), commandState);
        return 0;
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo("oracle.jdeveloper.subversion.unlock");
    }

    protected boolean invokeCommandImpl(VCSProfile vCSProfile, CommandState commandState, Component component, Map map) throws Exception {
        Locatable[] locatableArray = commandState.getLocatables();
        if (locatableArray.length > 0) {
            List<File> list = DisplayableLocatableNode.convertToFileList(locatableArray, true);
            for (int i = list.size() - 1; i >= 0; --i) {
                File file = list.get(i);
                if (SVN_CLIENT_HELPER.getRevision(file) <= 0L) {
                    list.remove(i);
                    continue;
                }
                if (SVN_CLIENT_HELPER.isLockedInWC(file)) continue;
                list.remove(i);
            }
            if (list.size() > 0) {
                SVN_CLIENT_HELPER.doUnlock(list.toArray(new File[0]), (Boolean)map.get("oracle.jdeveloper.subversion.STEAL_LOCKS"));
            }
        }
        return true;
    }

    protected JEWTDialog createOperationDialog(Collection collection, VCSOptionsCustomizer vCSOptionsCustomizer, CommandState commandState) {
        VersionOperationPanel versionOperationPanel = SVN_CLIENT_HELPER.createVersionOperationTablePanel((List)collection);
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)versionOperationPanel, (Component)(vCSOptionsCustomizer != null ? vCSOptionsCustomizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(vCSOptionsCustomizer != null ? vCSOptionsCustomizer.getInitialFocusComponent() : null));
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        UnLockOptionsCustomizer unLockOptionsCustomizer = new UnLockOptionsCustomizer();
        return unLockOptionsCustomizer;
    }
}

