/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeWindow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.log.LogManager;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.SVNOperationMerge;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRepositoryBrowser;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNMergeDesignCommand
extends SVNOperationMerge {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.mergewc" : SVNMergeDesignCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.mergewc", SVNMergeDesignCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNMergeDesignCommand() {
        super(COMMAND_ID);
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    protected boolean isAvailableImpl() throws Exception {
        return ApplicationView.getInstance().getCurrentDesign().isVersioned();
    }

    protected int doitImpl(VCSProfile vCSProfile) throws Exception {
        SVNUrl sVNUrl = SVNMergeDesignCommand.showMergeDialog();
        if (sVNUrl != null) {
            DockStation dockStation = DockStation.getDockStation();
            SVNMergeWindow sVNMergeWindow = (SVNMergeWindow)dockStation.getDockable(SVNMergeWindow.VIEW_ID);
            if (sVNMergeWindow == null) {
                sVNMergeWindow = SVNMergeWindow.getInstance();
                DockingParam dockingParam = new DockingParam();
                dockingParam.setPosition((Dockable)LogManager.getIdeLogWindow(), 4);
                dockStation.dock((Dockable)sVNMergeWindow, dockingParam);
            }
            sVNMergeWindow.setMergeUrl(sVNUrl);
            sVNMergeWindow.show();
            dockStation.activateDockable((Dockable)sVNMergeWindow);
            return 0;
        }
        return 1;
    }

    public static SVNUrl showMergeDialog() throws MalformedURLException {
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        JPanel jPanel2 = new JPanel(new BorderLayout(12, 12));
        JTextField jTextField = new JTextField();
        JButton jButton = new JButton(Messages.getString("SVNMergeDesignCommand.Browse"));
        File file = new File(ApplicationView.getInstance().getCurrentDesign().getStoragePath());
        ISVNInfo iSVNInfo = SVN_CLIENT_HELPER.doInfo(file);
        SVNUrl sVNUrl = iSVNInfo.getUrl().getParent();
        BrowseActionListener browseActionListener = new BrowseActionListener(sVNUrl, jTextField);
        jTextField.setText(sVNUrl.toString());
        jTextField.setPreferredSize(new Dimension(250, (int)jTextField.getPreferredSize().getHeight()));
        jButton.addActionListener(browseActionListener);
        jPanel2.add(jTextField);
        jPanel2.add((Component)new JLabel(Messages.getString("SVNMergeDesignCommand.MergeFromURL")), "West");
        jPanel2.add((Component)jButton, "East");
        jPanel.add((Component)jPanel2, "North");
        while (OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jTextField, (String)Messages.getString("SVNMergeDesignCommand.MergeDesign"), (int)7)) {
            String string;
            StringBuilder stringBuilder = new StringBuilder(jTextField.getText());
            String string2 = ApplicationView.getInstance().getCurrentDesign().getName() + ".dmd";
            if (stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
                stringBuilder.append('/');
            }
            if (SVN_CLIENT_HELPER.exists((string = stringBuilder.toString()) + string2)) {
                return new SVNUrl(string);
            }
            MessageDialogs.showWarningMessage(Messages.getString("SVNMergeDesignCommand.InvalidDesign"));
        }
        return null;
    }

    private static final class RepoBrowserObserver
    implements Observer {
        private JTextField tfMergeUrl;

        private RepoBrowserObserver(JTextField jTextField) {
            this.tfMergeUrl = jTextField;
        }

        @Override
        public void update(Observable observable, Object object) {
            this.tfMergeUrl.setText(object.toString());
        }
    }

    private static class BrowseActionListener
    implements ActionListener {
        private SVNUrl url;
        private JTextField tfMergeUrl;

        private BrowseActionListener(SVNUrl sVNUrl, JTextField jTextField) {
            this.url = sVNUrl;
            this.tfMergeUrl = jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SVNRepositoryInfo sVNRepositoryInfo = SVNUtil.resolveRepository((SVNUrl)this.url);
            SVNUrl sVNUrl = null;
            RepoBrowserObserver repoBrowserObserver = new RepoBrowserObserver(this.tfMergeUrl);
            String string = this.tfMergeUrl.getText();
            SVNRepositoryBrowser sVNRepositoryBrowser = null;
            if (StringUtilities.isNotEmpty(string)) {
                try {
                    sVNUrl = new SVNUrl(string);
                }
                catch (MalformedURLException malformedURLException) {
                    MessageDialogs.showWarningMessage(Messages.getString("SVNMergeDesignCommand.InvalidURL"));
                }
            }
            sVNRepositoryBrowser = sVNUrl == null ? new SVNRepositoryBrowser(sVNRepositoryInfo) : new SVNRepositoryBrowser(sVNRepositoryInfo, sVNUrl);
            sVNRepositoryBrowser.addObserver((Observer)repoBrowserObserver);
            sVNRepositoryBrowser.showBrowser();
        }
    }
}

