/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.ChangeListTreePanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNOutgoingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.commands.DMSVNOperationCommit;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.xspi.ALMCommitContext;
import oracle.jdevimpl.vcs.xspi.XVCSCommandState;
import oracle.jdevimpl.vcs.xspi.XVCSComponents;

public class SVNCommitCommand
extends DMSVNOperationCommit {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.commit" : SVNCommitCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.commit", SVNCommitCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNCommitCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo("oracle.jdeveloper.subversion.commit");
    }

    protected boolean isSilent(Context context, VCSProfile vCSProfile) {
        return true;
    }

    public boolean isAvailableImpl() {
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        ChangeListTreePanel changeListTreePanel = (ChangeListTreePanel)SVNChangeListWindow.getSVNOutgoingChangesChangeList().getPanel();
        if (changeListTreePanel.getTree().getSelectionCount() > 0) {
            changeListTreePanel.getSelectedFilePaths(arrayList, true, true);
            if (arrayList.size() == 1 && ((VersioningTreeNode)arrayList.get(0)).getStorableObjectStatus().isMissing()) {
                return false;
            }
        }
        return SVN_CLIENT_HELPER.actionsEnabled(SVNChangeListWindow.getSVNOutgoingChangesChangeList(), null, false, false, false, true, true, false, false, false);
    }

    protected int doitImpl(VCSProfile vCSProfile) throws Exception {
        SVNOutgoingChangesChangeList sVNOutgoingChangesChangeList = SVNChangeListWindow.getSVNOutgoingChangesChangeList();
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        XVCSCommandState xVCSCommandState = new XVCSCommandState();
        this.collectTreeNodes(sVNOutgoingChangesChangeList, arrayList);
        this.removeMissingAndDeletedDependantNodes(arrayList);
        xVCSCommandState.setLocatables(arrayList.toArray(new Locatable[0]));
        super.invokeCommand(vCSProfile, (CommandState)xVCSCommandState);
        sVNOutgoingChangesChangeList.refresh();
        return 0;
    }

    protected void collectTreeNodes(SVNOutgoingChangesChangeList sVNOutgoingChangesChangeList, List<VersioningTreeNode> list) {
        sVNOutgoingChangesChangeList.getPanel().getSelectedFilePaths(list, true, true);
    }

    protected void removeMissingAndDeletedDependantNodes(List<VersioningTreeNode> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            VersioningTreeNode versioningTreeNode = list.get(i);
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            if ((!storableObjectStatus.isDeleted() || versioningTreeNode.getDependingOn() == null) && !storableObjectStatus.isMissing()) continue;
            list.remove(i);
        }
    }

    @Override
    protected void invokeCommit(VCSProfile vCSProfile, CommandState commandState, Map map, IndeterminateProgressMonitor indeterminateProgressMonitor) throws Exception {
        Locatable[] locatableArray = commandState.getLocatables();
        ArrayList<File> arrayList = new ArrayList<File>(locatableArray.length);
        for (Locatable locatable : locatableArray) {
            VersioningTreeNode versioningTreeNode = (VersioningTreeNode)locatable;
            this.findNotAddedParents(versioningTreeNode, arrayList);
            arrayList.add(versioningTreeNode.getFilePath());
            File file = versioningTreeNode.getDependantFilePath();
            if (file == null) continue;
            arrayList.add(file);
        }
        Collections.sort(arrayList);
        SVN_CLIENT_HELPER.doCommit(arrayList.toArray(new File[0]), (String)map.get("setting_comments"), false, (Boolean)map.get("oracle.jdeveloper.subversion.KEEP_LOCKS"));
    }

    @Override
    protected JEWTDialog createOperationDialog(Collection collection, VCSOptionsCustomizer vCSOptionsCustomizer, CommandState commandState) {
        return XVCSComponents.createCommitOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)SVN_CLIENT_HELPER.createVersionOperationTablePanel((List)collection), (VCSOptionsCustomizer)vCSOptionsCustomizer, (String)this.getHelpTopicId(), (ALMCommitContext)((XVCSCommandState)commandState).getALMCommitContext());
    }

    public void findNotAddedParents(VersioningTreeNode versioningTreeNode, List<File> list) {
        StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
        if (storableObjectStatus != null && "A".equals(storableObjectStatus.getTextStatus())) {
            this.findNotAddedParents(versioningTreeNode.getFilePath(), list);
        }
    }

    public void findNotAddedParents(File file, List<File> list) {
        File file2 = file.getParentFile();
        if (SVN_CLIENT_HELPER.isVersioned(file2) && SVN_CLIENT_HELPER.getLastChangedRevision(file2) <= 0L) {
            list.add(file2);
            this.findNotAddedParents(file2, list);
        }
    }
}

