/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.SVNOperationCommit;
import oracle.jdevimpl.vcs.svn.op.ui.CommitOptionsCustomizer;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.NotifyListenerAdapter;
import oracle.jdevimpl.vcs.svn.util.SVNComponents;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.xspi.ALMCommitContext;
import oracle.jdevimpl.vcs.xspi.ALMCommitFile;
import oracle.jdevimpl.vcs.xspi.ALMCommitManager;
import oracle.jdevimpl.vcs.xspi.XVCSCommandState;
import oracle.jdevimpl.vcs.xspi.XVCSComponents;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;

public class DMSVNOperationCommit
extends AbstractSVNOperation {
    private static VCSRecentCommentsModel _recentCommentsModel;
    IndeterminateProgressMonitor progress;
    private static final int UPDATE_NOT_NEEDED = 0;
    private static final int UPDATE_SUCCESSFUL = 1;
    private static final int UPDATE_FAILED = 2;
    private static final int UPDATE_CONFLICT = 3;

    public DMSVNOperationCommit(String string) {
        super(string);
    }

    protected boolean invokeCommand(VCSProfile vCSProfile, CommandState commandState) throws Exception {
        if (this.getId() == Ide.findCmdID((String)"oracle.jdeveloper.subversion.commit").intValue() && !this.isSilent(this.getContext(), vCSProfile)) {
            URL uRL;
            URL[] uRLArray = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
            URL uRL2 = uRL = uRLArray.length > 0 ? SVNUtil.resolveWorkingCopy((URL)uRLArray[0]) : null;
            if (uRL != null && !URLFileSystem.equals((URL)uRL, (URL)uRLArray[0]) && vCSProfile.getStatusCache().get(uRL) == vCSProfile.getStatusInstance("MODIFIED")) {
                int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)Resource.get((String)"ACTION_COMMIT_CONFIRM_WORKING_COPY_COMMIT"), (String)Resource.get((String)"ACTION_COMMIT_CONFIRM_WORKING_COPY_COMMIT_TITLE"), null, (boolean)false);
                if (n == -1) {
                    return false;
                }
                if (n == 1) {
                    IdeAction.find((int)Ide.findCmdID((String)"oracle.jdeveloper.subversion.commit-workingcopy")).performAction(this.getContext());
                    return true;
                }
            }
        }
        return super.invokeCommand(vCSProfile, commandState);
    }

    public static final VCSRecentCommentsModel getRecentCommentsModel() {
        if (_recentCommentsModel == null) {
            _recentCommentsModel = new VCSRecentCommentsModel();
        }
        return _recentCommentsModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommandImpl(VCSProfile vCSProfile, CommandState commandState, Component component, Map map) throws Exception {
        this.progress = new IndeterminateProgressMonitor(component, this._res.getString("ACTION_COMMIT_PROGRESS_TITLE"));
        this.progress.setMillisToPopup(0);
        this.progress.setCloseOnFinish(true);
        this.progress.setCancellable(false);
        this.progress.start();
        try {
            this.invokeCommit(vCSProfile, commandState, map, this.progress);
        }
        finally {
            if (!this.progress.isCancelled()) {
                this.progress.finish();
            }
        }
        return true;
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile vCSProfile, CommandState commandState, Map map) throws Exception {
        this.invokeCommit(vCSProfile, commandState, map, null);
        return true;
    }

    protected CommandState createCommandState() {
        return new XVCSCommandState();
    }

    protected void configureCommandState(CommandState commandState, VCSDirectoryInvokableState vCSDirectoryInvokableState, Map map, Locatable[] locatableArray) {
        super.configureCommandState(commandState, vCSDirectoryInvokableState, map, locatableArray);
        URL[] uRLArray = VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs((Locatable[])locatableArray));
        try {
            SVNRepositoryInfo sVNRepositoryInfo = SVNUtil.getFirstAssociatedRepository((URL[])uRLArray);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("url", sVNRepositoryInfo.getURL().toString());
            ((XVCSCommandState)commandState).setALMCommitContext(new ALMCommitContext("oracle.jdeveloper.subversion", hashMap));
        }
        catch (SVNClientException sVNClientException) {
            Assert.printStackTrace((Throwable)sVNClientException);
        }
    }

    protected VCSOptionsCustomizer createOptionsCustomizer(Collection collection) {
        VCSCommentsCustomizer vCSCommentsCustomizer = new VCSCommentsCustomizer((VCSOptionsCustomizer)new CommitOptionsCustomizer());
        vCSCommentsCustomizer.setShowReuseCommentsOption(false);
        vCSCommentsCustomizer.setRecentCommentsModel(SVNOperationCommit.getRecentCommentsModel());
        vCSCommentsCustomizer.setShowTemplatesAndCommentsCombo(true);
        VCSProfile vCSProfile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        vCSCommentsCustomizer.setClientSetting(vCSProfile.getSettings());
        vCSCommentsCustomizer.setTemplatesDataKey(vCSProfile.getQualifiedDataKey("COMMENT_TEMPLATES"));
        vCSCommentsCustomizer.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)Resource.get((String)"SVN_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        vCSCommentsCustomizer.setContextURLs(VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs((Collection)collection)));
        return vCSCommentsCustomizer;
    }

    protected JEWTDialog createOperationDialog(Collection collection, VCSOptionsCustomizer vCSOptionsCustomizer, CommandState commandState) {
        return XVCSComponents.createCommitOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)SVNComponents.createFileListerComponent((Collection)collection), (VCSOptionsCustomizer)vCSOptionsCustomizer, (String)this.getHelpTopicId(), (ALMCommitContext)((XVCSCommandState)commandState).getALMCommitContext());
    }

    protected Locatable[] getOperands(VCSProfile vCSProfile) throws Exception {
        Locatable[] locatableArray = super.getOperands(vCSProfile);
        return this.createChangeListItems(this.getUrlArray(locatableArray));
    }

    protected boolean saveDirtyNodes(Locatable[] locatableArray) throws Exception {
        Locatable[] locatableArray2 = super.getOperands(this.getProfile());
        return VCSCommandUtils.saveDirtyNodes((Locatable[])locatableArray2);
    }

    private URL[] getUrlArray(Locatable[] locatableArray) {
        URL[] uRLArray = new URL[locatableArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            uRLArray[i] = locatableArray[i].getURL();
        }
        return uRLArray;
    }

    private ChangeListItem[] createChangeListItems(URL[] uRLArray) {
        ChangeListItem[] changeListItemArray = new ChangeListItem[uRLArray.length];
        VCSOverlayItemProducer vCSOverlayItemProducer = new VCSOverlayItemProducer(this.getStatusCache());
        for (int i = 0; i < uRLArray.length; ++i) {
            changeListItemArray[i] = this.createChangeListItem(uRLArray[i], vCSOverlayItemProducer);
        }
        return changeListItemArray;
    }

    private ChangeListItem createChangeListItem(URL uRL, VCSOverlayItemProducer vCSOverlayItemProducer) {
        VCSOverlayItem vCSOverlayItem = null;
        try {
            vCSOverlayItem = vCSOverlayItemProducer != null ? vCSOverlayItemProducer.getOverlayItems(new URL[]{uRL})[0] : null;
        }
        catch (Exception exception) {
            SVNProfile.getQualifiedLogger((String)((Object)((Object)this)).getClass().getName()).warning(exception.getMessage());
        }
        return new ChangeListItem(uRL, vCSOverlayItem != null ? vCSOverlayItem.getOverlay() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeCommit(VCSProfile vCSProfile, CommandState commandState, Map map, IndeterminateProgressMonitor indeterminateProgressMonitor) throws Exception {
        String string = this.getComments(map);
        boolean bl = this.getKeepLocks(map);
        URL[] uRLArray = VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables()));
        SVNRepositoryInfo sVNRepositoryInfo = SVNUtil.getFirstAssociatedRepository((URL[])uRLArray);
        if (this.checkUpdate(sVNRepositoryInfo, uRLArray) == 3) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_COMMIT_INTERRUPTED_CONFLICT_MESSAGE"), (String)this._res.getString("ACTION_COMMIT_INTERRUPTED_CONFLICT_TITLE"), null);
            return;
        }
        try {
            Object object;
            ISVNClientAdapter iSVNClientAdapter = SVNUtil.getIDEClientAdapter();
            if (indeterminateProgressMonitor != null) {
                SVNOperationLogger.getInstance().beginOperation(iSVNClientAdapter, sVNRepositoryInfo, indeterminateProgressMonitor);
            } else {
                SVNOperationLogger.getInstance().beginOperation(iSVNClientAdapter, sVNRepositoryInfo);
            }
            this.commitParents(vCSProfile, iSVNClientAdapter, uRLArray, string, bl);
            final XVCSCommandState xVCSCommandState = (XVCSCommandState)commandState;
            ALMCommitContext aLMCommitContext = xVCSCommandState.getALMCommitContext();
            NotifyListenerAdapter notifyListenerAdapter = null;
            if (aLMCommitContext != null && aLMCommitContext.canCommitToALM()) {
                final SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(null);
                notifyListenerAdapter = new NotifyListenerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void onNotify(File file, SVNNodeKind sVNNodeKind) {
                        if (!sVNNodeKind.equals((Object)SVNNodeKind.FILE)) {
                            return;
                        }
                        try {
                            sVNWCAccess.open(file.getParentFile(), false, 0);
                            SVNEntry sVNEntry = sVNWCAccess.retrieve(file.getParentFile()).getEntry(file.getName(), true);
                            if (sVNEntry == null) {
                                return;
                            }
                            String string = sVNEntry.getRepositoryRootURL().toString();
                            String string2 = sVNEntry.getSVNURL().toString();
                            if (!string.endsWith("/")) {
                                string = string + '/';
                            }
                            if (!string2.startsWith(string)) {
                                return;
                            }
                            ArrayList<ALMCommitFile> arrayList = xVCSCommandState.getALMCommitFiles();
                            if (arrayList == null) {
                                arrayList = new ArrayList<ALMCommitFile>();
                                xVCSCommandState.setALMCommitFiles(arrayList);
                            }
                            arrayList.add(new ALMCommitFile(string2.substring(string.length()), null));
                            return;
                        }
                        catch (SVNException sVNException) {
                            FeedbackManager.reportException((Throwable)sVNException);
                            return;
                        }
                        finally {
                            try {
                                sVNWCAccess.close();
                            }
                            catch (SVNException sVNException) {}
                        }
                    }
                };
                iSVNClientAdapter.addNotifyListener((ISVNNotifyListener)notifyListenerAdapter);
            }
            long l = iSVNClientAdapter.commit(SVNUtil.toFiles((URL[])uRLArray), string, true, bl);
            if (notifyListenerAdapter != null) {
                iSVNClientAdapter.removeNotifyListener((ISVNNotifyListener)notifyListenerAdapter);
            }
            if (aLMCommitContext != null && aLMCommitContext.canCommitToALM()) {
                object = String.valueOf(l);
                if (xVCSCommandState.getALMCommitFiles() != null) {
                    for (ALMCommitFile aLMCommitFile : xVCSCommandState.getALMCommitFiles()) {
                        aLMCommitFile.setRevision((String)object);
                    }
                }
                aLMCommitContext.setVCSRevisionName((String)object);
            }
            object = this.getProcessedUrlsNotifier(commandState);
            object.addAll(Arrays.asList(uRLArray));
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            commandState.setProperty("oracle.jdeveloper.subversion.RECURSIVE", (Object)Boolean.TRUE);
        }
    }

    protected void postInvoke(VCSProfile vCSProfile, CommandState commandState) throws Exception {
        super.postInvoke(vCSProfile, commandState);
        ALMCommitManager.getALMCommitManager().executeCommitWorker((XVCSCommandState)commandState);
    }

    protected int checkUpdate(SVNRepositoryInfo sVNRepositoryInfo, URL[] uRLArray) throws SVNClientException, Exception {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.doCheckUpdate(sVNRepositoryInfo, uRLArray, arrayList)) {
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_COMMIT_NEED_UPDATE_MESSAGE"), (String)this._res.getString("ACTION_COMMIT_NEED_UPDATE_TITLE"), null)) {
                return this.doUpdate(sVNRepositoryInfo, arrayList);
            }
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckUpdate(SVNRepositoryInfo sVNRepositoryInfo, URL[] uRLArray, List<File> list) throws SVNClientException {
        boolean bl = false;
        try {
            ISVNClientAdapter iSVNClientAdapter = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(iSVNClientAdapter, sVNRepositoryInfo);
            File[] fileArray = SVNUtil.toFiles((URL[])uRLArray);
            for (int i = 0; i < fileArray.length; ++i) {
                ISVNStatus iSVNStatus = iSVNClientAdapter.getSingleStatus(fileArray[i]);
                if (iSVNStatus.getRepositoryTextStatus().equals((Object)SVNStatusKind.NONE)) {
                    break;
                }
                ISVNInfo iSVNInfo = iSVNClientAdapter.getInfo(fileArray[i]);
                Long l = iSVNInfo.getLastChangedRevision().getNumber();
                iSVNInfo = iSVNClientAdapter.getInfoFromWorkingCopy(fileArray[i]);
                Long l2 = iSVNInfo.getRevision().getNumber();
                if (l <= l2) continue;
                bl = true;
                list.add(fileArray[i]);
            }
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doUpdate(SVNRepositoryInfo sVNRepositoryInfo, List<File> list) throws Exception {
        File[] fileArray = list.toArray(new File[0]);
        try {
            ISVNClientAdapter iSVNClientAdapter = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(iSVNClientAdapter, sVNRepositoryInfo);
            long[] lArray = iSVNClientAdapter.update(fileArray, SVNRevision.HEAD, true, true);
            ISVNStatus[] iSVNStatusArray = iSVNClientAdapter.getStatus(fileArray);
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                if (!iSVNStatusArray[i].getTextStatus().equals((Object)SVNStatusKind.CONFLICTED) && !iSVNStatusArray[i].getPropStatus().equals((Object)SVNStatusKind.CONFLICTED)) continue;
                int n = 3;
                return n;
            }
        }
        catch (Exception exception) {
            int n = 2;
            return n;
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
        return 1;
    }

    private boolean getKeepLocks(Map map) {
        Boolean bl = (Boolean)map.get("oracle.jdeveloper.subversion.KEEP_LOCKS");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private String getComments(Map map) {
        String string = (String)map.get("setting_comments");
        return string != null ? string : "";
    }

    private void commitParents(VCSProfile vCSProfile, ISVNClientAdapter iSVNClientAdapter, URL[] uRLArray, String string, boolean bl) throws Exception {
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL = URLFileSystem.getParent((URL)uRLArray[i]);
            if (uRL == null) continue;
            this.commitParent(vCSProfile, iSVNClientAdapter, uRL, string, bl);
        }
    }

    private void commitParent(VCSProfile vCSProfile, ISVNClientAdapter iSVNClientAdapter, URL uRL, String string, boolean bl) throws Exception {
        VCSStatus vCSStatus;
        VCSStatusFilter vCSStatusFilter = vCSProfile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.ADDED");
        if (vCSStatusFilter.accept(vCSStatus = vCSProfile.getStatusCache().get(uRL))) {
            URL uRL2 = URLFileSystem.getParent((URL)uRL);
            if (uRL2 != null) {
                this.commitParent(vCSProfile, iSVNClientAdapter, uRL2, string, bl);
            }
            iSVNClientAdapter.commit(new File[]{SVNUtil.toFile((URL)uRL)}, string, false, bl);
            vCSProfile.getStatusCache().clear(uRL);
        }
    }
}

