/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.io.File;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNStorableObjectStatus
extends StorableObjectStatus {
    private ISVNStatus svnStatus;
    private Long revision;

    public SVNStorableObjectStatus(StorableObject storableObject) {
        super(storableObject);
    }

    public SVNStorableObjectStatus(Design design, File file, String string, String string2, Long l) {
        this.design = design;
        this.filePath = file;
        this.textStatus = string;
        this.propertyStatus = string2;
        this.revision = l;
        this.parse(file, null);
    }

    public SVNStorableObjectStatus(Design design, ISVNStatus iSVNStatus, boolean bl) {
        this.design = design;
        this.svnStatus = iSVNStatus;
        this.remoteStatus = bl;
        this.filePath = iSVNStatus.getFile();
        this.extractStatuses(iSVNStatus, bl);
        this.parse(this.filePath, (SVNUrl)(!bl && "A".equals(this.textStatus) ? null : iSVNStatus.getUrl()));
    }

    protected void extractStatuses(ISVNStatus iSVNStatus, boolean bl) {
        SVNStatusKind sVNStatusKind;
        SVNStatusKind sVNStatusKind2;
        if (bl) {
            sVNStatusKind2 = iSVNStatus.getRepositoryTextStatus();
            sVNStatusKind = iSVNStatus.getRepositoryPropStatus();
        } else {
            sVNStatusKind2 = iSVNStatus.getTextStatus();
            sVNStatusKind = iSVNStatus.getPropStatus();
        }
        this.textStatus = this.extractStatus(sVNStatusKind2);
        this.propertyStatus = this.extractStatus(sVNStatusKind);
    }

    protected String extractStatus(SVNStatusKind sVNStatusKind) {
        if (sVNStatusKind == SVNStatusKind.UNVERSIONED) {
            return "A";
        }
        if (sVNStatusKind == SVNStatusKind.MISSING) {
            return "MI";
        }
        if (sVNStatusKind == SVNStatusKind.ADDED) {
            return "A";
        }
        if (sVNStatusKind == SVNStatusKind.MODIFIED) {
            return "M";
        }
        if (sVNStatusKind == SVNStatusKind.DELETED) {
            return "D";
        }
        if (sVNStatusKind == SVNStatusKind.CONFLICTED) {
            return "C";
        }
        if (sVNStatusKind == SVNStatusKind.NORMAL) {
            return "";
        }
        return "?";
    }

    @Override
    public Long getRevision() {
        if (this.revision != null) {
            return this.revision;
        }
        SVNRevision.Number number = this.svnStatus.getRevision();
        return number != null ? Long.valueOf(number.getNumber()) : null;
    }

    public ISVNStatus getSVNStatus() {
        return this.svnStatus;
    }
}

