/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class SVNObjectHelper {
    public String propID;
    public String propName;
    public String parentID = null;
    public String fileName = null;
    public String className;

    public static SVNObjectHelper getSVNObjectHelperFor(Design design, String string) {
        if (string != null && string.length() > 0) {
            if (string.equalsIgnoreCase(design.getProcessModel().getObjectID())) {
                ProcessModel processModel = design.getProcessModel();
                SVNObjectHelper sVNObjectHelper = new SVNObjectHelper();
                sVNObjectHelper.propID = processModel.getObjectID();
                sVNObjectHelper.propName = processModel.getName();
                sVNObjectHelper.className = processModel.getClass().getName();
                sVNObjectHelper.parentID = null;
                sVNObjectHelper.fileName = processModel.getStorageName();
                return sVNObjectHelper;
            }
            DataFlowDesign dataFlowDesign = (DataFlowDesign)design.getProcessModel().getDataFlowDesigns().getById(string);
            if (dataFlowDesign != null) {
                SVNObjectHelper sVNObjectHelper = new SVNObjectHelper();
                sVNObjectHelper.propID = dataFlowDesign.getObjectID();
                sVNObjectHelper.propName = dataFlowDesign.getName();
                sVNObjectHelper.className = dataFlowDesign.getClass().getName();
                sVNObjectHelper.parentID = dataFlowDesign.getProcess() != null ? dataFlowDesign.getProcess().getObjectID() : design.getProcessModel().getObjectID();
                sVNObjectHelper.fileName = dataFlowDesign.getStorageName();
                return sVNObjectHelper;
            }
            DesignObject designObject = design.getDesignObject(string);
            if (designObject != null) {
                SVNObjectHelper sVNObjectHelper = new SVNObjectHelper();
                sVNObjectHelper.propID = designObject.getObjectID();
                sVNObjectHelper.propName = designObject.getName();
                sVNObjectHelper.className = designObject.getClass().getName();
                sVNObjectHelper.parentID = designObject.getDesignPartId();
                sVNObjectHelper.fileName = designObject.getSegmentedStorageName();
                return sVNObjectHelper;
            }
            return SVNClientHelper.svnOHMap.get(string);
        }
        return null;
    }
}

