/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.awt.Component;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangesTimerTask;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNCommandController;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateAllCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateWorkingCopyCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareCurrentCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareCurrentCommand;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatus;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatusCache;

public class SVNIncomingChangesChangeList
extends DataModelerChangeList {
    DataModelerChangesTimerTask timerTask;

    public SVNIncomingChangesChangeList() {
        super(Messages.getString("SVNIncomingChangesChangeList.IncomingChanges"));
        System.setProperty("ide.vcs.noapplications", "true");
        SVNRemoteStatusCache sVNRemoteStatusCache = new SVNRemoteStatusCache();
        this.setStatusCache((VCSStatusCache)sVNRemoteStatusCache);
    }

    @Override
    protected void addActions() {
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = null;
        IdeAction ideAction = SVNUpdateCommand.getAction();
        if (ideAction != null) {
            jMenuItem = menubar.createMenuItem((ToggleAction)ideAction);
            this.popupMenu.add(jMenuItem);
        }
        if ((ideAction = SVNUpdateAllCommand.getAction()) != null) {
            SVNCommandController.getInstance().register(ideAction, (Command)new SVNUpdateAllCommand());
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)ideAction));
        }
    }

    @Override
    protected IdeAction addCompareActions() {
        IdeAction ideAction;
        JMenu jMenu = null;
        IdeAction ideAction2 = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareCurrentCommand"));
        if (ideAction2 != null) {
            ideAction2.setCommand("oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareCurrentCommand");
            ideAction2.setName(Messages.getString("DataModelingAddin.CompareCurrent"));
            SVNCommandController.getInstance().register(ideAction2, (Command)new SVNCompareCurrentCommand());
            jMenu = this.createCompareWithMenu(this.popupMenu);
            jMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)ideAction2));
        }
        if ((ideAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareCurrentCommand"))) != null) {
            ideAction.setCommand("oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareCurrentCommand");
            ideAction.setName(Messages.getString("DataModelingAddin.TextCompareCurrent"));
            SVNCommandController.getInstance().register(ideAction, (Command)new SVNTextCompareCurrentCommand());
            if (jMenu == null) {
                jMenu = this.createCompareWithMenu(this.popupMenu);
            }
            jMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)ideAction));
        }
        return ideAction2;
    }

    protected TimerTask createStatusTask(VCSThreadPool vCSThreadPool) {
        this.timerTask = new DataModelerChangesTimerTask(this){

            @Override
            protected VCSClientHelper getVCSClientHelper() {
                return SVNClientHelper.getInstance();
            }

            @Override
            protected boolean checkRemoteStatus() {
                return true;
            }
        };
        return this.timerTask;
    }

    @Override
    public void clear() {
        if (this.timerTask != null) {
            this.timerTask.updateUI(null);
        }
    }

    @Override
    protected ChangeListStatus[] getChangeListStatuses() {
        return new ChangeListStatus[]{SVNRemoteStatus.TEXT_MODIFIED, SVNRemoteStatus.PROP_MODIFIED, SVNRemoteStatus.TEXT_PROP_MODIFIED, SVNRemoteStatus.ADDED, SVNRemoteStatus.DELETED};
    }

    @Override
    protected void addToolbarActions(ChangeListWindow changeListWindow, Toolbar toolbar) {
        IdeAction ideAction = SVNUpdateAllCommand.getAction();
        super.addToolbarActions(changeListWindow, toolbar);
        if (ideAction != null) {
            IdeAction ideAction2 = SVNUpdateWorkingCopyCommand.getAction();
            ActionMenuToolButton actionMenuToolButton = new ActionMenuToolButton((Action)ideAction2);
            actionMenuToolButton.setMenuActions(new Action[]{ideAction2, ideAction});
            toolbar.add((Component)actionMenuToolButton);
        }
    }
}

