/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VCSHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.jdeveloper.resource.VCSArb;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNHistoryWindow
extends VCSHistoryWindow<ISVNLogMessage> {
    protected static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();
    private static final Logger LOGGER = new Logger(SVNHistoryWindow.class);
    private static final String URL_ENCODING_CHARSET = "UTF-8";
    private static SVNHistoryWindow INSTANCE = new SVNHistoryWindow();
    private final LogMessagesComparator LOG_MESSAGES_COMPARATOR = new LogMessagesComparator();
    protected String repositoryUrl = "";
    protected String svnDesignPath = "";

    protected SVNHistoryWindow() {
    }

    public static SVNHistoryWindow getInstance() {
        return INSTANCE;
    }

    @Override
    public VCSClientHelper getVCSClientHelper() {
        return SVN_CLIENT_HELPER;
    }

    @Override
    protected void init(File[] fileArray, Design design) {
        super.init(fileArray, design);
        ISVNInfo iSVNInfo = SVN_CLIENT_HELPER.doInfo(fileArray[0]);
        this.repositoryUrl = iSVNInfo.getRepository().toString();
        this.svnDesignPath = this.resolveSvnDesignPath(iSVNInfo);
    }

    public boolean isSelectedWorkingCopyRevision() {
        StorableObjectStatus storableObjectStatus = this.getSelectedStorableObjectStatus();
        File file = storableObjectStatus.getFilePath();
        if (file.exists() && SVN_CLIENT_HELPER.isVersioned(file)) {
            long l = SVN_CLIENT_HELPER.doInfo(file).getRevision().getNumber();
            return storableObjectStatus.getRevision() == l;
        }
        return false;
    }

    public Icon getTabIcon() {
        return VCSArb.getIcon((int)232);
    }

    protected String resolveSvnDesignPath(ISVNInfo iSVNInfo) {
        try {
            String string = URLDecoder.decode(iSVNInfo.getUrlString(), URL_ENCODING_CHARSET).replace(iSVNInfo.getRepository().toString(), "");
            String string2 = iSVNInfo.getFile().getPath().replace(this.design.getDesignPath(), "").replace(File.separatorChar, '/');
            return string.replace(string2, "");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error(unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.repositoryUrl = null;
        this.svnDesignPath = null;
    }

    @Override
    protected InputStream getRevision(String string, Long l) {
        try {
            return SVN_CLIENT_HELPER.doGetRevision(new SVNUrl(string), l == null ? SVNRevision.HEAD : SVNRevision.getRevision((String)String.valueOf(l)));
        }
        catch (ParseException parseException) {
            LOGGER.warn(parseException);
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn(malformedURLException);
        }
        return null;
    }

    @Override
    protected InputStream getRevision(File file, Long l) {
        try {
            if (l == null) {
                return new FileInputStream(file);
            }
            return SVN_CLIENT_HELPER.doGetRevision(file, SVNRevision.getRevision((String)String.valueOf(l)));
        }
        catch (ParseException parseException) {
            LOGGER.warn(parseException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.warn(fileNotFoundException);
        }
        return null;
    }

    @Override
    protected List<ISVNLogMessage> getLogMessages(String string, Long l, Long l2, boolean bl, boolean bl2) {
        ArrayList<ISVNLogMessage> arrayList = new ArrayList<ISVNLogMessage>();
        List<ISVNLogMessage> list = null;
        try {
            list = SVN_CLIENT_HELPER.doGetLogMessages(new SVNUrl(string), l, l2, false, bl, 0);
            Collections.sort(list, new Comparator<ISVNLogMessage>(){

                @Override
                public int compare(ISVNLogMessage iSVNLogMessage, ISVNLogMessage iSVNLogMessage2) {
                    return SVNHistoryWindow.this.getRevision(iSVNLogMessage2).compareTo(SVNHistoryWindow.this.getRevision(iSVNLogMessage));
                }
            });
            if (bl2) {
                arrayList.add(new LocalVersion());
            }
            arrayList.addAll(list);
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.error(malformedURLException);
        }
        return arrayList;
    }

    @Override
    protected List<ISVNLogMessage> getLogMessages(File[] fileArray, Long l, Long l2, boolean bl, boolean bl2) {
        TreeSet<ISVNLogMessage> treeSet = new TreeSet<ISVNLogMessage>(this.LOG_MESSAGES_COMPARATOR);
        if (bl2) {
            treeSet.add(new LocalVersion());
        }
        for (File file : fileArray) {
            if (SVN_CLIENT_HELPER.getRevision(file) <= 0L) continue;
            treeSet.addAll(SVN_CLIENT_HELPER.doGetLogMessages(file, l, l2, false, bl, 0));
        }
        return new ArrayList<ISVNLogMessage>(treeSet);
    }

    @Override
    protected Long getRevision(ISVNLogMessage iSVNLogMessage) {
        SVNRevision.Number number = iSVNLogMessage.getRevision();
        return number == null ? null : Long.valueOf(number.getNumber());
    }

    @Override
    protected Date getDate(ISVNLogMessage iSVNLogMessage) {
        return iSVNLogMessage.getDate();
    }

    @Override
    protected String getAuthor(ISVNLogMessage iSVNLogMessage) {
        return iSVNLogMessage.getAuthor();
    }

    @Override
    protected String getComment(ISVNLogMessage iSVNLogMessage) {
        return iSVNLogMessage.getMessage();
    }

    @Override
    protected Map<ISVNLogMessage, List<StorableObjectStatus>> parseChangedObjects(List<ISVNLogMessage> list) {
        HashMap<ISVNLogMessage, List<StorableObjectStatus>> hashMap = new HashMap<ISVNLogMessage, List<StorableObjectStatus>>();
        for (ISVNLogMessage iSVNLogMessage : list) {
            ArrayList<StorableObjectStatus> arrayList = new ArrayList<StorableObjectStatus>();
            ISVNLogMessageChangePath[] iSVNLogMessageChangePathArray = iSVNLogMessage.getChangedPaths();
            if (iSVNLogMessageChangePathArray != null) {
                for (ISVNLogMessageChangePath iSVNLogMessageChangePath : iSVNLogMessageChangePathArray) {
                    StorableObjectStatus storableObjectStatus = this.parseChangedObject(iSVNLogMessageChangePath, iSVNLogMessage.getRevision().getNumber());
                    if (!StringUtilities.isNotEmpty(storableObjectStatus.getStorableObjectName())) continue;
                    arrayList.add(storableObjectStatus);
                }
                Collections.sort(arrayList, new Comparator<StorableObjectStatus>(){

                    @Override
                    public int compare(StorableObjectStatus storableObjectStatus, StorableObjectStatus storableObjectStatus2) {
                        boolean bl;
                        String string = storableObjectStatus.getFilePath().getPath();
                        String string2 = storableObjectStatus2.getFilePath().getPath();
                        String string3 = File.separator + "phys";
                        String string4 = string3 + File.separator;
                        boolean bl2 = string.contains(string4) || string.endsWith(string3);
                        boolean bl3 = bl = string2.contains(string4) || string2.endsWith(string3);
                        if (bl2 && !bl) {
                            return 1;
                        }
                        if (!bl2 && bl) {
                            return -1;
                        }
                        return string.compareTo(string2);
                    }
                });
            }
            hashMap.put(iSVNLogMessage, arrayList);
        }
        return hashMap;
    }

    protected StorableObjectStatus parseChangedObject(ISVNLogMessageChangePath iSVNLogMessageChangePath, Long l) {
        File file = this.resolveLocalFile(iSVNLogMessageChangePath);
        String string = iSVNLogMessageChangePath.getPath();
        SVNStorableObjectStatus sVNStorableObjectStatus = new SVNStorableObjectStatus(this.design, file, String.valueOf(iSVNLogMessageChangePath.getAction()), null, l);
        sVNStorableObjectStatus.setRepositoryUrl(this.repositoryUrl);
        sVNStorableObjectStatus.setPathUrl(string);
        sVNStorableObjectStatus.setCopyRevision(iSVNLogMessageChangePath.getCopySrcRevision() != null ? Long.valueOf(iSVNLogMessageChangePath.getCopySrcRevision().getNumber()) : null);
        sVNStorableObjectStatus.setCopyPath(iSVNLogMessageChangePath.getCopySrcPath());
        if (sVNStorableObjectStatus.isFile()) {
            if (!StringUtilities.isNotEmpty(sVNStorableObjectStatus.getStorableObjectName())) {
                String string2 = null;
                string2 = this.readPropertyName(file, sVNStorableObjectStatus, l);
                if (StringUtilities.isNotEmpty(string2)) {
                    sVNStorableObjectStatus.setStorableObjectName(string2);
                } else {
                    sVNStorableObjectStatus.setStorableObjectName(string);
                }
            }
        } else {
            sVNStorableObjectStatus.setStorableObjectName(string);
        }
        return sVNStorableObjectStatus;
    }

    protected File resolveLocalFile(ISVNLogMessageChangePath iSVNLogMessageChangePath) {
        String string = iSVNLogMessageChangePath.getPath().replace(this.svnDesignPath, "");
        return new File(this.design.getDesignPath() + string);
    }

    protected String readPropertyName(File file, SVNStorableObjectStatus sVNStorableObjectStatus, Long l) {
        return SVN_CLIENT_HELPER.doGetProperty(file, 5);
    }

    private class LogMessagesComparator
    implements Comparator<ISVNLogMessage> {
        private LogMessagesComparator() {
        }

        @Override
        public int compare(ISVNLogMessage iSVNLogMessage, ISVNLogMessage iSVNLogMessage2) {
            if (iSVNLogMessage instanceof LocalVersion) {
                return -1;
            }
            if (iSVNLogMessage2 instanceof LocalVersion) {
                return 1;
            }
            return SVNHistoryWindow.this.getRevision(iSVNLogMessage2).compareTo(SVNHistoryWindow.this.getRevision(iSVNLogMessage));
        }
    }

    private static class LocalVersion
    implements ISVNLogMessage {
        private LocalVersion() {
        }

        public SVNRevision.Number getRevision() {
            return null;
        }

        public String getAuthor() {
            return null;
        }

        public long getTimeMicros() {
            return 0L;
        }

        public long getTimeMillis() {
            return 0L;
        }

        public Date getDate() {
            return null;
        }

        public String getMessage() {
            return null;
        }

        public ISVNLogMessageChangePath[] getChangedPaths() {
            return null;
        }

        public long getNumberOfChildren() {
            return 0L;
        }

        public ISVNLogMessage[] getChildMessages() {
            return null;
        }

        public void addChild(ISVNLogMessage iSVNLogMessage) {
        }

        public boolean hasChildren() {
            return false;
        }
    }
}

