/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DeletedFile;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.RevisionRange;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.model.Displayable;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdeveloper.vcs.vop.DisplayableCellRenderer;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationPanel;
import oracle.jdevimpl.vcs.svn.SVNExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.ui.SVNVersionOperationPanel;
import oracle.jdevimpl.vcs.svn.util.CheckboxProperty;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNInfoUnversioned;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNClientHelper
extends VCSClientHelper<ISVNLogMessage, org.tigris.subversion.svnclientadapter.SVNRevision, ISVNStatus, SVNUrl, ISVNInfo, SVNDiffSummary, ISVNProperty> {
    public static final Map<String, SVNObjectHelper> svnOHMap = new HashMap<String, SVNObjectHelper>();
    private static final Logger LOGGER = new Logger(SVNClientHelper.class);
    private static final PathComparator PATH_COMPARATOR = new PathComparator();
    protected static final SVNClientHelper instance = new SVNClientHelper();
    protected ISVNClientAdapter client;
    protected SVNExceptionHandler svnExceptionHandler;
    protected SVNOperationLogger svnOperationLogger;
    protected Map<SVNUrl, String> svnPropertiesCache;
    private SVNMergedObjectsEventHandler mergedObjectsEventHandler = new SVNMergedObjectsEventHandler(this);
    private Design currentDesign;

    private SVNClientHelper() {
        this.svnExceptionHandler = new SVNExceptionHandler();
        this.svnOperationLogger = SVNOperationLogger.getInstance();
        this.svnPropertiesCache = new HashMap<SVNUrl, String>();
        try {
            this.client = SVNUtil.getIDEClientAdapter();
        }
        catch (SVNClientException sVNClientException) {
            this.logException((Exception)((Object)sVNClientException));
        }
    }

    public static SVNClientHelper getInstance() {
        return instance;
    }

    @Override
    public boolean isVersioned(File file) {
        if (file == null) {
            return false;
        }
        try {
            return !(this.client.getInfoFromWorkingCopy(file) instanceof SVNInfoUnversioned);
        }
        catch (SVNClientException sVNClientException) {
            return false;
        }
    }

    @Override
    public boolean exists(String string) {
        try {
            SVNUrl sVNUrl = new SVNUrl(string);
            this.beginOperation(sVNUrl, null, "exists");
            return !(this.client.getInfo(sVNUrl) instanceof SVNInfoUnversioned);
        }
        catch (SVNClientException sVNClientException) {
            return false;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    @Override
    public long getRevision(File file) {
        try {
            SVNRevision.Number number = this.client.getInfoFromWorkingCopy(file).getRevision();
            if (number != null) {
                return number.getNumber();
            }
            return -1L;
        }
        catch (SVNClientException sVNClientException) {
            return 0L;
        }
    }

    @Override
    public long getLastChangedRevision(File file) {
        try {
            SVNRevision.Number number = this.client.getInfoFromWorkingCopy(file).getLastChangedRevision();
            return number == null ? 0L : number.getNumber();
        }
        catch (SVNClientException sVNClientException) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLastMergedRevision(File file, Long l, String string) {
        try {
            this.beginOperation(null, file, "getLastMergedRevision");
            ISVNMergeInfo iSVNMergeInfo = this.client.getMergeInfo(file, l == null ? org.tigris.subversion.svnclientadapter.SVNRevision.HEAD : org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)l.toString()));
            if (iSVNMergeInfo != null) {
                String[] stringArray;
                for (String string2 : stringArray = iSVNMergeInfo.getPaths()) {
                    if (!string2.equals(string)) continue;
                    org.tigris.subversion.svnclientadapter.SVNRevisionRange[] sVNRevisionRangeArray = iSVNMergeInfo.getRevisions(string);
                    if (sVNRevisionRangeArray != null && sVNRevisionRangeArray.length > 0) {
                        Long l2 = Long.valueOf(sVNRevisionRangeArray[0].getToRevision().toString());
                        return l2;
                    }
                    Long l3 = null;
                    return l3;
                }
            }
        }
        catch (SVNClientException sVNClientException) {
            this.logException("getLastMergedRevision", (Exception)((Object)sVNClientException));
        }
        catch (ParseException parseException) {
            this.logException("getLastMergedRevision", parseException);
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    @Override
    public ISVNInfo doInfo(File file) {
        try {
            return this.client.getInfoFromWorkingCopy(file);
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doInfo", (Exception)((Object)sVNClientException));
            return null;
        }
    }

    @Override
    protected void doAdd(File file, boolean bl) {
        try {
            if (file.isDirectory()) {
                this.client.addDirectory(file, bl);
            } else {
                this.client.addFile(file);
            }
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doAdd", (Exception)((Object)sVNClientException));
        }
    }

    @Override
    public void doRemove(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            this.doRemoveLocalFilesFirst(fileArray[i]);
        }
        try {
            this.client.remove(fileArray, true);
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doRemove", (Exception)((Object)sVNClientException));
        }
    }

    @Override
    public boolean isDeleted(File file) {
        List<ISVNStatus> list = this.doStatus(file, false);
        return !list.isEmpty() && list.get(0).getTextStatus() == SVNStatusKind.DELETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ISVNStatus> doStatus(File file, boolean bl) {
        block5: {
            if (!this.isVersioned(file)) break block5;
            try {
                this.beginOperation(null, file, "doStatus");
                List<ISVNStatus> list = Arrays.asList(this.client.getStatus(file, true, false, bl));
                this.endOperation();
                return list;
            }
            catch (Throwable throwable) {
                try {
                    this.endOperation();
                    throw throwable;
                }
                catch (SVNClientException sVNClientException) {
                    this.logException("doStatus", (Exception)((Object)sVNClientException));
                }
            }
        }
        return new ArrayList<ISVNStatus>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNStatus getSingleStatus(File file) {
        block5: {
            if (!this.isVersioned(file)) break block5;
            try {
                this.beginOperation(null, file, "doStatus");
                ISVNStatus iSVNStatus = this.client.getSingleStatus(file);
                this.endOperation();
                return iSVNStatus;
            }
            catch (Throwable throwable) {
                try {
                    this.endOperation();
                    throw throwable;
                }
                catch (SVNClientException sVNClientException) {
                    this.logException("doStatus", (Exception)((Object)sVNClientException));
                }
            }
        }
        return null;
    }

    public boolean isLockedInWC(File file) {
        ISVNStatus iSVNStatus = this.getSingleStatus(file);
        return iSVNStatus.getLockOwner() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdate(File[] fileArray, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            if (!this.isVersioned(file)) continue;
            arrayList.add(file);
        }
        if (arrayList.size() > 0) {
            try {
                this.beginOperation(null, fileArray[0], "doUpdate");
                this.client.update(arrayList.toArray(new File[0]), org.tigris.subversion.svnclientadapter.SVNRevision.HEAD, bl, true);
            }
            catch (SVNClientException sVNClientException) {
                this.logException("doUpdate", (Exception)((Object)sVNClientException));
            }
            finally {
                this.endOperation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCommit(File[] fileArray, String string, boolean bl, boolean bl2) {
        String string2 = SVNClientHelper.commonPath(fileArray);
        if (!this.isVersioned(new File(string2))) {
            for (File file : fileArray) {
                this.doCommit(new File[]{file}, string, bl, bl2);
            }
        } else {
            try {
                this.beginOperation(null, fileArray[0], "doCommit");
                this.client.commit(fileArray, string, bl, bl2);
            }
            catch (SVNClientException sVNClientException) {
                this.logException("doCommit", (Exception)((Object)sVNClientException));
            }
            finally {
                this.endOperation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRevert(File[] fileArray, boolean bl) {
        try {
            this.beginOperation(null, fileArray[0], "doRevert");
            for (File file : fileArray) {
                this.client.revert(file, bl);
            }
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doRevert", (Exception)((Object)sVNClientException));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCleanup(File file) {
        try {
            this.beginOperation(null, file, "doCleanup");
            this.client.cleanup(file);
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doCleanup", (Exception)((Object)sVNClientException));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream doGetRevision(SVNUrl sVNUrl, org.tigris.subversion.svnclientadapter.SVNRevision sVNRevision) {
        try {
            this.beginOperation(sVNUrl, null, "doGetRevision");
            InputStream inputStream = this.client.getContent(sVNUrl, sVNRevision);
            return inputStream;
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doGetRevision", (Exception)((Object)sVNClientException));
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream doGetRevision(File file, org.tigris.subversion.svnclientadapter.SVNRevision sVNRevision) {
        try {
            this.beginOperation(null, file, "doGetRevision");
            InputStream inputStream = this.client.getContent(file, sVNRevision);
            return inputStream;
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doGetRevision", (Exception)((Object)sVNClientException));
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ISVNLogMessage> doGetLogMessages(SVNUrl sVNUrl, Long l, Long l2, boolean bl, boolean bl2, int n) {
        try {
            this.beginOperation(sVNUrl, null, "doGetLogMessages");
            List<ISVNLogMessage> list = Arrays.asList(this.client.getLogMessages(sVNUrl, org.tigris.subversion.svnclientadapter.SVNRevision.HEAD, l == null ? org.tigris.subversion.svnclientadapter.SVNRevision.START : org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)l.toString()), l2 == null ? org.tigris.subversion.svnclientadapter.SVNRevision.HEAD : org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)l2.toString()), bl, bl2, (long)n));
            return list;
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doGetLogMessages", (Exception)((Object)sVNClientException));
        }
        catch (ParseException parseException) {
            this.logException("doGetLogMessages", parseException);
        }
        finally {
            this.endOperation();
        }
        return new ArrayList<ISVNLogMessage>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ISVNLogMessage> doGetLogMessages(File file, Long l, Long l2, boolean bl, boolean bl2, int n) {
        try {
            this.beginOperation(null, file, "doGetLogMessages");
            List<ISVNLogMessage> list = Arrays.asList(this.client.getLogMessages(file, l == null ? org.tigris.subversion.svnclientadapter.SVNRevision.START : org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)l.toString()), l2 == null ? org.tigris.subversion.svnclientadapter.SVNRevision.HEAD : org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)l2.toString()), bl, bl2, (long)n));
            return list;
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doGetLogMessages", (Exception)((Object)sVNClientException));
        }
        catch (ParseException parseException) {
            this.logException("doGetLogMessages", parseException);
        }
        finally {
            this.endOperation();
        }
        return new ArrayList<ISVNLogMessage>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doResolved(File file) {
        try {
            this.beginOperation(null, file, "doResolved");
            this.client.resolved(file);
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doMarkAsMerged", (Exception)((Object)sVNClientException));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doIgnore(File file, String string) {
        try {
            this.beginOperation(null, file, "doIgnore");
            this.client.addToIgnoredPatterns(file, string);
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doIgnore", (Exception)((Object)sVNClientException));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLock(File[] fileArray, boolean bl, String string) {
        try {
            this.beginOperation(null, fileArray[0], "doLock");
            this.client.lock(fileArray, string, bl);
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doLock", (Exception)((Object)sVNClientException));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUnlock(File[] fileArray, boolean bl) {
        try {
            this.beginOperation(null, fileArray[0], "doUnlock");
            this.client.unlock(fileArray, bl);
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doUnlock", (Exception)((Object)sVNClientException));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doGetProperty(SVNUrl sVNUrl, String string, Long l) {
        try {
            org.tigris.subversion.svnclientadapter.SVNRevision sVNRevision = l == null ? org.tigris.subversion.svnclientadapter.SVNRevision.HEAD : new SVNRevision.Number(l.longValue());
            this.beginOperation(sVNUrl, null, "doGetProperty");
            ISVNProperty iSVNProperty = this.client.propertyGet(sVNUrl, sVNRevision, sVNRevision, string);
            String string2 = iSVNProperty != null ? iSVNProperty.getValue() : null;
            return string2;
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doGetProperty " + sVNUrl, (Exception)((Object)sVNClientException));
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    @Override
    public String doGetProperty(File file, String string) {
        try {
            if (file.exists()) {
                ISVNProperty iSVNProperty = this.client.propertyGet(file, string);
                return iSVNProperty != null ? iSVNProperty.getValue() : null;
            }
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doGetProperty " + file.getName(), (Exception)((Object)sVNClientException));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNProperty[] doGetProperties(String string, Long l) {
        try {
            org.tigris.subversion.svnclientadapter.SVNRevision sVNRevision = l == null ? org.tigris.subversion.svnclientadapter.SVNRevision.HEAD : new SVNRevision.Number(l.longValue());
            SVNUrl sVNUrl = new SVNUrl(string);
            this.beginOperation(sVNUrl, null, "doGetProperties");
            ISVNProperty[] iSVNPropertyArray = this.client.getProperties(sVNUrl, sVNRevision);
            return iSVNPropertyArray;
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doGetProperties " + string, (Exception)((Object)sVNClientException));
        }
        catch (MalformedURLException malformedURLException) {
            this.logException("doGetProperties " + string, malformedURLException);
        }
        finally {
            this.endOperation();
        }
        return null;
    }

    @Override
    public void doSetProperty(File file, String string, String string2) {
        try {
            this.client.propertySet(file, string, string2, false);
        }
        catch (SVNClientException sVNClientException) {
            this.logException("saveProperties " + file.getName(), (Exception)((Object)sVNClientException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SVNDiffSummary> doDiffSummarize(SVNUrl sVNUrl, SVNUrl sVNUrl2) {
        try {
            this.beginOperation(sVNUrl, null, "doDiffSummarize");
            List<SVNDiffSummary> list = Arrays.asList(this.client.diffSummarize(sVNUrl, null, sVNUrl2, null, 3, false));
            return list;
        }
        catch (SVNClientException sVNClientException) {
            this.logException("doDiffSummarize", (Exception)((Object)sVNClientException));
        }
        finally {
            this.endOperation();
        }
        return new ArrayList<SVNDiffSummary>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MergeConflict> doMerge(SVNUrl sVNUrl, File file, List<RevisionRange> list, boolean bl, boolean bl2) {
        File[] fileArray;
        ArrayList<MergeConflict> arrayList = new ArrayList<MergeConflict>();
        try {
            fileArray = this.beginOperation(sVNUrl, null, "doMerge");
            this.doLowLevelMerge(sVNUrl, file, list, (SVNRepositoryInfo)fileArray, arrayList, bl, bl2);
        }
        catch (Exception exception) {
            this.logException("doMerge", exception);
        }
        finally {
            this.endOperation();
        }
        fileArray = new File[]{file};
        this.doUpdate(fileArray, false);
        return arrayList;
    }

    private void doLowLevelMerge(SVNUrl sVNUrl, File file, List<RevisionRange> list, SVNRepositoryInfo sVNRepositoryInfo, final List<MergeConflict> list2, boolean bl, boolean bl2) throws SVNException {
        SVNClientManager sVNClientManager = SVNClientManager.newInstance();
        SVNDiffClient sVNDiffClient = sVNClientManager.getDiffClient();
        SVNAuthInfo sVNAuthInfo = sVNRepositoryInfo.getAuthInfo();
        DefaultSVNOptions defaultSVNOptions = (DefaultSVNOptions)sVNDiffClient.getOptions();
        SVNDiffOptions sVNDiffOptions = sVNDiffClient.getMergeOptions();
        final StringBuilder stringBuilder = new StringBuilder();
        sVNDiffOptions.setIgnoreEOLStyle(true);
        if (bl2) {
            sVNDiffClient.setEventHandler(new ISVNEventHandler(){

                public void handleEvent(SVNEvent sVNEvent, double d) throws SVNException {
                    if (sVNEvent.getContentsStatus() == SVNStatusType.CONFLICTED || sVNEvent.getContentsStatus() == SVNStatusType.CONFLICTED_UNRESOLVED) {
                        stringBuilder.append("Conflict ").append(sVNEvent.getFile().getPath()).append('\n');
                    } else if (sVNEvent.getAction() == SVNEventAction.TREE_CONFLICT) {
                        stringBuilder.append("Tree Conflict ").append(sVNEvent.getFile().getPath()).append('\n');
                    } else if (sVNEvent.getAction() == SVNEventAction.UPDATE_ADD) {
                        stringBuilder.append("Add ").append(sVNEvent.getFile().getPath()).append('\n');
                    } else if (sVNEvent.getAction() == SVNEventAction.UPDATE_DELETE) {
                        stringBuilder.append("Delete ").append(sVNEvent.getFile().getPath()).append('\n');
                    } else if (sVNEvent.getAction() == SVNEventAction.UPDATE_UPDATE) {
                        stringBuilder.append("Update ").append(sVNEvent.getFile().getPath()).append('\n');
                    } else if (sVNEvent.getAction() == SVNEventAction.MERGE_COMPLETE) {
                        stringBuilder.append("Merge finished").append('\n');
                    }
                }

                public void checkCancelled() throws SVNCancelException {
                }
            });
            defaultSVNOptions.setConflictHandler(new ISVNConflictHandler(){

                public SVNConflictResult handleConflict(SVNConflictDescription sVNConflictDescription) throws SVNException {
                    SVNMergeFileSet sVNMergeFileSet = sVNConflictDescription.getMergeFiles();
                    File file = sVNConflictDescription.getPath();
                    MergeConflict mergeConflict = new MergeConflict(file, sVNMergeFileSet.getBaseLabel(), sVNMergeFileSet.getLocalLabel(), sVNMergeFileSet.getRepositoryLabel(), null, null);
                    list2.add(mergeConflict);
                    return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
                }
            });
            sVNDiffClient.setOptions((ISVNOptions)defaultSVNOptions);
        } else {
            defaultSVNOptions.setConflictHandler(new ISVNConflictHandler(){

                public SVNConflictResult handleConflict(SVNConflictDescription sVNConflictDescription) throws SVNException {
                    SVNMergeFileSet sVNMergeFileSet = sVNConflictDescription.getMergeFiles();
                    File file = sVNConflictDescription.getPath();
                    MergeConflict mergeConflict = new MergeConflict(file, sVNMergeFileSet.getBaseLabel(), sVNMergeFileSet.getLocalLabel(), sVNMergeFileSet.getRepositoryLabel(), null, null);
                    list2.add(mergeConflict);
                    return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
                }
            });
            sVNDiffClient.setOptions((ISVNOptions)defaultSVNOptions);
            this.mergedObjectsEventHandler.clearSVNStatuses();
            sVNDiffClient.setEventHandler((ISVNEventHandler)this.mergedObjectsEventHandler);
        }
        sVNClientManager.setAuthenticationManager((ISVNAuthenticationManager)new BasicAuthenticationManager(sVNAuthInfo.getUserName(), sVNAuthInfo.getPassword()));
        sVNDiffClient.doMerge(SVNURL.parseURIEncoded((String)sVNUrl.toString()), SVNRevision.HEAD, this.convertRevisionRanges(list), file, SVNDepth.INFINITY, true, false, bl2, bl);
        if (bl2) {
            LogReport logReport = new LogReport(ApplicationView.getInstance());
            logReport.setName("");
            logReport.setLog(stringBuilder.toString());
            logReport.showDialog(new Dimension(750, 550));
        } else {
            for (MergeConflict mergeConflict : list2) {
                SVNClientHelper.replace(mergeConflict.getLocalFile(), mergeConflict.getLocalLabel());
            }
        }
    }

    private List<SVNRevisionRange> convertRevisionRanges(List<RevisionRange> list) {
        ArrayList<SVNRevisionRange> arrayList = new ArrayList<SVNRevisionRange>(list.size());
        for (RevisionRange revisionRange : list) {
            Long l = revisionRange.getStartRevision() - 1L;
            Long l2 = revisionRange.getEndRevision();
            SVNRevision sVNRevision = SVNRevision.create((long)l);
            SVNRevision sVNRevision2 = SVNRevision.create((long)l2);
            arrayList.add(new SVNRevisionRange(sVNRevision, sVNRevision2));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doMergeReintegrate(SVNUrl sVNUrl, File file, final List<MergeConflict> list) {
        SVNClientManager sVNClientManager = SVNClientManager.newInstance();
        SVNDiffClient sVNDiffClient = sVNClientManager.getDiffClient();
        DefaultSVNOptions defaultSVNOptions = (DefaultSVNOptions)sVNDiffClient.getOptions();
        boolean bl = true;
        try {
            SVNRepositoryInfo sVNRepositoryInfo = this.beginOperation(sVNUrl, null, "doMergeReintegrate");
            SVNAuthInfo sVNAuthInfo = sVNRepositoryInfo.getAuthInfo();
            sVNClientManager.setAuthenticationManager((ISVNAuthenticationManager)new BasicAuthenticationManager(sVNAuthInfo.getUserName(), sVNAuthInfo.getPassword()));
            SVNURL sVNURL = SVNURL.parseURIDecoded((String)sVNUrl.toString());
            this.mergedObjectsEventHandler.clearSVNStatuses();
            sVNDiffClient.setEventHandler((ISVNEventHandler)this.mergedObjectsEventHandler);
            SVNDiffOptions sVNDiffOptions = sVNDiffClient.getMergeOptions();
            sVNDiffOptions.setIgnoreEOLStyle(true);
            defaultSVNOptions.setConflictHandler(new ISVNConflictHandler(){

                public SVNConflictResult handleConflict(SVNConflictDescription sVNConflictDescription) throws SVNException {
                    SVNMergeFileSet sVNMergeFileSet = sVNConflictDescription.getMergeFiles();
                    File file = sVNConflictDescription.getPath();
                    MergeConflict mergeConflict = new MergeConflict(file, sVNMergeFileSet.getBaseLabel(), sVNMergeFileSet.getLocalLabel(), sVNMergeFileSet.getRepositoryLabel(), null, null);
                    list.add(mergeConflict);
                    return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
                }
            });
            sVNDiffClient.doMergeReIntegrate(sVNURL, null, file, false);
        }
        catch (Exception exception) {
            bl = false;
            this.logException("doMergeReintegrate", exception);
        }
        finally {
            this.endOperation();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCopy(String string, File file, Long l) {
        try {
            SVNRepositoryInfo sVNRepositoryInfo = this.beginOperation(new SVNUrl(string), null, "doCopy");
            SVNAuthInfo sVNAuthInfo = sVNRepositoryInfo.getAuthInfo();
            SVNClientManager sVNClientManager = SVNClientManager.newInstance();
            SVNCopyClient sVNCopyClient = sVNClientManager.getCopyClient();
            SVNRevision sVNRevision = SVNRevision.create((long)l);
            sVNClientManager.setAuthenticationManager((ISVNAuthenticationManager)new BasicAuthenticationManager(sVNAuthInfo.getUserName(), sVNAuthInfo.getPassword()));
            SVNCopySource sVNCopySource = new SVNCopySource(sVNRevision, sVNRevision, SVNURL.parseURIDecoded((String)string));
            sVNCopyClient.doCopy(new SVNCopySource[]{sVNCopySource}, file, false, false, true);
        }
        catch (Exception exception) {
            this.logException("doCopy", exception);
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public List<StorableObjectStatus> getStatuses(Design design, boolean bl, boolean bl2, boolean bl3) {
        HashSet<ISVNStatus> hashSet = new HashSet<ISVNStatus>();
        String string = XMLTransformationManager.getDefaultSystemTypesPath();
        String string2 = design.getDesignPath();
        List<ISVNStatus> list = this.doStatus(new File(string2), bl);
        this.filterStatuses(hashSet, list, bl, bl3);
        if (!this.isSubfolder(new File(string), new File(string2))) {
            list = this.doStatus(new File(string), bl);
            this.filterStatuses(hashSet, list, bl, bl3);
        }
        return this.convertToStorableObjectStatuses(design, hashSet, bl, bl2);
    }

    private void filterStatuses(Set<ISVNStatus> set, List<ISVNStatus> list, boolean bl, boolean bl2) {
        if (bl) {
            for (ISVNStatus iSVNStatus : list) {
                SVNRevision.Number number = iSVNStatus.getLastChangedRevision();
                if (number == null || number.getNumber() <= 0L || iSVNStatus.getRepositoryPropStatus() == SVNStatusKind.NONE && iSVNStatus.getRepositoryTextStatus() == SVNStatusKind.NONE) continue;
                set.add(iSVNStatus);
            }
        } else {
            for (ISVNStatus iSVNStatus : list) {
                if (bl2 && iSVNStatus.getPropStatus() == SVNStatusKind.NONE && (iSVNStatus.getTextStatus() == SVNStatusKind.UNVERSIONED || iSVNStatus.getTextStatus() == SVNStatusKind.NONE) || (iSVNStatus.getPropStatus() == SVNStatusKind.NONE || iSVNStatus.getPropStatus() == SVNStatusKind.NORMAL) && (iSVNStatus.getTextStatus() == SVNStatusKind.NONE || iSVNStatus.getTextStatus() == SVNStatusKind.NORMAL)) continue;
                set.add(iSVNStatus);
            }
        }
    }

    private boolean isSubfolder(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        if (file.equals(file2)) {
            return true;
        }
        return this.isSubfolder(file.getParentFile(), file2);
    }

    @Override
    public VersionOperationPanel createVersionOperationTablePanel(List<DisplayableLocatableNode> list) {
        DisplayProperty[] displayPropertyArray = new DisplayProperty[]{new ClientDisplayProperty(Messages.getString("SVNClientHelper.Status"), null, 2, (Object)"M", null, String.class, 50), new CheckboxProperty()};
        MutableVersionOperationModel mutableVersionOperationModel = VCSComponents.createFileListerModel(list, (DisplayProperty[])displayPropertyArray);
        for (int i = 0; i < mutableVersionOperationModel.getCount(); ++i) {
            DisplayableLocatableNode displayableLocatableNode = (DisplayableLocatableNode)mutableVersionOperationModel.getItem(i);
            if (displayableLocatableNode instanceof VersioningTreeNode) {
                VersioningTreeNode versioningTreeNode = (VersioningTreeNode)displayableLocatableNode;
                TreeNode treeNode = versioningTreeNode.getParent();
                if (treeNode != null) {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = treeNode.toString();
                    TreeNode treeNode2 = treeNode.getParent();
                    if (treeNode2 != null && StringUtilities.isNotEmpty(string = treeNode2.toString())) {
                        stringBuilder.append(string);
                        stringBuilder.append(" \\ ");
                    }
                    if (StringUtilities.isNotEmpty(string2)) {
                        stringBuilder.append(string2);
                    }
                    mutableVersionOperationModel.setProperty(i, mutableVersionOperationModel.getProperties()[0], (Object)stringBuilder.toString());
                }
                mutableVersionOperationModel.setProperty(i, displayPropertyArray[0], (Object)versioningTreeNode.getStorableObjectStatus().getTextStatus());
            }
            mutableVersionOperationModel.setProperty(i, displayPropertyArray[1], displayPropertyArray[1].getPrototypeValue());
        }
        SVNVersionOperationPanel sVNVersionOperationPanel = new SVNVersionOperationPanel();
        sVNVersionOperationPanel.installModel((VersionOperationModel)mutableVersionOperationModel);
        sVNVersionOperationPanel.setDefaultRenderer(Displayable.class, (TableCellRenderer)new DisplayableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.setText(((Displayable)object).getLongLabel());
                return this;
            }
        });
        return sVNVersionOperationPanel;
    }

    public SVNObjectHelper createSVNObjectHelper(File file, SVNUrl sVNUrl, boolean bl, String string) {
        String string2;
        if (bl) {
            string2 = this.doGetProperty(sVNUrl, "dm:properties", (Long)null);
        } else {
            string2 = this.doGetProperty(file, "dm:properties");
            if (string2 == null && sVNUrl != null) {
                string2 = this.doGetProperty(sVNUrl, "dm:properties", (Long)null);
            }
        }
        SVNObjectHelper sVNObjectHelper = this.createSVNObjectHelper(file, string2);
        if (sVNObjectHelper == null) {
            return this.createBackupSVNObjectHelper(file, string);
        }
        return sVNObjectHelper;
    }

    protected SVNObjectHelper createSVNObjectHelper(File file, String string) {
        SVNObjectHelper sVNObjectHelper = null;
        String string2 = this.getProperty(string, 0);
        if (string2 != null) {
            sVNObjectHelper = new SVNObjectHelper();
            sVNObjectHelper.propID = string2;
            sVNObjectHelper.propName = this.getProperty(string, 5);
            sVNObjectHelper.className = this.getProperty(string, 1);
            sVNObjectHelper.parentID = this.getProperty(string, 2);
            sVNObjectHelper.fileName = file.getPath();
        }
        return sVNObjectHelper;
    }

    protected SVNObjectHelper createBackupSVNObjectHelper(File file, String string) {
        SVNObjectHelper sVNObjectHelper = new SVNObjectHelper();
        sVNObjectHelper.propName = sVNObjectHelper.propID = file.getName().substring(0, file.getName().indexOf(46));
        sVNObjectHelper.className = ModelIDObject.class.getName();
        sVNObjectHelper.parentID = string;
        sVNObjectHelper.fileName = file.getPath();
        return sVNObjectHelper;
    }

    public List<StorableObjectStatus> convertToStorableObjectStatuses(Design design, Collection<ISVNStatus> collection, boolean bl, boolean bl2) {
        String string;
        Object object;
        Object object2;
        File file;
        ArrayList<StorableObjectStatus> arrayList = new ArrayList<StorableObjectStatus>();
        for (ISVNStatus iSVNStatus : collection) {
            file = iSVNStatus.getFile();
            if (!SVNClientHelper.accept(file) || this.isSystemFile(file) || (object2 = this.createSVNObjectHelper(iSVNStatus.getFile(), this.readProperties(iSVNStatus, bl))) == null) continue;
            try {
                object = Class.forName(((SVNObjectHelper)object2).className);
                if (object == null) continue;
                if (RelationalObjectProxy.class.isAssignableFrom((Class<?>)object)) {
                    string = ((SVNObjectHelper)object2).parentID;
                    if (string != null && string.length() > 0) {
                        svnOHMap.put(string + "_" + ((SVNObjectHelper)object2).propID, (SVNObjectHelper)object2);
                        continue;
                    }
                    svnOHMap.put(((SVNObjectHelper)object2).propID, (SVNObjectHelper)object2);
                    continue;
                }
                svnOHMap.put(((SVNObjectHelper)object2).propID, (SVNObjectHelper)object2);
            }
            catch (Exception exception) {
                LOGGER.error(exception);
            }
        }
        for (ISVNStatus iSVNStatus : collection) {
            file = iSVNStatus.getFile();
            if (SVNClientHelper.accept(file)) {
                Object object3 = object2 = this.isSystemFile(file) ? null : this.readProperties(iSVNStatus, bl);
                object = new SVNStorableObjectStatus(design, iSVNStatus, bl);
                if (object == null) continue;
                string = this.getProperty((String)object2, 0);
                String string2 = this.getProperty((String)object2, 5);
                String string3 = this.getProperty((String)object2, 2);
                if (bl && iSVNStatus.getRepositoryTextStatus() == SVNStatusKind.ADDED || bl || iSVNStatus.getTextStatus() == SVNStatusKind.DELETED || iSVNStatus.getTextStatus() == SVNStatusKind.MISSING) {
                    // empty if block
                }
                if (string != null) {
                    ((StorableObjectStatus)object).setStorableObjectID(string);
                }
                if (string2 != null) {
                    ((StorableObjectStatus)object).setStorableObjectName(string2);
                } else if (((StorableObjectStatus)object).getStorableObjectName() == null) {
                    ((StorableObjectStatus)object).setStorableObjectName(((StorableObjectStatus)object).getStorableObjectID());
                }
                ((StorableObjectStatus)object).setStorableObjectParentID(string3);
                arrayList.add((StorableObjectStatus)object);
                continue;
            }
            if (!design.getDesignPath().equals(file.getPath()) && !bl2 || (object2 = new SVNStorableObjectStatus(design, iSVNStatus, bl)) == null) continue;
            arrayList.add((StorableObjectStatus)object2);
        }
        Collections.sort(arrayList, PATH_COMPARATOR);
        return arrayList;
    }

    protected String readProperties(ISVNStatus iSVNStatus, boolean bl) {
        SVNUrl sVNUrl = iSVNStatus.getUrl();
        String string = this.svnPropertiesCache.get(sVNUrl);
        if (StringUtilities.isEmpty(string)) {
            File file = iSVNStatus.getFile();
            if (file != null && iSVNStatus.getRevision() != null) {
                string = this.doGetProperty(file, "dm:properties");
            }
            if (StringUtilities.isEmpty(string)) {
                SVNStatusKind sVNStatusKind = iSVNStatus.getTextStatus();
                if (bl && sVNStatusKind == SVNStatusKind.DELETED || !bl && (sVNStatusKind == SVNStatusKind.ADDED || sVNStatusKind == SVNStatusKind.UNVERSIONED || sVNStatusKind == SVNStatusKind.MISSING)) {
                    return string;
                }
                if (iSVNStatus.getUrl() != null) {
                    string = this.doGetProperty(iSVNStatus.getUrl(), "dm:properties", (Long)null);
                }
            }
            this.svnPropertiesCache.put(sVNUrl, string);
        }
        return string;
    }

    private boolean isSystemFile(File file) {
        String string = file.getName();
        String string2 = FileUtils.removeExt(string);
        return "dl_settings.xml".equalsIgnoreCase(string) || "ExtendedMap".equalsIgnoreCase(string2) || "defaultRDBMSSites.xml".equalsIgnoreCase(string) || "defaultdomains.xml".equalsIgnoreCase(string) || "types.xml".equalsIgnoreCase(string) || string.endsWith("_RDBMSSites.xml") || "domains".equals(file.getParentFile().getName()) || string.startsWith("ExtendedMap_RM");
    }

    protected SVNRepositoryInfo beginOperation(SVNUrl sVNUrl, File file, String string) {
        SVNRepositoryInfo sVNRepositoryInfo = null;
        try {
            if (sVNUrl == null && file != null) {
                sVNUrl = this.findSVNUrl(file);
            }
            sVNRepositoryInfo = SVNUtil.resolveRepository((SVNUrl)sVNUrl);
            this.svnOperationLogger.beginOperation(this.client, sVNRepositoryInfo);
        }
        catch (MalformedURLException malformedURLException) {
            this.logException("SVNClientHelper.beginOperation", malformedURLException);
        }
        catch (SVNClientException sVNClientException) {
            this.logException("SVNClientHelper.beginOperation", (Exception)((Object)sVNClientException));
        }
        return sVNRepositoryInfo;
    }

    private SVNUrl findSVNUrl(File file) throws MalformedURLException, SVNClientException {
        if (file != null) {
            SVNUrl sVNUrl = SVNURLInfoCache.getInstance().getURL(file.toURI().toURL());
            if (sVNUrl == null) {
                return this.findSVNUrl(file.getParentFile());
            }
            return sVNUrl;
        }
        return null;
    }

    protected void endOperation() {
        try {
            this.svnOperationLogger.endOperation();
        }
        catch (Exception exception) {
            this.logException(exception);
        }
    }

    protected void logException(Exception exception) {
        this.logException(null, exception);
    }

    protected void logException(String string, Exception exception) {
        int n;
        if (string != null) {
            LOGGER.warn(string, exception);
        } else {
            LOGGER.warn(exception);
        }
        if (exception.getCause() instanceof ClientException && ((n = ((ClientException)exception.getCause()).getAprError()) == 200015 || n == 150000)) {
            return;
        }
        this.svnExceptionHandler.handleExceptionWithOption((Exception)SVNExceptionWrapper.wrapSVNClientException((Exception)exception));
    }

    public SVNMergedObjectsEventHandler getMergedObjectsEventHandler() {
        return this.mergedObjectsEventHandler;
    }

    public List<VersioningTreeNode> getLastMergedObjects() {
        Design design = this.getCurrentDesign();
        if (design != null) {
            this.getMergedObjectsEventHandler();
            List<ISVNStatus> list = SVNMergedObjectsEventHandler.getSVNStatuses();
            List<StorableObjectStatus> list2 = this.convertToStorableObjectStatuses(design, list, false, false);
            if (list2.size() > 0) {
                ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
                for (StorableObjectStatus storableObjectStatus : list2) {
                    if (!(storableObjectStatus instanceof SVNStorableObjectStatus)) continue;
                    VersioningTreeNode versioningTreeNode = new VersioningTreeNode(storableObjectStatus);
                    arrayList.add(versioningTreeNode);
                }
                return arrayList;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List<VersioningTreeNode> getLastConflictedObjects() {
        Design design = this.getCurrentDesign();
        if (design != null) {
            this.getMergedObjectsEventHandler();
            List<ISVNStatus> list = SVNMergedObjectsEventHandler.getSVNStatuses();
            List<StorableObjectStatus> list2 = this.convertToStorableObjectStatuses(design, list, false, false);
            if (list2.size() > 0) {
                ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
                for (StorableObjectStatus storableObjectStatus : list2) {
                    if (!(storableObjectStatus instanceof SVNStorableObjectStatus)) continue;
                    VersioningTreeNode versioningTreeNode = new VersioningTreeNode(storableObjectStatus);
                    arrayList.add(versioningTreeNode);
                }
                return arrayList;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public Design getCurrentDesign() {
        return this.currentDesign;
    }

    public void setCurrentDesign(Design design) {
        this.currentDesign = design;
    }

    public void doRemoveLocalFilesFirst(File file) {
        Design design = ApplicationView.getInstance().getCurrentDesign();
        if (file.isDirectory()) {
            List<File> list = new ArrayList<File>();
            if ((list = this.getFilesList(file, list)).size() > 0) {
                File[] fileArray = list.toArray(new File[list.size()]);
                this.collectFiles(list);
                try {
                    this.client.remove(fileArray, true);
                }
                catch (SVNClientException sVNClientException) {
                    this.logException("doRemove", (Exception)((Object)sVNClientException));
                }
                this.refresh(fileArray);
                if (this.commit()) {
                    this.doCommit(fileArray, Messages.getString("SVNMergeWindow.DeleteLocalCommitMessage"), false, false);
                    this.doUpdate(new File[]{new File(design.getDesignPath())}, true);
                }
            }
        }
    }

    protected void refresh(File[] fileArray) {
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        Design design = ApplicationView.getInstance().getCurrentDesign();
        for (File file : fileArray) {
            SVNStorableObjectStatus sVNStorableObjectStatus = new SVNStorableObjectStatus(design, file, "D", null, null);
            arrayList.add(new VersioningTreeNode(sVNStorableObjectStatus));
        }
        VersioningTreeNode.refresh(arrayList, false, true);
    }

    protected boolean commit() {
        int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SVNMergeWindow.DeleteLocalFilesCommitDialogText"), Messages.getString("SVNMergeWindow.DeleteLocalCommitDialogTitle"), 0, 3);
        return n == 0;
    }

    protected void collectFiles(List<File> list) {
        Design design = ApplicationView.getInstance().getCurrentDesign();
        List<DeletedFile> list2 = design.getDLSettings().getDeletedFiles();
        for (File file : list) {
            ISVNInfo iSVNInfo = this.doInfo(file);
            String string = iSVNInfo.getUrlString();
            Long l = iSVNInfo.getRevision().getNumber();
            list2.add(new DeletedFile(file, string, l));
        }
        design.saveDesignLevelSettings();
    }

    public List<File> getFilesList(File file, List<File> list) {
        File file2 = file;
        File[] fileArray = file2.listFiles();
        if (fileArray.length != 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    if (fileArray[i].getName().equals(".svn")) continue;
                    this.getFilesList(fileArray[i], list);
                    continue;
                }
                list.add(fileArray[i]);
            }
        }
        return list;
    }

    public static String commonPath(File ... fileArray) {
        int n;
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getAbsolutePath();
        }
        String string = "";
        String[][] stringArrayArray = new String[stringArray.length][];
        String string2 = "\\" + File.separator;
        for (n = 0; n < stringArray.length; ++n) {
            stringArrayArray[n] = stringArray[n].split(string2);
        }
        for (n = 0; n < stringArrayArray[0].length; ++n) {
            String string3 = stringArrayArray[0][n];
            boolean bl = true;
            for (int i = 1; i < stringArrayArray.length && bl; bl &= stringArrayArray[i][n].equals(string3), ++i) {
                if (stringArrayArray[i].length >= n) continue;
                bl = false;
                break;
            }
            if (!bl) break;
            string = string + string3 + File.separator;
        }
        return string;
    }

    static class SVNMergedObjectsEventHandler
    implements ISVNEventHandler {
        static List<ISVNStatus> svnStatuses = new ArrayList<ISVNStatus>();
        List<ISVNStatus> conflictStatuses = new ArrayList<ISVNStatus>();
        SVNClientHelper clientHelper;

        public SVNMergedObjectsEventHandler(SVNClientHelper sVNClientHelper) {
            this.clientHelper = sVNClientHelper;
        }

        public void handleEvent(SVNEvent sVNEvent, double d) throws SVNException {
            List<ISVNStatus> list;
            boolean bl = false;
            boolean bl2 = false;
            if (sVNEvent.getContentsStatus() == SVNStatusType.CONFLICTED || sVNEvent.getContentsStatus() == SVNStatusType.CONFLICTED_UNRESOLVED) {
                bl2 = true;
            } else if (sVNEvent.getAction() == SVNEventAction.TREE_CONFLICT) {
                bl2 = true;
            } else if (sVNEvent.getAction() == SVNEventAction.UPDATE_ADD) {
                bl = true;
            } else if (sVNEvent.getAction() == SVNEventAction.UPDATE_DELETE) {
                bl = true;
            } else if (sVNEvent.getAction() == SVNEventAction.UPDATE_UPDATE) {
                bl = true;
            } else if (sVNEvent.getAction() == SVNEventAction.MERGE_COMPLETE) {
                // empty if block
            }
            if (bl && sVNEvent.getFile().isFile() && VCSClientHelper.accept(sVNEvent.getFile())) {
                list = this.clientHelper.doStatus(sVNEvent.getFile(), false);
                svnStatuses.addAll(list);
            }
            if (bl2 && sVNEvent.getFile().isFile() && VCSClientHelper.accept(sVNEvent.getFile())) {
                list = this.clientHelper.doStatus(sVNEvent.getFile(), false);
                this.conflictStatuses.addAll(list);
            }
        }

        public void checkCancelled() throws SVNCancelException {
        }

        public static List<ISVNStatus> getSVNStatuses() {
            return svnStatuses;
        }

        public void clearSVNStatuses() {
            svnStatuses.clear();
            this.conflictStatuses.clear();
        }
    }

    static class SVNLogEventHandler
    implements ISVNEventHandler {
        StringBuilder log = new StringBuilder();

        SVNLogEventHandler() {
        }

        public void handleEvent(SVNEvent sVNEvent, double d) throws SVNException {
            if (sVNEvent.getContentsStatus() == SVNStatusType.CONFLICTED || sVNEvent.getContentsStatus() == SVNStatusType.CONFLICTED_UNRESOLVED) {
                this.log.append("Conflict ").append(sVNEvent.getFile().getPath()).append('\n');
            } else if (sVNEvent.getAction() == SVNEventAction.TREE_CONFLICT) {
                this.log.append("Tree Conflict ").append(sVNEvent.getFile().getPath()).append('\n');
            } else if (sVNEvent.getAction() == SVNEventAction.UPDATE_ADD) {
                this.log.append("Add ").append(sVNEvent.getFile().getPath()).append('\n');
            } else if (sVNEvent.getAction() == SVNEventAction.UPDATE_DELETE) {
                this.log.append("Delete ").append(sVNEvent.getFile().getPath()).append('\n');
            } else if (sVNEvent.getAction() == SVNEventAction.UPDATE_UPDATE) {
                this.log.append("Update ").append(sVNEvent.getFile().getPath()).append('\n');
            } else if (sVNEvent.getAction() == SVNEventAction.MERGE_COMPLETE) {
                this.log.append("Merge finished").append('\n');
            }
        }

        public void checkCancelled() throws SVNCancelException {
        }

        public StringBuilder getLog() {
            return this.log;
        }
    }

    static class SVNStatus
    implements ISVNStatus {
        private SVNDiffSummary diffSummary;
        private SVNUrl svnUrl;
        private SVNUrl baseUrl;
        private File file;

        private SVNStatus(SVNDiffSummary sVNDiffSummary, File file, String string) throws MalformedURLException {
            this.diffSummary = sVNDiffSummary;
            String string2 = sVNDiffSummary.getPath();
            this.baseUrl = new SVNUrl(string);
            this.svnUrl = new SVNUrl(string + "/" + string2);
            this.file = new File(file.getParent(), string2);
        }

        public SVNUrl getUrl() {
            return this.svnUrl;
        }

        public String getUrlString() {
            return this.svnUrl.toString();
        }

        public SVNUrl getBaseUrl() {
            return this.baseUrl;
        }

        public SVNRevision.Number getLastChangedRevision() {
            return null;
        }

        public Date getLastChangedDate() {
            return null;
        }

        public String getLastCommitAuthor() {
            return null;
        }

        public SVNStatusKind getTextStatus() {
            return this.getRepositoryTextStatus();
        }

        public SVNStatusKind getRepositoryTextStatus() {
            if (SVNDiffSummary.SVNDiffKind.ADDED.equals((Object)this.diffSummary.getDiffKind())) {
                return SVNStatusKind.ADDED;
            }
            if (SVNDiffSummary.SVNDiffKind.DELETED.equals((Object)this.diffSummary.getDiffKind())) {
                return SVNStatusKind.DELETED;
            }
            if (SVNDiffSummary.SVNDiffKind.MODIFIED.equals((Object)this.diffSummary.getDiffKind())) {
                return SVNStatusKind.MODIFIED;
            }
            return SVNStatusKind.NORMAL;
        }

        public SVNStatusKind getPropStatus() {
            return null;
        }

        public SVNStatusKind getRepositoryPropStatus() {
            return null;
        }

        public SVNRevision.Number getRevision() {
            return null;
        }

        public String getPath() {
            return this.file.getPath();
        }

        public File getFile() {
            return this.file;
        }

        public SVNNodeKind getNodeKind() {
            return null;
        }

        public boolean isCopied() {
            return false;
        }

        public boolean isWcLocked() {
            return false;
        }

        public boolean isSwitched() {
            return false;
        }

        public SVNUrl getUrlCopiedFrom() {
            return null;
        }

        public File getConflictNew() {
            return null;
        }

        public File getConflictOld() {
            return null;
        }

        public File getConflictWorking() {
            return null;
        }

        public String getLockOwner() {
            return null;
        }

        public Date getLockCreationDate() {
            return null;
        }

        public String getLockComment() {
            return null;
        }
    }

    static class PathComparator
    implements Comparator<StorableObjectStatus> {
        PathComparator() {
        }

        @Override
        public int compare(StorableObjectStatus storableObjectStatus, StorableObjectStatus storableObjectStatus2) {
            return storableObjectStatus2.getPathString().compareTo(storableObjectStatus.getPathString());
        }
    }
}

