/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNIncomingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.SVNOutgoingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.SVNUnversionedFilesChangeList;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.ide.layout.ViewId;
import oracle.jdeveloper.vcs.changelist.ChangeList;

public class SVNChangeListWindow
extends DataModelerChangeListWindow {
    public static final String WINDOW_ID = "SVNStatusCommandWindow";
    public static final ViewId VIEW_ID = new ViewId("EXTDockable", "SVNStatusCommandWindow");
    private static final SVNOutgoingChangesChangeList OUTGOING_CHANGES_CHANGELIST = new SVNOutgoingChangesChangeList();
    private static final SVNIncomingChangesChangeList INCOMING_CHANGES_CHANGE_LIST = new SVNIncomingChangesChangeList();
    private static final SVNUnversionedFilesChangeList UNVERSIONED_FILES_CHANGE_LIST = new SVNUnversionedFilesChangeList();
    private static final DefaultComboBoxModel SCOPE_COMBO_BOX_MODEL = new DefaultComboBoxModel();

    public SVNChangeListWindow() {
        super(new ChangeList[]{INCOMING_CHANGES_CHANGE_LIST, OUTGOING_CHANGES_CHANGELIST, UNVERSIONED_FILES_CHANGE_LIST}, VIEW_ID.getId());
        INCOMING_CHANGES_CHANGE_LIST.setWindow(this);
        INCOMING_CHANGES_CHANGE_LIST.setDependantChangeList(OUTGOING_CHANGES_CHANGELIST);
        INCOMING_CHANGES_CHANGE_LIST.setAutoRefreshDependantChangeList(true);
        INCOMING_CHANGES_CHANGE_LIST.getScopeComboBox().setModel(SCOPE_COMBO_BOX_MODEL);
        OUTGOING_CHANGES_CHANGELIST.setWindow(this);
        OUTGOING_CHANGES_CHANGELIST.setRefreshWhenNotVisible(true);
        OUTGOING_CHANGES_CHANGELIST.setDependantChangeList(INCOMING_CHANGES_CHANGE_LIST);
        OUTGOING_CHANGES_CHANGELIST.setAutoRefreshDependantChangeList(false);
        OUTGOING_CHANGES_CHANGELIST.setSecondDependantChangeList(UNVERSIONED_FILES_CHANGE_LIST);
        OUTGOING_CHANGES_CHANGELIST.setAutoRefreshSecondDependantChangeList(true);
        OUTGOING_CHANGES_CHANGELIST.getScopeComboBox().setModel(SCOPE_COMBO_BOX_MODEL);
        UNVERSIONED_FILES_CHANGE_LIST.setWindow(this);
        UNVERSIONED_FILES_CHANGE_LIST.setRefreshWhenNotVisible(true);
        UNVERSIONED_FILES_CHANGE_LIST.setVersionedOnly(false);
        SVNChangeListWindow.addToScope(ApplicationView.getInstance().getDesigns());
    }

    public static void addToScope(DesignSet designSet) {
        Iterator iterator = designSet.iterator();
        while (iterator.hasNext()) {
            SVNChangeListWindow.addToScope((Design)iterator.next());
        }
    }

    public static void addToScope(Design design) {
        if (SCOPE_COMBO_BOX_MODEL != null && design.isVersioned() && SCOPE_COMBO_BOX_MODEL.getIndexOf(design) == -1) {
            SCOPE_COMBO_BOX_MODEL.addElement(design);
        }
    }

    public static void removeFromScope(Design design) {
        if (SCOPE_COMBO_BOX_MODEL != null) {
            SCOPE_COMBO_BOX_MODEL.removeElement(design);
        }
    }

    public static void removeAllDesignsFromScope() {
        if (SCOPE_COMBO_BOX_MODEL != null) {
            SCOPE_COMBO_BOX_MODEL.removeAllElements();
        }
    }

    public static SVNOutgoingChangesChangeList getSVNOutgoingChangesChangeList() {
        return OUTGOING_CHANGES_CHANGELIST;
    }

    public static SVNIncomingChangesChangeList getSVNIncomingChangesChangeList() {
        return INCOMING_CHANGES_CHANGE_LIST;
    }
}

