/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.vcs.TextCompareEditor;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class VCSTextComparePanel
extends JPanel {
    private static final Logger LOGGER = new Logger(VCSTextComparePanel.class);
    private boolean isOk = false;
    private TextCompareEditor editor;
    private File localFile;

    public VCSTextComparePanel(File file, InputStream inputStream, String string, InputStream inputStream2, String string2, boolean bl, boolean bl2) throws HeadlessException {
        this.localFile = file;
        this.editor = new TextCompareEditor(inputStream, inputStream2, string, string2, bl, bl2);
        Component component = this.editor.getGUI();
        JPanel jPanel = new JPanel(new FlowLayout(2, 12, 12));
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        jButton.setMnemonic(79);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VCSTextComparePanel.this.isOk = true;
                VCSTextComparePanel.this.save();
                VCSTextComparePanel.this.closeParent();
            }
        });
        jPanel.add(jButton);
        jButton2.setMnemonic(67);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VCSTextComparePanel.this.isOk = false;
                VCSTextComparePanel.this.closeParent();
            }
        });
        jPanel.add(jButton2);
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
        this.add((Component)jPanel, "South");
    }

    public abstract void closeParent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        if (this.localFile != null) {
            try {
                FileWriter fileWriter = new FileWriter(this.localFile);
                try {
                    fileWriter.write(this.editor.getRightText());
                }
                finally {
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {
                LOGGER.error(iOException);
            }
        }
    }

    public TextCompareEditor getEditor() {
        return this.editor;
    }

    public boolean isOk() {
        return this.isOk;
    }
}

