/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ChangeRequestSet;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesignSet;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesignSet;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.model.Displayable;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class StorableObjectStatus
implements Displayable {
    public static final String SHORT_STATUS_ADDED = "A";
    public static final String SHORT_STATUS_MODIFIED = "M";
    public static final String SHORT_STATUS_DELETED = "D";
    public static final String SHORT_STATUS_CONFLICTED = "C";
    public static final String SHORT_STATUS_MISSING = "MI";
    public static final String SHORT_STATUS_NOT_RECOGNISED = "?";
    public static final String SHORT_STATUS_NORMAL = "";
    protected String textStatus = "";
    protected String propertyStatus = "";
    protected Design design;
    protected File filePath;
    private String storableObjectName;
    private String storableObjectID;
    private String storableObjectParentID;
    private String repositoryUrl;
    private String pathUrl;
    private Long copyRevision;
    private String copyPath;
    private Class objectClass;
    private String objectType;
    private StorableObject storableObject;
    private boolean isFile;
    private DesignPart designPart;
    private RDBMSSite rdbmsSite;
    private Class<? extends DesignPart> designPartClass;
    private String shortObjectID;
    private ModelObject objectSet;
    private List<TreePathHelper> treePath = new ArrayList<TreePathHelper>();
    protected boolean remoteStatus;
    private static final Logger LOGGER = new Logger(StorableObjectStatus.class);

    public StorableObjectStatus() {
    }

    public StorableObjectStatus(StorableObject storableObject) {
        this.storableObject = storableObject;
        this.filePath = new File(storableObject instanceof ModelIDObject ? ((ModelIDObject)storableObject).getSegmentedStorageName() : storableObject.getStorageName());
        this.design = storableObject.getDesign();
    }

    public abstract Long getRevision();

    public void setStorableObjectName(String string) {
        this.storableObjectName = string;
    }

    public void setStorableObjectID(String string) {
        this.storableObjectID = string;
    }

    public String getStorableObjectParentID() {
        return this.storableObjectParentID;
    }

    public void setStorableObjectParentID(String string) {
        this.storableObjectParentID = string;
    }

    public StorableObject getStorableObject() {
        if (this.storableObject == null && this.objectSet != null) {
            if (this.objectSet instanceof DesignObjectSet) {
                this.storableObject = ((DesignObjectSet)this.objectSet).getObjectByID(this.storableObjectID);
            } else if (this.objectSet instanceof ModelIDObjectSet) {
                this.storableObject = ((ModelIDObjectSet)this.objectSet).getObjectByID(this.storableObjectID);
            }
        }
        if (this.storableObject == null && this.objectClass == Design.class) {
            this.storableObject = this.design;
        }
        return this.storableObject;
    }

    public Class<? extends DesignPart> getDesignPartClass() {
        return this.designPart != null ? this.designPart.getClass() : this.designPartClass;
    }

    public String getShortObjectID() {
        return this.designPart != null ? this.designPart.getShortObjectID() : this.shortObjectID;
    }

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public RDBMSSite getRdbmsSite() {
        return this.rdbmsSite;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public String getURL() {
        return this.repositoryUrl + this.pathUrl;
    }

    public void setRepositoryUrl(String string) {
        this.repositoryUrl = string;
    }

    public void setPathUrl(String string) {
        this.pathUrl = string;
    }

    public String getPathUrl() {
        return this.pathUrl;
    }

    public Long getCopyRevision() {
        return this.copyRevision;
    }

    public void setCopyRevision(Long l) {
        this.copyRevision = l;
    }

    public String getCopyPath() {
        return this.copyPath;
    }

    public void setCopyPath(String string) {
        this.copyPath = string;
    }

    public boolean isAdded() {
        return SHORT_STATUS_ADDED.equals(this.textStatus);
    }

    public boolean isModified() {
        return SHORT_STATUS_MODIFIED.equals(this.textStatus);
    }

    public boolean isDeleted() {
        return SHORT_STATUS_DELETED.equals(this.textStatus);
    }

    public boolean isMissing() {
        return SHORT_STATUS_MISSING.equals(this.textStatus);
    }

    public String getTextStatus() {
        return this.textStatus;
    }

    public String getPropertyStatus() {
        return this.propertyStatus;
    }

    public void setTextStatus(String string) {
        this.textStatus = string;
    }

    public String getStorableObjectID() {
        StorableObject storableObject = this.getStorableObject();
        return storableObject == null ? this.storableObjectID : (storableObject instanceof DesignPartView ? ((DesignPartView)storableObject).getDPVId() : ((ModelIDObject)storableObject).getObjectID());
    }

    public String getStorableObjectName() {
        StorableObject storableObject = this.getStorableObject();
        return storableObject == null ? this.storableObjectName : storableObject.getName();
    }

    public String getShortLabel() {
        return null;
    }

    public String getLongLabel() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public Class getObjectClass() {
        if (this.objectClass == null && this.storableObject != null) {
            return this.storableObject.getClass();
        }
        return this.objectClass;
    }

    public ModelObject getParent() {
        return this.objectSet;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public Design getDesign() {
        return this.design;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public TreePathHelper[] getPath() {
        return this.treePath.toArray(new TreePathHelper[0]);
    }

    public String getPathString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TreePathHelper treePathHelper : this.treePath) {
            stringBuilder.append(treePathHelper.getPathName());
            stringBuilder.append("/");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    protected void parse(File file, SVNUrl sVNUrl) {
        try {
            String string = file.getName();
            String string2 = FileUtils.removeExt(string);
            this.storableObject = null;
            this.isFile = this.isFile(file);
            if (!this.isFile) {
                this.parseFolder(file);
                return;
            }
            if (file.getName().endsWith(".local") || file.getName().endsWith(".localz")) {
                return;
            }
            if ("dl_settings.xml".equalsIgnoreCase(string)) {
                this.parseDLSettings(file);
                return;
            }
            if ("ExtendedMap".equalsIgnoreCase(string2) || string2.startsWith("ExtendedMap_RM")) {
                this.parseMappings(file);
                return;
            }
            if ("defaultRDBMSSites.xml".equalsIgnoreCase(string) || "defaultdomains.xml".equalsIgnoreCase(string) || "types.xml".equalsIgnoreCase(string) || "dr_custom_scripts.xml".equalsIgnoreCase(string) || "report_templates.xml".equalsIgnoreCase(string)) {
                this.parseSystemTypes(file);
                return;
            }
            if (string.endsWith("_RDBMSSites.xml")) {
                this.parseDesignRDBMSSites(file);
                return;
            }
            this.storableObjectID = FileUtils.removeExt(string);
            String string3 = FileUtils.fixPath(file.getCanonicalPath());
            String string4 = FileUtils.fixPath(this.design.getStoragePath());
            string4 = FileUtils.addLastSlash(string4);
            boolean bl = this.parseDesign(file) || this.parseBusinessInfoDesign(file) || this.parseDatatypeDesign(file) || this.parseLogicalDesign(file) || this.parseRelationalDesign(file) || this.parseMultidimensionalDesign(file) || this.parseProcessModel(file) || this.parseDataFlowDesign(file) || this.parseFKFolder(file) || this.parseChangeRequest(file) || this.parseObject(file, sVNUrl, string3, string4);
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
        }
    }

    private boolean parseObject(File file, SVNUrl sVNUrl, String string, String string2) {
        try {
            String string3;
            string = string.substring(string2.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string4 = stringTokenizer.nextToken();
            String string5 = string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            if ("domains".equalsIgnoreCase(string4)) {
                this.filePath = file;
                this.objectClass = DomainFileWrapper.class;
                this.storableObjectID = this.storableObjectName = FileUtils.removeExt(file.getName());
                this.treePath.add(new TreePathHelper("domains", file.getParentFile(), DomainFileWrapper.class));
                return true;
            }
            StorableObjectStatusHelper storableObjectStatusHelper = this.design.getDesignPart(string4, string3);
            if (storableObjectStatusHelper != null) {
                if (storableObjectStatusHelper.designPartClass == BusinessInfoDesign.class) {
                    BusinessInfoDesign.initObjectDetails(this.design, file, string3, storableObjectStatusHelper, this.storableObjectID);
                } else if (storableObjectStatusHelper.designPartClass == DataTypesDesign.class) {
                    DataTypesDesign.initObjectDetails(this.design, file, string3, storableObjectStatusHelper, this.storableObjectID);
                } else if (storableObjectStatusHelper.designPartClass == LogicalDesign.class) {
                    LogicalDesign.initObjectDetails(this.design, file, string3, storableObjectStatusHelper, this.storableObjectID);
                } else if (storableObjectStatusHelper.designPartClass == RelationalDesign.class) {
                    String string6 = stringTokenizer.nextToken();
                    RelationalDesign.initObjectDetails(this.design, file, sVNUrl, this.remoteStatus, string6, storableObjectStatusHelper, this.storableObjectID, string);
                } else if (storableObjectStatusHelper.designPartClass == MultidimensionalDesign.class) {
                    String string7 = stringTokenizer.nextToken();
                    MultidimensionalDesign.initObjectDetails(this.design, file, string7, storableObjectStatusHelper, this.storableObjectID);
                } else if (storableObjectStatusHelper.designPartClass == ProcessModel.class) {
                    if (!this.isDataFlowDesign(file.getParentFile()) && "dflows".equalsIgnoreCase(string3)) {
                        String string8 = stringTokenizer.nextToken();
                        String string9 = stringTokenizer.nextToken();
                        this.design.getProcessModel().initDesignPart(string3, string8, storableObjectStatusHelper);
                        DataFlowDesign.initObjectDetails(this.design, file, string9, storableObjectStatusHelper, this.storableObjectID);
                    } else if (string.indexOf("/tt/") > 0) {
                        String string10 = null;
                        stringTokenizer.nextToken();
                        String string11 = stringTokenizer.nextToken();
                        String string12 = stringTokenizer.nextToken();
                        if (!string12.startsWith(this.storableObjectID)) {
                            string11 = stringTokenizer.nextToken();
                            string10 = string12;
                        }
                        TransformationTask.initObjectDetails(this.design, file, string11, storableObjectStatusHelper, this.storableObjectID, string10);
                        this.designPartClass = storableObjectStatusHelper.designPartClass;
                    } else {
                        ProcessModel.initObjectDetails(this.design, file, string3, storableObjectStatusHelper, this.storableObjectID);
                    }
                }
                this.objectClass = storableObjectStatusHelper.objectClass;
                this.objectType = storableObjectStatusHelper.objectType;
                this.designPart = storableObjectStatusHelper.designPart;
                this.rdbmsSite = storableObjectStatusHelper.rdbmsSite;
                this.objectSet = storableObjectStatusHelper.objectSet;
                this.storableObject = storableObjectStatusHelper.storableObject;
                this.treePath.addAll(storableObjectStatusHelper.treePath);
                return true;
            }
        }
        catch (Exception exception) {
            LOGGER.error("StorableObjectStatus.parseObject(): " + file.getAbsolutePath(), exception);
        }
        return false;
    }

    private DesignPart findMultidimensionalDesign(Design design, String string) {
        this.designPartClass = MultidimensionalDesign.class;
        this.objectSet = design.getMultidimensionalDesigns();
        Iterator iterator = design.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            if (!multidimensionalDesign.getObjectID().equals(string)) continue;
            return multidimensionalDesign;
        }
        return null;
    }

    private DesignPart findDataFlowDesign(Design design, String string) {
        this.designPartClass = DataFlowDesign.class;
        this.objectSet = design.getProcessModel().getDataFlowDesigns();
        Iterator iterator = design.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            if (!dataFlowDesign.getObjectID().equals(string)) continue;
            return dataFlowDesign;
        }
        return null;
    }

    private DesignPart findRelationalDesignPart(Design design, String string) {
        this.designPartClass = RelationalDesign.class;
        this.objectSet = design.getRelationalDesigns();
        this.shortObjectID = string;
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!relationalDesign.getShortObjectID().equals(string)) continue;
            return relationalDesign;
        }
        return null;
    }

    private boolean parseFKFolder(File file) {
        if (file.isDirectory() && MDConfiguration.getDefaultInstance().get("fkeyPath").equals(file.getName())) {
            System.out.println("Parsing FK Folder: " + file.getAbsolutePath());
            this.objectClass = FKIndexAssociationSet.class;
            this.objectType = "FKIndexAssociation";
            this.designPart = this.findRelationalDesignPart(this.design, file.getParentFile().getName());
            if (this.designPart != null) {
                this.objectSet = ((RelationalDesign)this.designPart).getFKIndexAssociationSet();
            }
            this.treePath.add(new TreePathHelper(Design.getRelationalModelsSetName(), file.getParentFile(), RelationalDesignSet.class));
            return true;
        }
        return false;
    }

    private boolean parseRelationalDesign(File file) {
        if (this.isRelational(file.getParentFile())) {
            this.objectClass = RelationalDesign.class;
            this.designPart = this.findRelationalDesignPart(this.design, this.storableObjectID);
            this.treePath.add(new TreePathHelper(Design.getRelationalModelsSetName(), file.getParentFile(), RelationalDesignSet.class));
            return true;
        }
        return false;
    }

    private boolean parseLogicalDesign(File file) {
        if (this.isLogical(file.getParentFile())) {
            this.objectClass = LogicalDesign.class;
            this.designPart = this.design.getLogicalDesign();
            this.objectSet = null;
            this.storableObject = this.designPart;
            this.filePath = file;
            return true;
        }
        return false;
    }

    private boolean parseProcessModel(File file) {
        if (this.isProcessModel(file.getParentFile())) {
            this.objectClass = ProcessModel.class;
            this.designPart = this.design.getProcessModel();
            this.objectSet = null;
            this.storableObject = this.designPart;
            this.filePath = file;
            return true;
        }
        return false;
    }

    private boolean parseBusinessInfoDesign(File file) {
        if ("businessinfo".equals(file.getParentFile().getName())) {
            this.objectClass = BusinessInfoDesign.class;
            this.designPart = this.design.getBusinessInfoDesign();
            this.objectSet = null;
            this.storableObject = this.designPart;
            this.filePath = file;
            return true;
        }
        return false;
    }

    private boolean parseDatatypeDesign(File file) {
        if ("datatypes".equals(file.getParentFile().getName())) {
            this.objectClass = DataTypesDesign.class;
            this.designPart = this.design.getDataTypesDesign();
            this.storableObject = this.designPart;
            this.filePath = file;
            return true;
        }
        return false;
    }

    private boolean parseChangeRequest(File file) {
        if ("changerequest".equals(file.getParentFile().getName())) {
            this.parseFile(file);
            this.objectClass = ChangeRequest.class;
            this.objectSet = this.design.getChangeRequestSet();
            this.treePath.add(new TreePathHelper("changerequest", file.getParentFile(), ChangeRequestSet.class));
            return true;
        }
        return false;
    }

    private boolean parseMultidimensionalDesign(File file) {
        if (this.isMultidimensional(file.getParentFile())) {
            this.objectClass = MultidimensionalDesign.class;
            this.designPart = this.findMultidimensionalDesign(this.design, this.storableObjectID);
            this.treePath.add(new TreePathHelper(Design.getMultidimensionalDesignSetName(), file.getParentFile(), MultidimensionalDesignSet.class));
            return true;
        }
        return false;
    }

    private boolean parseDataFlowDesign(File file) {
        if ("dflows".equals(file.getParentFile().getName())) {
            this.objectClass = DataFlowDesign.class;
            this.designPart = this.findDataFlowDesign(this.design, this.storableObjectID);
            try {
                SVNObjectHelper sVNObjectHelper;
                SVNObjectHelper sVNObjectHelper2 = SVNObjectHelper.getSVNObjectHelperFor(this.design, this.storableObjectID);
                if (sVNObjectHelper2 != null && (sVNObjectHelper = SVNObjectHelper.getSVNObjectHelperFor(this.design, sVNObjectHelper2.parentID)) != null) {
                    Class<ModelIDObject> clazz = Class.forName(sVNObjectHelper.className);
                    if (clazz.isAssignableFrom(ProcessModel.class)) {
                        this.treePath.add(new TreePathHelper("Process Model", new File(this.design.getProcessModel().getStorageName()), clazz));
                        this.treePath.add(new TreePathHelper(ProcessModel.getDataFlowDesignSetName(), file.getParentFile(), DataFlowDesignSet.class));
                    } else {
                        while (sVNObjectHelper != null) {
                            clazz = Class.forName(sVNObjectHelper.className);
                            if (clazz.isAssignableFrom(DataFlowDesign.class)) {
                                this.treePath.add(0, new TreePathHelper(sVNObjectHelper.propName, new File(sVNObjectHelper.fileName), clazz));
                                this.treePath.add(0, new TreePathHelper(ProcessModel.getDataFlowDesignSetName(), new File(sVNObjectHelper.fileName).getParentFile(), clazz));
                            } else if (clazz.isAssignableFrom(Process.class)) {
                                this.treePath.add(0, new TreePathHelper(sVNObjectHelper.propName, new File(sVNObjectHelper.fileName), clazz));
                                this.treePath.add(0, new TreePathHelper(DataFlowDesign.getProcessSetName(), new File(sVNObjectHelper.fileName).getParentFile(), clazz));
                            } else if (clazz.isAssignableFrom(ProcessModel.class)) {
                                this.treePath.add(0, new TreePathHelper("Process Model", new File(this.design.getProcessModel().getStorageName()), clazz));
                            }
                            if ((sVNObjectHelper = SVNObjectHelper.getSVNObjectHelperFor(this.design, sVNObjectHelper.parentID)) == null || !sVNObjectHelper.className.endsWith("Process")) continue;
                            this.treePath.remove(0);
                        }
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean parseDesign(File file) {
        String string = file.getName();
        if (string.endsWith(".dmd") || string.endsWith(".dmdz")) {
            this.storableObjectName = FileUtils.removeExt(string);
            this.objectClass = Design.class;
            return true;
        }
        return false;
    }

    private void parseFile(File file) {
        String string = file.getName();
        this.filePath = file;
        this.storableObjectName = string;
        this.storableObjectID = string;
    }

    private void parseFolder(File file) {
        this.parseFile(file);
        this.objectClass = File.class;
    }

    private void parseDLSettings(File file) {
        this.parseFile(file);
        this.objectClass = Design.DLSettings.class;
    }

    private void parseMappings(File file) {
        this.parseFile(file);
        this.objectClass = ExtendedMap.class;
        this.treePath.add(new TreePathHelper("mapping", file.getParentFile(), ExtendedMap.class));
    }

    private void parseSystemTypes(File file) {
        this.parseFile(file);
        this.treePath.add(new TreePathHelper("System Types", file.getParentFile(), null));
    }

    private void parseDesignRDBMSSites(File file) {
        this.parseFile(file);
        this.objectClass = RDBMSSite.class;
    }

    private boolean isRelational(File file) {
        return "rel".equals(file.getName());
    }

    private boolean isLogical(File file) {
        return "logical".equals(file.getName());
    }

    private boolean isProcessModel(File file) {
        return "pm".equals(file.getName());
    }

    private boolean isDataFlowDesign(File file) {
        return "dflows".equals(file.getName());
    }

    private boolean isMultidimensional(File file) {
        return "multidimensional".equals(file.getName());
    }

    public void setStorableObject(StorableObject storableObject) {
        this.storableObject = storableObject;
    }

    private boolean isFile(File file) {
        return file.exists() && file.isFile() || !file.exists() && (file.getName().endsWith(".xml") || file.getName().endsWith(".dmd") || file.getName().endsWith(".dmdz"));
    }

    public boolean equals(Object object) {
        return object instanceof StorableObjectStatus && this.design.equals(((StorableObjectStatus)object).getDesign()) && this.filePath.equals(((StorableObjectStatus)object).getFilePath());
    }
}

