/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChooseActionDialog;
import oracle.dbtools.crest.fcp.vcs.DeletedFile;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;

public class RestoreDeletedFilesDialog
extends ChooseActionDialog {
    private static final String ACTION_RESTORE = Messages.getString("RestoreDeletedFilesDialog.ActionRestore");
    private static final String ACTION_REMOVE = Messages.getString("RestoreDeletedFilesDialog.ActionRemove");
    private static final String[] ACTIONS = new String[]{ACTION_RESTORE, ACTION_REMOVE};
    private static final RestoreDeletedFilesDialog INSTANCE = new RestoreDeletedFilesDialog();
    private static final Logger LOGGER = new Logger(RestoreDeletedFilesDialog.class);
    private Map<DeletedFile, String> deletedFilesActions = new HashMap<DeletedFile, String>();

    public static RestoreDeletedFilesDialog getInstance() {
        return INSTANCE;
    }

    private List<DeletedFile> getDeletedFiles() {
        return ApplicationView.getInstance().getCurrentDesign().getDLSettings().getDeletedFiles();
    }

    @Override
    protected String getTitle() {
        return Messages.getString("RestoreDeletedFilesDialog.RestoreDeletedFiles");
    }

    @Override
    protected String[] getActions() {
        return ACTIONS;
    }

    @Override
    protected ActionListener getActionsActionListener() {
        return null;
    }

    @Override
    protected ChooseActionDialog.ActionsTableModel getActionsTableModel() {
        return new ChooseActionDialog.ActionsTableModel(){

            @Override
            public int getRowCount() {
                return RestoreDeletedFilesDialog.this.getDeletedFiles().size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return ((DeletedFile)RestoreDeletedFilesDialog.this.getDeletedFiles().get(n)).getLocalFile();
                }
                if (n2 == 1) {
                    String string = (String)RestoreDeletedFilesDialog.this.deletedFilesActions.get(RestoreDeletedFilesDialog.this.getDeletedFiles().get(n));
                    if (string != null) {
                        return string;
                    }
                    this.setValueAt(ACTION_RESTORE, n, n2);
                    return ACTION_RESTORE;
                }
                return super.getValueAt(n, n2);
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (n2 == 1) {
                    DeletedFile deletedFile = (DeletedFile)RestoreDeletedFilesDialog.this.getDeletedFiles().get(n);
                    RestoreDeletedFilesDialog.this.deletedFilesActions.put(deletedFile, (String)object);
                } else {
                    super.setValueAt(object, n, n2);
                }
            }
        };
    }

    @Override
    protected String getActionsTableModelFirstColumnName() {
        return Messages.getString("RestoreDeletedFilesDialog.DeletedFile");
    }

    @Override
    protected DefaultTableCellRenderer getActionsCellRenderer() {
        return null;
    }

    public void processDeletedFiles() {
        this.deletedFilesActions.clear();
        if (this.showDialog()) {
            ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
            boolean bl = false;
            for (DeletedFile deletedFile : this.deletedFilesActions.keySet()) {
                String string = this.deletedFilesActions.get(deletedFile);
                if (ACTION_REMOVE.equals(string)) {
                    this.getDeletedFiles().remove(deletedFile);
                    bl = true;
                    continue;
                }
                if (!ACTION_RESTORE.equals(string)) continue;
                StorableObjectStatus storableObjectStatus = deletedFile.getStorableObjectStatus();
                VCS_CLIENT_HELPER.doCopy(storableObjectStatus.getURL(), storableObjectStatus.getFilePath(), storableObjectStatus.getRevision());
                storableObjectStatus.setTextStatus("A");
                arrayList.add(new VersioningTreeNode(storableObjectStatus));
                this.getDeletedFiles().remove(deletedFile);
                bl = true;
            }
            if (!arrayList.isEmpty()) {
                VersioningTreeNode.refresh(arrayList, false, true);
            }
            if (bl) {
                ApplicationView.getInstance().getCurrentDesign().saveDesignLevelSettings();
            }
        }
    }
}

