/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChangeListTreePanel;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.UpdateableAction;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNAddPropertyCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNCommandController;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNVersionHistoryCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNViewPropertiesCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.jdeveloper.vcs.changelist.AsynchronousChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.vop.BaseVersionOperationPanel;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;

public abstract class DataModelerChangeList
extends AsynchronousChangeList {
    private static final Logger LOGGER = new Logger(DataModelerChangeList.class);
    protected IChangeListPanel panel;
    protected DataModelerChangeListWindow window;
    protected DataModelerChangeList dependantChangeList;
    protected DataModelerChangeList secondDependantChangeList;
    protected boolean autoRefreshDependantChangeList;
    protected boolean autoRefreshSecondDependantChangeList;
    protected boolean refreshWhenNotVisible;
    protected JPopupMenu popupMenu;
    protected static final JComboBox scopeComboBox = DataModelerChangeList.createScopeComboBox();
    private static final String OPENING_BRACKET_CONFLICTS = " (";
    private static final String CLOSING_BRACKET_CONFLICTS = ")";
    boolean versionedOnly = true;

    public DataModelerChangeList(String string) {
        super((Object)string);
        this.addScopeComboBoxListener();
        BaseVersionOperationPanel baseVersionOperationPanel = (BaseVersionOperationPanel)this.createChangeListPanel();
        this.initializeVersionOperationPanel(baseVersionOperationPanel);
        this.layoutPanel(baseVersionOperationPanel);
        this.installPopupMenu();
    }

    protected IChangeListPanel createChangeListPanel() {
        this.panel = new ChangeListTreePanel(this);
        return this.panel;
    }

    protected void installPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.addActions();
        IdeAction ideAction = this.addCompareActions();
        this.addAdditionalActions();
        this.addPopupMenu(this.getPanel(), this.popupMenu, ideAction);
    }

    public void addPopupMenu(final IChangeListPanel iChangeListPanel, final JPopupMenu jPopupMenu, final IdeAction ideAction) {
        iChangeListPanel.getUnderlyingComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && iChangeListPanel.hasSelection()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DataModelerChangeList.this.updateActions(jPopupMenu);
                if (mouseEvent.isPopupTrigger() && iChangeListPanel.hasSelection()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    try {
                        if (ideAction != null && ideAction.isEnabled()) {
                            ideAction.performAction();
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn(exception);
                    }
                }
            }
        });
    }

    private void updateActions(JPopupMenu jPopupMenu) {
        for (int i = 0; i < jPopupMenu.getComponents().length; ++i) {
            Action action;
            Component component = jPopupMenu.getComponents()[i];
            if (component instanceof JMenu) {
                this.updateActions(((JMenu)component).getPopupMenu());
                continue;
            }
            if (!(component instanceof JMenuItem) || (action = ((JMenuItem)component).getAction()) == null) continue;
            if (action instanceof IdeAction) {
                ((IdeAction)action).updateAction();
                continue;
            }
            if (!(action instanceof UpdateableAction)) continue;
            ((UpdateableAction)action).update();
        }
    }

    protected void addAdditionalActions() {
        IdeAction ideAction = SVNVersionHistoryCommand.getAction();
        if (ideAction != null) {
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)ideAction));
        }
        if ((ideAction = SVNViewPropertiesCommand.getAction()) != null) {
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)ideAction));
        }
        if ((ideAction = SVNAddPropertyCommand.getAction()) != null) {
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)ideAction));
        }
        if ((ideAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand"))) != null) {
            ideAction.setCommand("oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand");
            ideAction.setName(Messages.getString("DataModelingAddin.StorableObjectProperties"));
            SVNCommandController.getInstance().register(ideAction, (Command)new StorableObjectPropertiesCommand());
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)ideAction));
        }
    }

    protected abstract void addActions();

    protected abstract IdeAction addCompareActions();

    public abstract void clear();

    protected abstract ChangeListStatus[] getChangeListStatuses();

    public boolean isRefreshWhenNotVisible() {
        return this.refreshWhenNotVisible;
    }

    public void setRefreshWhenNotVisible(boolean bl) {
        this.refreshWhenNotVisible = bl;
    }

    public DataModelerChangeList getDependantChangeList() {
        return this.dependantChangeList;
    }

    public void setDependantChangeList(DataModelerChangeList dataModelerChangeList) {
        this.dependantChangeList = dataModelerChangeList;
    }

    public boolean isAutoRefreshDependantChangeList() {
        return this.autoRefreshDependantChangeList;
    }

    public void setAutoRefreshDependantChangeList(boolean bl) {
        this.autoRefreshDependantChangeList = bl;
    }

    public DataModelerChangeListWindow getWindow() {
        return this.window;
    }

    public void setWindow(DataModelerChangeListWindow dataModelerChangeListWindow) {
        this.window = dataModelerChangeListWindow;
    }

    protected ChangeListEventQueue createEventQueue() {
        return null;
    }

    protected void initializeChangeList() {
        this.setVisibleStatuses(this.getChangeListStatuses());
    }

    public void updateUI(List<StorableObjectStatus> list) {
        List<StorableObjectStatus> list2 = this.getPanel().update(list);
        MutableVersionOperationModel mutableVersionOperationModel = this.getModel();
        mutableVersionOperationModel.remove(Arrays.asList(mutableVersionOperationModel.getItems()));
        if (list2 != null && !list2.isEmpty()) {
            mutableVersionOperationModel.add(list2);
        }
    }

    public IChangeListPanel getPanel() {
        return this.panel;
    }

    protected void addToolbarActions(ChangeListWindow changeListWindow, Toolbar toolbar) {
        this.addScopeComboBox(toolbar);
    }

    protected void addScopeComboBox(Toolbar toolbar) {
        if (toolbar.getComponentCount() > 0) {
            toolbar.add((Component)toolbar.newSeparator(), 0);
        }
        toolbar.add((Component)scopeComboBox, 0);
    }

    protected static JComboBox createScopeComboBox() {
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                Design design = (Design)object;
                if (design != null) {
                    String string = new File(design.getStorageName()).getParent();
                    this.setText(design.getName() + DataModelerChangeList.OPENING_BRACKET_CONFLICTS + string + DataModelerChangeList.CLOSING_BRACKET_CONFLICTS);
                }
                return this;
            }
        };
        jComboBox.setRenderer(defaultListCellRenderer);
        Dimension dimension = new Dimension(SwingUtilities.computeStringWidth(defaultListCellRenderer.getFontMetrics(defaultListCellRenderer.getFont()), "ReasonablyLongApplicationNameWithIconIncludingItsLocation.jws"), jComboBox.getPreferredSize().height);
        jComboBox.setMaximumSize(dimension);
        jComboBox.setPreferredSize(dimension);
        jComboBox.setMinimumSize(dimension);
        return jComboBox;
    }

    protected void addScopeComboBoxListener() {
        scopeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    DataModelerChangeList.this.clear();
                } else if (itemEvent.getStateChange() == 1 && DataModelerChangeList.this.isVisible()) {
                    DataModelerChangeList.this.refresh();
                }
            }
        });
    }

    protected void startImpl() {
    }

    public JComboBox getScopeComboBox() {
        return scopeComboBox;
    }

    public static Design getSelectedDesign() {
        return (Design)scopeComboBox.getSelectedItem();
    }

    protected JMenu createCompareWithMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu(Messages.getString("DataModelingAddin.CompareWith"));
        jPopupMenu.add(jMenu);
        return jMenu;
    }

    public boolean isVersionedOnly() {
        return this.versionedOnly;
    }

    public void setVersionedOnly(boolean bl) {
        this.versionedOnly = bl;
    }

    public DataModelerChangeList getSecondDependantChangeList() {
        return this.secondDependantChangeList;
    }

    public void setSecondDependantChangeList(DataModelerChangeList dataModelerChangeList) {
        this.secondDependantChangeList = dataModelerChangeList;
    }

    public boolean isAutoRefreshSecondDependantChangeList() {
        return this.autoRefreshSecondDependantChangeList;
    }

    public void setAutoRefreshSecondDependantChangeList(boolean bl) {
        this.autoRefreshSecondDependantChangeList = bl;
    }
}

