/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.jdeveloper.vcs.vop.VersionOperationTreePanel;

public class ChangeListTreePanel
extends VersionOperationTreePanel
implements IChangeListPanel {
    private static final String OPENING_BRACKET_DETAILS = " [";
    private static final String CLOSING_BRACKET_DETAILS = "]";
    private static final String DETAILS_SEPARATOR = "; ";
    private static final String OPENING_BRACKET_CONFLICTS = " (";
    private static final String CLOSING_BRACKET_CONFLICTS = ")";
    private static final String PROPERTIES_MODIFIED_TEXT = "properties modified ";
    protected DefaultTreeModel treeModel;
    protected final JTree tree;
    protected List<StorableObjectStatus> statuses;
    protected int conflicts;
    protected DataModelerChangeList changeList;
    private GUIConfiguration conf = GUIConfiguration.getInstance();
    private VersioningTreeNode rootNode = null;
    private VersioningTreeNode designNode = null;
    Map<String, VersioningTreeNode> allNodesMap;
    Map mapByID;

    public ChangeListTreePanel(DataModelerChangeList dataModelerChangeList) {
        this.changeList = dataModelerChangeList;
        this.tree = (JTree)this.getInternalComponent();
        this.init();
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                VersioningTreeNode versioningTreeNode = (VersioningTreeNode)object;
                StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
                Icon icon = versioningTreeNode.getIcon();
                if (icon != null) {
                    if (storableObjectStatus != null) {
                        this.setIcon(ChangeListTreePanel.this.getIconForStatus(storableObjectStatus.getTextStatus(), icon));
                    } else {
                        this.setIcon(icon);
                    }
                }
                if (versioningTreeNode.isConflicted()) {
                    this.setForeground(Color.RED);
                }
                if (storableObjectStatus != null) {
                    String string = storableObjectStatus.getStorableObjectName();
                    StringBuilder stringBuilder = new StringBuilder(string != null ? string : versioningTreeNode.getUserObject().toString());
                    Long l = storableObjectStatus.getRevision();
                    String string2 = storableObjectStatus.getPropertyStatus();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    if (l != null) {
                        stringBuilder2.append(String.valueOf(l));
                    }
                    if ("M".equals(string2)) {
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(ChangeListTreePanel.DETAILS_SEPARATOR);
                        }
                        stringBuilder2.append(ChangeListTreePanel.PROPERTIES_MODIFIED_TEXT);
                    }
                    if (stringBuilder2.length() > 0) {
                        stringBuilder.append(ChangeListTreePanel.OPENING_BRACKET_DETAILS).append(stringBuilder2.toString()).append(ChangeListTreePanel.CLOSING_BRACKET_DETAILS);
                    }
                    this.setText(stringBuilder.toString());
                } else if (ChangeListTreePanel.this.conflicts > 0 && ChangeListTreePanel.this.treeModel.getRoot().equals(versioningTreeNode)) {
                    this.setForeground(Color.RED);
                    this.setText(versioningTreeNode.toString() + ChangeListTreePanel.OPENING_BRACKET_CONFLICTS + ChangeListTreePanel.this.conflicts + ChangeListTreePanel.CLOSING_BRACKET_CONFLICTS);
                }
                return this;
            }
        });
    }

    private Icon getIconForStatus(String string, Icon icon) {
        if ("A".equalsIgnoreCase(string)) {
            return this.conf.getObjectAddedIcon(icon);
        }
        if ("D".equalsIgnoreCase(string)) {
            return this.conf.getObjectDeletedIcon(icon);
        }
        if ("M".equalsIgnoreCase(string)) {
            return this.conf.getObjectModifiedIcon(icon);
        }
        if ("MI".equalsIgnoreCase(string)) {
            return this.conf.getObjectMissingIcon(icon);
        }
        return icon;
    }

    @Override
    public List<StorableObjectStatus> update() {
        return this.update(this.statuses);
    }

    @Override
    public List<StorableObjectStatus> update(List<StorableObjectStatus> list) {
        return this.constructTree(list);
    }

    protected List<StorableObjectStatus> constructTree(List<StorableObjectStatus> list) {
        boolean bl = false;
        this.init();
        if (list != null && list.size() > 0) {
            for (int i = list.size() - 1; i >= 0; --i) {
                StorableObjectStatus storableObjectStatus = list.get(i);
                String string = storableObjectStatus.getStorableObjectName();
                File file = storableObjectStatus.getFilePath();
                if (DataModelerChangeList.getSelectedDesign().getDesignPath().equals(file.getPath())) {
                    this.findOrCreateRootNode().setStorableObjectStatus(storableObjectStatus);
                    this.tree.setRootVisible(true);
                    continue;
                }
                if ("defaultRDBMSSites.xml".equals(string) || "defaultdomains.xml".equals(string) || "types.xml".equals(string) || "dr_custom_scripts.xml".equalsIgnoreCase(string)) {
                    String string2 = storableObjectStatus.getStorableObjectName();
                    VersioningTreeNode versioningTreeNode = this.findOrCreateNode(storableObjectStatus, storableObjectStatus.getObjectClass(), storableObjectStatus.getPath(), string2, file, this.findOrCreateRootNode());
                    versioningTreeNode.setStorableObjectStatus(storableObjectStatus);
                    continue;
                }
                this.findOrCreateDesignNode();
                if (this.addToDesignNode(storableObjectStatus)) {
                    bl = true;
                    continue;
                }
                list.remove(i);
            }
            if (bl) {
                this.findOrCreateRootNode().add(this.designNode);
            }
        }
        this.treeModel.setRoot(this.rootNode);
        this.statuses = list;
        return list;
    }

    private VersioningTreeNode findOrCreateRootNode() {
        if (this.rootNode == null) {
            File file = new File(DataModelerChangeList.getSelectedDesign().getDesignPath());
            this.rootNode = new VersioningTreeNode(file.getName(), file);
        }
        return this.rootNode;
    }

    private VersioningTreeNode findOrCreateDesignNode() {
        if (this.designNode == null) {
            this.designNode = new VersioningTreeNode(DataModelerChangeList.getSelectedDesign().getName(), new File(DataModelerChangeList.getSelectedDesign().getStorageName()), Design.class);
        }
        return this.designNode;
    }

    private void init() {
        this.allNodesMap = new HashMap<String, VersioningTreeNode>();
        this.mapByID = new HashMap();
        this.rootNode = null;
        this.designNode = null;
        this.conflicts = 0;
        this.treeModel = new DefaultTreeModel(null);
        this.tree.setModel(this.treeModel);
        this.tree.setRootVisible(false);
    }

    private boolean addToDesignNode(StorableObjectStatus storableObjectStatus) {
        Class clazz = storableObjectStatus.getObjectClass();
        if (clazz == null) {
            return false;
        }
        if (Design.class.isAssignableFrom(clazz)) {
            this.designNode.setStorableObjectStatus(storableObjectStatus);
            return true;
        }
        String string = storableObjectStatus.getStorableObjectName();
        File file = storableObjectStatus.getFilePath();
        VersioningTreeNode versioningTreeNode = this.findOrCreateNode(storableObjectStatus, clazz, storableObjectStatus.getPath(), string, file, this.designNode);
        versioningTreeNode.setStorableObjectStatus(storableObjectStatus);
        if (storableObjectStatus.getTextStatus().equals("C")) {
            ++this.conflicts;
        }
        return true;
    }

    private String convertPath(TreePathHelper[] treePathHelperArray, String string) {
        String string2 = "";
        for (int i = 0; i < treePathHelperArray.length; ++i) {
            if (i == 0) {
                string2 = string2.concat(treePathHelperArray[i].getPathName());
                continue;
            }
            string2 = string2.concat("/");
            String string3 = treePathHelperArray[i].getPathName();
            if (string3 == null) continue;
            string2 = string2.concat(string3);
        }
        if (string != null && string.length() > 0) {
            string2 = string2.length() > 0 ? string2.concat("/").concat(string) : string2.concat(string);
        }
        return string2;
    }

    VersioningTreeNode getParentNode(String string, String string2) {
        StorableObjectStatus storableObjectStatus;
        VersioningTreeNode versioningTreeNode;
        VersioningTreeNode versioningTreeNode2 = null;
        if (string2 != null && (versioningTreeNode2 = this.allNodesMap.get(string + string2)) == null && (versioningTreeNode = (VersioningTreeNode)this.mapByID.get(string2)) != null && (storableObjectStatus = versioningTreeNode.getStorableObjectStatus()) != null) {
            String string3 = storableObjectStatus.getStorableObjectParentID();
            return this.getParentNode(string, string3);
        }
        return versioningTreeNode2;
    }

    private VersioningTreeNode findOrCreateNode(StorableObjectStatus storableObjectStatus, Class clazz, TreePathHelper[] treePathHelperArray, String string, File file, VersioningTreeNode versioningTreeNode) {
        String string2 = this.convertPath(treePathHelperArray, string);
        VersioningTreeNode versioningTreeNode2 = null;
        String string3 = storableObjectStatus.getStorableObjectID();
        String string4 = storableObjectStatus.getStorableObjectParentID();
        if (clazz != null && StorageDesign.class.isAssignableFrom(clazz)) {
            string3 = null;
        }
        if (string3 != null) {
            versioningTreeNode2 = this.allNodesMap.get(string2 + string3);
        }
        if (versioningTreeNode2 == null) {
            versioningTreeNode2 = this.allNodesMap.get(string2);
        }
        if (versioningTreeNode2 == null) {
            if (treePathHelperArray.length > 0) {
                String string5 = "";
                VersioningTreeNode versioningTreeNode3 = null;
                for (int i = 0; i < treePathHelperArray.length; ++i) {
                    VersioningTreeNode versioningTreeNode4;
                    String string6 = treePathHelperArray[i].getPathName();
                    if (string6 != null) {
                        string5 = i == 0 ? string5.concat(string6) : string5.concat("/").concat(string6);
                    }
                    if ((versioningTreeNode4 = this.allNodesMap.get(string5)) == null && string4 != null) {
                        versioningTreeNode4 = this.getParentNode(string5, string4);
                    }
                    if (versioningTreeNode4 == null) {
                        versioningTreeNode4 = new VersioningTreeNode(treePathHelperArray[i].getPathName(), treePathHelperArray[i].getFile(), treePathHelperArray[i].getPathClass());
                        this.allNodesMap.put(string5, versioningTreeNode4);
                        if (versioningTreeNode3 == null) {
                            versioningTreeNode.add(versioningTreeNode4);
                        } else {
                            versioningTreeNode3.add(versioningTreeNode4);
                        }
                        versioningTreeNode3 = versioningTreeNode4;
                        continue;
                    }
                    versioningTreeNode3 = versioningTreeNode4;
                }
                if (versioningTreeNode3 != null) {
                    versioningTreeNode2 = new VersioningTreeNode(string, file, clazz);
                    if (string3 != null) {
                        this.allNodesMap.put(string2 + string3, versioningTreeNode2);
                        this.mapByID.put(string3, versioningTreeNode2);
                        if (clazz != null && RelationalDesign.class.isAssignableFrom(clazz)) {
                            this.allNodesMap.put(string2 + ModelIDObject.getShortID(string3), versioningTreeNode2);
                            this.allNodesMap.put(string2, versioningTreeNode2);
                        }
                    } else {
                        this.allNodesMap.put(string2, versioningTreeNode2);
                    }
                    versioningTreeNode3.add(versioningTreeNode2);
                }
            } else {
                versioningTreeNode2 = new VersioningTreeNode(string, file, clazz);
                if (string3 != null) {
                    this.allNodesMap.put(string2 + string3, versioningTreeNode2);
                    this.mapByID.put(string3, versioningTreeNode2);
                } else {
                    this.allNodesMap.put(string2, versioningTreeNode2);
                }
                versioningTreeNode.add(versioningTreeNode2);
            }
        }
        return versioningTreeNode2;
    }

    @Override
    public List<File> getSelectedFilePaths(List<VersioningTreeNode> list, boolean bl, boolean bl2) {
        TreePath[] treePathArray = this.getTree().getSelectionPaths();
        if (treePathArray == null) {
            return this.getAllFilePaths(list, bl, bl2);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (TreePath treePath : treePathArray) {
            VersioningTreeNode versioningTreeNode = (VersioningTreeNode)treePath.getLastPathComponent();
            if (bl2 && versioningTreeNode.getFilePath().isDirectory()) {
                bl = true;
            }
            this.addSelectedFilePath(versioningTreeNode, arrayList, bl);
            this.addTreeNodesForRefreshing(versioningTreeNode, list, bl);
        }
        return arrayList;
    }

    public List<File> getAllFilePaths(List<VersioningTreeNode> list, boolean bl, boolean bl2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        VersioningTreeNode versioningTreeNode = (VersioningTreeNode)this.treeModel.getRoot();
        VersioningTreeNode versioningTreeNode2 = null;
        if (this.tree.isRootVisible()) {
            versioningTreeNode2 = versioningTreeNode;
        } else if (versioningTreeNode != null && versioningTreeNode.getChildCount() > 0) {
            versioningTreeNode2 = (VersioningTreeNode)versioningTreeNode.getFirstChild();
        }
        if (versioningTreeNode2 != null) {
            this.addSelectedFilePath(versioningTreeNode2, arrayList, bl);
            this.addTreeNodesForRefreshing(versioningTreeNode2, list, bl);
        }
        return arrayList;
    }

    protected void addSelectedFilePath(VersioningTreeNode versioningTreeNode, List<File> list, boolean bl) {
        list.add(versioningTreeNode.getFilePath());
        if (bl) {
            this.addDependantFilePath(versioningTreeNode, list);
            for (int i = 0; i < versioningTreeNode.getChildCount(); ++i) {
                this.addSelectedFilePath((VersioningTreeNode)versioningTreeNode.getChildAt(i), list, bl);
            }
        }
    }

    private void addDependantFilePath(VersioningTreeNode versioningTreeNode, List<File> list) {
        File file = versioningTreeNode.getDependantFilePath();
        if (file != null) {
            list.add(file);
        }
    }

    protected void addTreeNodesForRefreshing(VersioningTreeNode versioningTreeNode, List<VersioningTreeNode> list, boolean bl) {
        if (versioningTreeNode.getStorableObjectStatus() != null) {
            list.add(versioningTreeNode);
        }
        if (bl) {
            for (int i = 0; i < versioningTreeNode.getChildCount(); ++i) {
                this.addTreeNodesForRefreshing((VersioningTreeNode)versioningTreeNode.getChildAt(i), list, bl);
            }
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public List<StorableObjectStatus> getStatuses() {
        return this.statuses;
    }

    @Override
    public VersioningTreeNode getSelectedNode() {
        return (VersioningTreeNode)this.tree.getLastSelectedPathComponent();
    }

    @Override
    public boolean hasSelection() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        return treePathArray != null;
    }

    @Override
    public boolean hasSingleSelection() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        return treePathArray != null && treePathArray.length == 1;
    }

    @Override
    public Component getUnderlyingComponent() {
        return this.getInternalComponent();
    }
}

