/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.DBMEncodedString;
import oracle.dbtools.crest.imports.metadata.DBType;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.thirdparty.db2.DB2ConnectionPanel;
import oracle.dbtools.thirdparty.sqlserver.SQLServerConnectionPanel;
import oracle.dbtools.thirdparty.udb.UDBConnectionPanel;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class OldConnection
extends TreeMap<String, Object>
implements Comparable {
    public static final String PROP_TYPE = "connection_type";
    public static final String PROP_NAME = "connection_name";
    public static final String PROP_HOST = "connection_host";
    public static final String PROP_PORT = "connection_port";
    public static final String PROP_SID = "connection_sid";
    public static final String PROP_SERVICE_NAME = "oracle_basic_service";
    public static final String PROP_USERNAME = "connection_username";
    public static final String PROP_PASSWORD = "connection_password";
    public static final String PROP_URL = "connection_url";
    public static final String PROP_URLBASE = "URLBASE";
    public static final String PROP_SAVEPASSWORD = "connection_save_password";
    public static final String PROP_DRIVERCLASS = "connection_driver_class";
    public static final String PROP_CONNECTIONS_LIST = "PROP_CONNECTIONS_LIST";
    public static final String PROP_OBJECT_ID = "PROP_OBJECT_ID";
    public static final String DEFAULT_NAME = "";
    public static final String DEFAULT_HOST = "localhost";
    public static final String PROP_DB2_DATABASE = "db2_data_source_name";
    public static final String PROP_ORACLE_CONN_TYPE = "oracle_connection_type";
    public static final String PROP_ORACLE_TNS_ALIAS = "oracle_tns_network_alias";
    public static final String PROP_ORACLE_ROLE = "oracle_role";
    public static final String PROP_JDBC_ALIAS = "odbc_data_source_alias";
    private static List dbmConnectionList = new ArrayList();
    private static List odConnectionList = new ArrayList();
    private static List rsConnectionList = new ArrayList();

    public OldConnection() {
        this.put(PROP_TYPE, DBType.TYPE_ORACLE);
        this.put(PROP_NAME, DEFAULT_NAME);
        this.put(PROP_HOST, DEFAULT_HOST);
        this.put(PROP_PORT, DBType.TYPE_ORACLE.getDefaultPort().toString());
        this.put(PROP_SID, DEFAULT_NAME);
        this.put(PROP_SERVICE_NAME, DEFAULT_NAME);
        this.put(PROP_USERNAME, DEFAULT_NAME);
        this.put(PROP_PASSWORD, new DBMEncodedString(new char[0]));
        this.put(PROP_URL, DEFAULT_NAME);
        this.put(PROP_DRIVERCLASS, DBType.TYPE_ORACLE.getDriverClass());
        this.put(PROP_SAVEPASSWORD, Boolean.FALSE);
        this.put(PROP_CONNECTIONS_LIST, null);
        this.put(PROP_OBJECT_ID, new GUID().toString());
    }

    public String getClassPath() {
        return (String)this.get(PROP_DRIVERCLASS);
    }

    public String getHost() {
        String string = (String)this.get(PROP_HOST);
        if (string == null) {
            string = DEFAULT_HOST;
        }
        return string;
    }

    public String getName() {
        return (String)this.get(PROP_NAME);
    }

    public boolean savePassword() {
        Boolean bl = (Boolean)this.get(PROP_SAVEPASSWORD);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public String getPassword() {
        Object v = this.get(PROP_PASSWORD);
        String string = DEFAULT_NAME;
        if (v instanceof DBMEncodedString) {
            string = ((DBMEncodedString)v).decode();
        } else if (v instanceof String) {
            string = (String)v;
        }
        if (string == null) {
            string = DEFAULT_NAME;
        }
        return string;
    }

    public int getPort() {
        Object v = this.get(PROP_PORT);
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v instanceof String) {
            int n;
            String string = (String)this.get(PROP_PORT);
            try {
                n = string == null ? 0 : Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            return n;
        }
        return 0;
    }

    public String getJDBCAlias() {
        return (String)this.get(PROP_JDBC_ALIAS);
    }

    public String getSid() {
        return (String)this.get(PROP_SID);
    }

    public String getDatabase() {
        return (String)this.get(PROP_DB2_DATABASE);
    }

    public String getServiceName() {
        return (String)this.get(PROP_SERVICE_NAME);
    }

    public DBType getType() {
        return (DBType)((Object)this.get(PROP_TYPE));
    }

    public String getTypeString() {
        return this.getType() == null ? "UNKNOWN" : this.getType().getFullName();
    }

    public String getUserName() {
        return (String)this.get(PROP_USERNAME);
    }

    public String getUrl() {
        String string = (String)this.get(PROP_URL);
        return string;
    }

    public String getOracleConnType() {
        String string = (String)this.get(PROP_ORACLE_CONN_TYPE);
        return string;
    }

    public String getOracleTNSAlias() {
        String string = (String)this.get(PROP_ORACLE_TNS_ALIAS);
        return string;
    }

    public String getOracleRole() {
        String string = (String)this.get(PROP_ORACLE_ROLE);
        return string;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public int compareTo(Object object) {
        return 0;
    }

    public static List<OldConnection> getDBMConnections() {
        return dbmConnectionList;
    }

    public static List<OldConnection> getODConnections() {
        return odConnectionList;
    }

    public static List<OldConnection> getRSConnections() {
        return rsConnectionList;
    }

    public static void importConnections() {
        OldConnection.importConnections(dbmConnectionList);
        OldConnection.importConnections(odConnectionList);
        OldConnection.importConnections(rsConnectionList);
    }

    private static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    private static void importConnections(List list) {
        for (OldConnection oldConnection : list) {
            String string = oldConnection.getName();
            Properties properties = new Properties();
            properties.setProperty("ConnName", string);
            properties.setProperty("user", oldConnection.getUserName());
            if (oldConnection.savePassword()) {
                properties.setProperty("password", oldConnection.getPassword());
                properties.setProperty("SavePassword", String.valueOf(oldConnection.savePassword()));
            }
            properties.setProperty("hostname", oldConnection.getHost());
            properties.setProperty("port", String.valueOf(oldConnection.getPort()));
            if (OldConnection.isNotEmpty(oldConnection.getServiceName())) {
                properties.setProperty("serviceName", oldConnection.getServiceName());
            }
            if (OldConnection.isNotEmpty(oldConnection.getSid())) {
                properties.setProperty("sid", oldConnection.getSid());
            }
            properties.setProperty("driver", oldConnection.getClassPath());
            properties.setProperty("customUrl", DEFAULT_NAME);
            DBType dBType = oldConnection.getType();
            if (dBType == DBType.TYPE_ORACLE) {
                properties.setProperty("subtype", "oraJDBC");
                properties.setProperty("RaptorConnectionType", "Oracle");
                properties.setProperty("oraDriverType", "thin");
                properties.setProperty("OracleConnectionType", oldConnection.getOracleConnType());
                if (OldConnection.isNotEmpty(oldConnection.getOracleTNSAlias())) {
                    properties.setProperty("customUrl", oldConnection.getOracleTNSAlias());
                }
                if (OldConnection.isNotEmpty(oldConnection.getOracleRole())) {
                    properties.setProperty("role", oldConnection.getOracleRole());
                }
            } else if (dBType == DBType.TYPE_SQL_SERVER_2000 || dBType == DBType.TYPE_SQL_SERVER_2005) {
                properties.setProperty("subtype", SQLServerConnectionPanel.SUBTYPE_SQL_SERVER);
                properties.setProperty("RaptorConnectionType", "Microsoft SQL Server");
                properties.setProperty("customUrl", oldConnection.getUrl());
            } else if (dBType == DBType.TYPE_DB2) {
                properties.setProperty("subtype", DB2ConnectionPanel.SUBTYPE_DB2);
                properties.setProperty("RaptorConnectionType", DB2ConnectionPanel.CONNECTION_TYPE);
                properties.setProperty("dataSourceName", oldConnection.getDatabase());
            } else if (dBType == DBType.TYPE_UDB) {
                properties.setProperty("subtype", UDBConnectionPanel.SUBTYPE_UDB);
                properties.setProperty("RaptorConnectionType", UDBConnectionPanel.CONNECTION_TYPE);
                properties.setProperty("dataSourceName", oldConnection.getDatabase());
            } else if (dBType == DBType.TYPE_ODBC) {
                properties.setProperty("subtype", "JDBC");
                properties.setProperty("RaptorConnectionType", "JDBC");
                if (OldConnection.isNotEmpty(oldConnection.getJDBCAlias())) {
                    properties.setProperty("dataSourceName", oldConnection.getJDBCAlias());
                }
                properties.setProperty("customUrl", oldConnection.getUrl());
            }
            try {
                DatabaseConnections.getInstance().addConnection(string, properties);
            }
            catch (ConnectionException connectionException) {
                System.out.println(connectionException.getMessage());
            }
        }
    }
}

