/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.NamingStandardPreferences;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.options.namingstandards.WordRule;
import oracle.ide.panels.TraversableContext;

final class NamingStandardEntityPP
extends AbstractPP {
    private static final long serialVersionUID = -7477470211636757188L;
    private static final String BTN_ADD = Messages.getString("OptionsDialog.Add");
    private static final String BTN_REMOVE = Messages.getString("OptionsDialog.Remove");
    private static final String BTN_UP = Messages.getString("OptionsDialog.MoveUp");
    private static final String BTN_DOWN = Messages.getString("OptionsDialog.MoveDown");
    private static final String NAME_PART = Messages.getString("OptionsDialog.NamePart");
    private static final String MANDATORY = Messages.getString("OptionsDialog.Mandatory");
    private JTable entityTable;
    private final List entitiesList = new ArrayList();
    private JCheckBox checkBox = new JCheckBox();
    private DefaultCellEditor optionalEditor = new DefaultCellEditor(this.checkBox);
    private JPanel main;

    public NamingStandardEntityPP() {
        this.setHelpID("NAMING_STANDARD_ENTITY_PREFS_PANEL");
        this.main = new JPanel(new GridBagLayout());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.addSeparator();
        JPanel jPanel = new JPanel(new BorderLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("ADD_ICON", 16));
        jButton.setToolTipText(BTN_ADD);
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", 16));
        jButton2.setToolTipText(BTN_REMOVE);
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        jButton3.setToolTipText(BTN_UP);
        JButton jButton4 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        jButton4.setToolTipText(BTN_DOWN);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NamingStandardEntityPP.this.addToTable(NamingStandardEntityPP.this.entityTable, NamingStandardEntityPP.this.entitiesList);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NamingStandardEntityPP.this.removeFromTable(NamingStandardEntityPP.this.entityTable, NamingStandardEntityPP.this.entitiesList);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NamingStandardEntityPP.this.moveElementUp(NamingStandardEntityPP.this.entityTable, NamingStandardEntityPP.this.entitiesList);
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NamingStandardEntityPP.this.moveElementDown(NamingStandardEntityPP.this.entityTable, NamingStandardEntityPP.this.entitiesList);
            }
        });
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        jToolBar.add(jButton3);
        jToolBar.add(jButton4);
        jPanel.add(jToolBar);
        this.entityTable = new JTable(new EntityTableModel());
        JTableHeader jTableHeader = this.entityTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        TableColumn tableColumn = this.entityTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(namePartMap.values().toArray())));
        TableColumn tableColumn2 = this.entityTable.getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(this.optionalEditor);
        this.entityTable.setSelectionMode(0);
        this.main.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.main.add((Component)new JScrollPane(this.entityTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, -1));
        this.add(this.main, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
        this.getApplicationView();
        if (ApplicationView.IS_VIEWER) {
            Component[] componentArray = jToolBar.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                component.setEnabled(false);
            }
            jToolBar.validate();
            this.entityTable.setEnabled(false);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.entitiesList.clear();
        for (WordRule wordRule : settings.getNamingStandardRule().getEntitiesList()) {
            this.entitiesList.add(wordRule.copy());
        }
        this.entityTable.updateUI();
    }

    public void onExit(TraversableContext traversableContext) {
        settings.getNamingStandardRule().getEntitiesList().clear();
        settings.getNamingStandardRule().getEntitiesList().addAll(this.entitiesList);
        NamingStandardPreferences namingStandardPreferences = this.getNamingStandardPreferences(traversableContext);
        namingStandardPreferences.getNamingStandardRule().getEntitiesList().clear();
        namingStandardPreferences.getNamingStandardRule().getEntitiesList().addAll(this.entitiesList);
        namingStandardPreferences.rebuildHashStructure();
    }

    private void addToTable(JTable jTable, List list) {
        WordRule wordRule;
        int n = jTable.getSelectedRow();
        String string = "Prime Word";
        if (n > -1 && n < list.size()) {
            wordRule = (WordRule)list.get(n);
            string = wordRule.getWordType();
        }
        wordRule = new WordRule(string, false);
        list.add(wordRule);
        jTable.updateUI();
    }

    private void moveElementUp(JTable jTable, List list) {
        int n = jTable.getSelectedRow();
        if (n > 0) {
            WordRule wordRule = (WordRule)list.get(n);
            this.moveToIndex(list, wordRule, n - 1);
            jTable.changeSelection(n - 1, 0, false, false);
        }
    }

    private void moveElementDown(JTable jTable, List list) {
        int n = jTable.getSelectedRow();
        if (n > -1 && n + 1 < list.size()) {
            WordRule wordRule = (WordRule)list.get(n);
            this.moveToIndex(list, wordRule, n + 1);
            jTable.changeSelection(n + 1, 0, false, false);
            jTable.updateUI();
        }
    }

    private boolean moveToIndex(List list, WordRule wordRule, int n) {
        if (list.contains(wordRule) && list.size() > n && n >= 0) {
            list.remove(wordRule);
            list.add(n, wordRule);
            return true;
        }
        return false;
    }

    private void removeFromTable(JTable jTable, List list) {
        int n = jTable.getSelectedRow();
        if (n != -1 && list.size() > 0 && n < list.size()) {
            WordRule wordRule = (WordRule)list.get(n);
            list.remove(wordRule);
            jTable.updateUI();
        }
    }

    private NamingStandardPreferences getNamingStandardPreferences(TraversableContext traversableContext) {
        return NamingStandardPreferences.getInstance(traversableContext.getPropertyStorage());
    }

    class EntityTableModel
    extends AbstractTableModel {
        EntityTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return NamingStandardEntityPP.this.entitiesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return NAME_PART;
            }
            return MANDATORY;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            WordRule wordRule = (WordRule)NamingStandardEntityPP.this.entitiesList.get(n);
            if (n2 == 0) {
                return AbstractPP.namePartMap.get(wordRule.getWordType());
            }
            if (n2 == 1) {
                return wordRule.isMandatory();
            }
            return n * n2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n < NamingStandardEntityPP.this.entityTable.getRowCount()) {
                WordRule wordRule = (WordRule)NamingStandardEntityPP.this.entitiesList.get(n);
                if (n2 == 0) {
                    String string = "";
                    for (Map.Entry entry : AbstractPP.namePartMap.entrySet()) {
                        if (!entry.getValue().equals(object)) continue;
                        string = (String)entry.getKey();
                        break;
                    }
                    wordRule.setWordType(string);
                }
                if (n2 == 1) {
                    wordRule.setMandatory((Boolean)object);
                }
            }
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

