/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DDLMigrationPP;
import oracle.dbtools.crest.fcp.preferences.DDLMigrationPreferences;
import oracle.dbtools.crest.fcp.preferences.DDLPP;
import oracle.dbtools.crest.fcp.preferences.DDLPreferences;
import oracle.dbtools.crest.fcp.preferences.DiagramClassificationTypesPP;
import oracle.dbtools.crest.fcp.preferences.DiagramClassificationTypesPreferences;
import oracle.dbtools.crest.fcp.preferences.DiagramFormatPP;
import oracle.dbtools.crest.fcp.preferences.DiagramFormatPreferences;
import oracle.dbtools.crest.fcp.preferences.DiagramLogicalModelPP;
import oracle.dbtools.crest.fcp.preferences.DiagramLogicalModelPreferences;
import oracle.dbtools.crest.fcp.preferences.DiagramPP;
import oracle.dbtools.crest.fcp.preferences.DiagramPreferences;
import oracle.dbtools.crest.fcp.preferences.DiagramRelationalModelPP;
import oracle.dbtools.crest.fcp.preferences.DiagramRelationalModelPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelLogicalPP;
import oracle.dbtools.crest.fcp.preferences.ModelLogicalPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalDB2PP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalDB2Preferences;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalOraclePP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalOraclePreferences;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalSQLServerPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalSQLServerPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalUDBPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalUDBPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelRelationalPP;
import oracle.dbtools.crest.fcp.preferences.ModelRelationalPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelSynchronizationPhysicalOraclePP;
import oracle.dbtools.crest.fcp.preferences.ModelSynchronizationPhysicalOraclePreferences;
import oracle.dbtools.crest.fcp.preferences.ModelingPreferences;
import oracle.dbtools.crest.fcp.preferences.NamingStandardPP;
import oracle.dbtools.crest.fcp.preferences.NamingStandardPreferences;
import oracle.dbtools.crest.fcp.preferences.ThirdPartyJDBCDriversPP;
import oracle.dbtools.crest.fcp.preferences.ThirdPartyJDBCDriversPreferences;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.designrules.CustomDesignRulesPersistence;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.PropertyStorage;

final class ModelingPP
extends AbstractPP {
    private static final long serialVersionUID = -4336060296077324103L;
    private JTextField defaultPrjPath;
    private JTextField defaultImportPath;
    private JTextField defaultSavePath;
    private JTextField defaultSytemTypesPath;
    private JTextField defaultReportsPath;
    private JTextField defaultSaxonPath;
    private JCheckBox chbShowSelectRelModelDialog;
    private JCheckBox chbShowPropertiesDialogOnNew;
    private JCheckBox chbLoadDLSettingsOnOpen;
    private JCheckBox chbRestorePreviousDLSettingsOnclose;
    private JCheckBox chbImportLog;
    private JCheckBox chbReloadLastState;
    private JButton bnImport;
    private JButton bnExport;
    private StringBuffer buffer;
    private static final Logger LOGGER = new Logger(Settings.class);
    private TraversableContext cTC;
    private JPanel mainPanel;
    private static File lastImpFolder = null;
    private static File lastExpFolder = null;
    private String oldCSPath = "";
    private CustomDesignRulesPersistence designRulesPersistence;

    public ModelingPP() {
        this.setHelpID("DATA_MODELER_PREFS_PANEL");
        this.mainPanel = new JPanel(new GridBagLayout());
        this.createDefaultProjectPathOption();
        this.createImportFiles();
        this.createSaveFiles();
        this.createSystemTypes();
        this.createReports();
        this.createCbPanel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.bnImport = new JButton(this.createImportButton());
        this.bnImport.setMnemonic(73);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnExport = new JButton(this.createExportButton());
        this.bnExport.setMnemonic(69);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.addItem(jPanel, this.bnImport, 0, 1, 1, 1, 17, 0, 1);
        this.addItem(jPanel, this.bnExport, 1, 1, 1, 1, 17, 0, 1);
        this.addItem(this.mainPanel, jPanel, 0, 6, 1, 1, 17, 0, 1, 3, 0, 0, 5);
        this.add(this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.defaultPrjPath.setText(settings.getDefaultDesignsPath());
        this.defaultImportPath.setText(settings.getDefaultImportPath());
        this.defaultSavePath.setText(settings.getDefaultSavePath());
        this.defaultSytemTypesPath.setText(settings.getDefaultSystemTypesPath());
        this.defaultReportsPath.setText(settings.getDefaultReportsPath());
        this.defaultSaxonPath.setText(settings.getDefaultSaxonPath());
        this.chbShowSelectRelModelDialog.setSelected(settings.showSelectRelModelDialog());
        this.chbShowPropertiesDialogOnNew.setSelected(settings.showPropertiesDialogOnNew());
        this.chbLoadDLSettingsOnOpen.setSelected(settings.isLoadDLSettingsOnOpen());
        this.chbRestorePreviousDLSettingsOnclose.setSelected(settings.isRestorePreviousDLSettingsAfterClose());
        this.chbImportLog.setSelected(settings.showImportLog());
        this.chbReloadLastState.setSelected(settings.isReloadLastState());
        this.cTC = traversableContext;
        this.oldCSPath = settings.getDefaultSystemTypesPath();
    }

    public void onExit(TraversableContext traversableContext) {
        settings.setDefaultDesignsPath(this.defaultPrjPath.getText());
        settings.setDefaultImportPath(this.defaultImportPath.getText());
        settings.setDefaultSavePath(this.defaultSavePath.getText());
        settings.setDefaultReportsPath(this.defaultReportsPath.getText());
        settings.setDefaultSaxonPath(this.defaultSaxonPath.getText());
        settings.setDefaultSystemTypesPath(this.defaultSytemTypesPath.getText());
        settings.setShowSelectRelModelDialog(this.chbShowSelectRelModelDialog.isSelected());
        settings.setShowPropertiesDialogOnNew(this.chbShowPropertiesDialogOnNew.isSelected());
        settings.setLoadDLSettingsOnOpen(this.chbLoadDLSettingsOnOpen.isSelected());
        settings.setRestorePreviousDLSettingsAfterClose(this.chbRestorePreviousDLSettingsOnclose.isSelected());
        settings.setShowImportLog(this.chbImportLog.isSelected());
        settings.setReloadLastState(this.chbReloadLastState.isSelected());
        ModelingPreferences modelingPreferences = this.getModelingPreferences(traversableContext);
        modelingPreferences.setDefaultDesignsPath(this.defaultPrjPath.getText());
        modelingPreferences.setDefaultImportPath(this.defaultImportPath.getText());
        modelingPreferences.setDefaultSavePath(this.defaultSavePath.getText());
        modelingPreferences.setDefaultReportsPath(this.defaultReportsPath.getText());
        modelingPreferences.setDefaultSaxonPath(this.defaultSaxonPath.getText());
        modelingPreferences.setDefaultSystemTypesPath(this.defaultSytemTypesPath.getText());
        modelingPreferences.setShowSelectRelModelDialog(this.chbShowSelectRelModelDialog.isSelected());
        modelingPreferences.setShowPropertiesDialogOnNew(this.chbShowPropertiesDialogOnNew.isSelected());
        modelingPreferences.setLoadDLSettingsOnOpen(this.chbLoadDLSettingsOnOpen.isSelected());
        modelingPreferences.setRestorePreviousDLSettingsAfterClose(this.chbRestorePreviousDLSettingsOnclose.isSelected());
        modelingPreferences.setShowImportLog(this.chbImportLog.isSelected());
        modelingPreferences.setReloadLastState(this.chbReloadLastState.isSelected());
        if (!this.oldCSPath.equals(this.defaultSytemTypesPath.getText())) {
            this.getCustomDesignRulesPersistence().loadCustomDRScripts(settings);
        }
    }

    private void createDefaultProjectPathOption() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DefaultDesignsDirectory")));
        this.defaultPrjPath = new JTextField();
        JButton jButton = new JButton(Messages.getString("OptionsDialog.Select"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(1);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultPrjPath.getText()));
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (n == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultPrjPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(jPanel, this.defaultPrjPath, 0, 0, 1, 1, 17, 1, 100);
        this.addItem(jPanel, jButton, 1, 0, 1, 1, 17, 0, 100);
        this.addItem(this.mainPanel, jPanel, 0, 0, 1, 1, 17, 1, 100);
    }

    private void createImportFiles() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DefaultImportDirectory")));
        this.defaultImportPath = new JTextField();
        this.addItem(jPanel, this.defaultImportPath, 0, 1, 1, 1, 17, 1, 100);
        JButton jButton = new JButton(Messages.getString("OptionsDialog.Select"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(1);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultImportPath.getText()));
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (n == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultImportPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(jPanel, jButton, 1, 1, 1, 1, 17, 0, 100);
        this.chbImportLog = new JCheckBox(Messages.getString("OptionsDialog.ShowLogAfterImport"));
        this.addItem(jPanel, this.chbImportLog, 0, 2, 1, 1, 17, 1, 100);
        this.getApplicationView();
        if (!ApplicationView.IS_VIEWER) {
            this.addItem(this.mainPanel, jPanel, 0, 1, 1, 1, 17, 1, 100);
        }
    }

    private void createSaveFiles() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DefaultSaveDirectory")));
        this.defaultSavePath = new JTextField();
        this.addItem(jPanel, this.defaultSavePath, 0, 1, 1, 1, 17, 1, 100);
        JButton jButton = new JButton(Messages.getString("OptionsDialog.Select"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(1);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultSavePath.getText()));
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (n == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultSavePath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(jPanel, jButton, 1, 1, 1, 1, 17, 0, 100);
        this.getApplicationView();
        if (!ApplicationView.IS_VIEWER) {
            this.addItem(this.mainPanel, jPanel, 0, 2, 1, 1, 17, 1, 100);
        }
    }

    private void createSystemTypes() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.SystemTypesDirectory")));
        this.defaultSytemTypesPath = new JTextField();
        JButton jButton = new JButton(Messages.getString("OptionsDialog.Select"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(1);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultSytemTypesPath.getText()));
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (n == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultSytemTypesPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(jPanel, this.defaultSytemTypesPath, 0, 0, 1, 1, 17, 1, 1);
        this.addItem(jPanel, jButton, 1, 0, 1, 1, 17, 0, 1);
        this.addItem(this.mainPanel, jPanel, 0, 3, 1, 1, 17, 0, 1);
    }

    private void createReports() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.ReportsDirectory")));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.ReportsDirectorySaxonJarLabel")));
        this.defaultReportsPath = new JTextField();
        JButton jButton = new JButton(Messages.getString("OptionsDialog.Select"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(1);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultReportsPath.getText()));
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (n == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultReportsPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.defaultSaxonPath = new JTextField();
        JButton jButton2 = new JButton(Messages.getString("OptionsDialog.Select"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultSaxonPath.getText()));
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectSaxonJAR"));
                if (n == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultSaxonPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(jPanel2, this.defaultReportsPath, 0, 0, 1, 1, 17, 1, 1);
        this.addItem(jPanel2, jButton, 1, 0, 1, 1, 17, 0, 1);
        this.addItem(jPanel3, this.defaultSaxonPath, 0, 0, 1, 1, 17, 1, 1);
        this.addItem(jPanel3, jButton2, 1, 0, 1, 1, 17, 0, 1);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        this.addItem(this.mainPanel, jPanel, 0, 4, 1, 1, 17, 0, 1);
    }

    private void createCbPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.chbShowSelectRelModelDialog = new JCheckBox(Messages.getString("OptionsDialog.ShowSelectRelationalModelsDialog"));
        this.chbShowPropertiesDialogOnNew = new JCheckBox(Messages.getString("OptionsDialog.ShowPropertiesDialog"));
        this.chbLoadDLSettingsOnOpen = new JCheckBox(Messages.getString("OptionsDialog.LoadDLSettingsOnOpen"));
        this.chbRestorePreviousDLSettingsOnclose = new JCheckBox(Messages.getString("OptionsDialog.RestorePreviousDLSettingsOnclose"));
        this.chbReloadLastState = new JCheckBox(Messages.getString("OptionsDialog.ReloadLastState"));
        this.addItem(jPanel, this.chbShowSelectRelModelDialog, 0, 0, 1, 1, 17, 1, 1);
        this.addItem(jPanel, this.chbLoadDLSettingsOnOpen, 0, 1, 1, 1, 17, 1, 1);
        this.getApplicationView();
        if (!ApplicationView.IS_VIEWER) {
            this.addItem(jPanel, this.chbShowPropertiesDialogOnNew, 0, 2, 1, 1, 17, 1, 1);
            this.addItem(jPanel, this.chbRestorePreviousDLSettingsOnclose, 0, 3, 1, 1, 17, 1, 1);
        }
        this.addItem(jPanel, this.chbReloadLastState, 0, 4, 1, 1, 17, 1, 1);
        this.addItem(this.mainPanel, jPanel, 0, 5, 1, 1, 17, 0, 1);
    }

    public Action createImportButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("OptionsDialog.Import")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                URLFilter uRLFilter = new URLFilter(){

                    public boolean accept(URL uRL) {
                        File file = new File(uRL.getPath());
                        return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("OptionsDialog.XMLFiles");
                    }
                };
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(0);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setURLFilter(uRLFilter);
                if (lastImpFolder != null) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastImpFolder));
                } else {
                    String string = ModelingPP.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null && string.length() > 0) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        serializable = ModelingPP.this.getApplicationView().getUserHomeDirectory();
                        if (serializable != null) {
                            uRLChooser.setSelectedURL((URL)serializable);
                        }
                    }
                }
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.ImportSettings"));
                if (n == 0) {
                    try {
                        serializable = new File(uRLChooser.getSelectedURL().getPath());
                        if (((File)serializable).exists()) {
                            int n2;
                            lastImpFolder = ((File)serializable).getParentFile();
                            ModelingPP.this.buffer = new StringBuffer();
                            FileInputStream fileInputStream = new FileInputStream((File)serializable);
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            while ((n2 = ((Reader)bufferedReader).read()) > -1) {
                                ModelingPP.this.buffer.append((char)n2);
                            }
                            ((Reader)bufferedReader).close();
                            AbstractPP.settings.getNamingStandardRule().getEntitiesList().clear();
                            AbstractPP.settings.getNamingStandardRule().getAttributesList().clear();
                            AbstractPP.settings.getNamingStandardRule().getTablesList().clear();
                            AbstractPP.settings.getNamingStandardRule().getColumnsList().clear();
                            AbstractPP.settings.getNamingStandardRule().getDomainsList().clear();
                            AbstractPP.settings.getNamingStandardRule().getGlossariesList().clear();
                            AbstractPP.settings.loadSettingsFromString(ModelingPP.this.buffer.toString(), true);
                            Preferences preferences = Preferences.getPreferences();
                            ModelingPreferences modelingPreferences = ModelingPP.this.getModelingPreferences(ModelingPP.this.cTC);
                            modelingPreferences.loadFromSettings(AbstractPP.settings);
                            ModelingPP.this.onEntry(ModelingPP.this.cTC);
                            DDLPreferences dDLPreferences = DDLPreferences.getInstance((PropertyStorage)preferences);
                            dDLPreferences.loadFromSettings(AbstractPP.settings);
                            DDLPP dDLPP = new DDLPP();
                            dDLPP.onEntry(ModelingPP.this.cTC);
                            dDLPP.onExit(ModelingPP.this.cTC);
                            DDLMigrationPreferences dDLMigrationPreferences = DDLMigrationPreferences.getInstance((PropertyStorage)preferences);
                            dDLMigrationPreferences.loadFromSettings(AbstractPP.settings);
                            DDLMigrationPP dDLMigrationPP = new DDLMigrationPP();
                            dDLMigrationPP.onEntry(ModelingPP.this.cTC);
                            dDLMigrationPP.onExit(ModelingPP.this.cTC);
                            DiagramPreferences diagramPreferences = DiagramPreferences.getInstance((PropertyStorage)preferences);
                            diagramPreferences.loadFromSettings(AbstractPP.settings);
                            DiagramPP diagramPP = new DiagramPP();
                            diagramPP.onEntry(ModelingPP.this.cTC);
                            diagramPP.onExit(ModelingPP.this.cTC);
                            DiagramClassificationTypesPreferences diagramClassificationTypesPreferences = DiagramClassificationTypesPreferences.getInstance((PropertyStorage)preferences);
                            diagramClassificationTypesPreferences.loadFromSettings(AbstractPP.settings);
                            DiagramClassificationTypesPP diagramClassificationTypesPP = new DiagramClassificationTypesPP();
                            diagramClassificationTypesPP.onEntry(ModelingPP.this.cTC);
                            diagramClassificationTypesPP.onExit(ModelingPP.this.cTC);
                            DiagramFormatPreferences diagramFormatPreferences = DiagramFormatPreferences.getInstance((PropertyStorage)preferences);
                            diagramFormatPreferences.loadFromSettings(AbstractPP.settings);
                            DiagramFormatPP diagramFormatPP = new DiagramFormatPP();
                            diagramFormatPP.onEntry(ModelingPP.this.cTC);
                            diagramFormatPP.onExit(ModelingPP.this.cTC);
                            DiagramLogicalModelPreferences diagramLogicalModelPreferences = DiagramLogicalModelPreferences.getInstance((PropertyStorage)preferences);
                            diagramLogicalModelPreferences.loadFromSettings(AbstractPP.settings);
                            DiagramLogicalModelPP diagramLogicalModelPP = new DiagramLogicalModelPP();
                            diagramLogicalModelPP.onEntry(ModelingPP.this.cTC);
                            diagramLogicalModelPP.onExit(ModelingPP.this.cTC);
                            DiagramRelationalModelPreferences diagramRelationalModelPreferences = DiagramRelationalModelPreferences.getInstance((PropertyStorage)preferences);
                            diagramRelationalModelPreferences.loadFromSettings(AbstractPP.settings);
                            DiagramRelationalModelPP diagramRelationalModelPP = new DiagramRelationalModelPP();
                            diagramRelationalModelPP.onEntry(ModelingPP.this.cTC);
                            diagramRelationalModelPP.onExit(ModelingPP.this.cTC);
                            ModelPreferences modelPreferences = ModelPreferences.getInstance((PropertyStorage)preferences);
                            modelPreferences.loadFromSettings(AbstractPP.settings);
                            ModelPP modelPP = new ModelPP();
                            modelPP.onEntry(ModelingPP.this.cTC);
                            modelPP.onExit(ModelingPP.this.cTC);
                            ModelLogicalPreferences modelLogicalPreferences = ModelLogicalPreferences.getInstance((PropertyStorage)preferences);
                            modelLogicalPreferences.loadFromSettings(AbstractPP.settings);
                            ModelLogicalPP modelLogicalPP = new ModelLogicalPP();
                            modelLogicalPP.onEntry(ModelingPP.this.cTC);
                            modelLogicalPP.onExit(ModelingPP.this.cTC);
                            ModelPhysicalOraclePreferences modelPhysicalOraclePreferences = ModelPhysicalOraclePreferences.getInstance((PropertyStorage)preferences);
                            modelPhysicalOraclePreferences.loadFromSettings(AbstractPP.settings);
                            ModelPhysicalOraclePP modelPhysicalOraclePP = new ModelPhysicalOraclePP();
                            modelPhysicalOraclePP.onEntry(ModelingPP.this.cTC);
                            modelPhysicalOraclePP.onExit(ModelingPP.this.cTC);
                            ModelPhysicalDB2Preferences modelPhysicalDB2Preferences = ModelPhysicalDB2Preferences.getInstance((PropertyStorage)preferences);
                            modelPhysicalDB2Preferences.loadFromSettings(AbstractPP.settings);
                            ModelPhysicalDB2PP modelPhysicalDB2PP = new ModelPhysicalDB2PP();
                            modelPhysicalDB2PP.onEntry(ModelingPP.this.cTC);
                            modelPhysicalDB2PP.onExit(ModelingPP.this.cTC);
                            ModelPhysicalSQLServerPreferences modelPhysicalSQLServerPreferences = ModelPhysicalSQLServerPreferences.getInstance((PropertyStorage)preferences);
                            modelPhysicalSQLServerPreferences.loadFromSettings(AbstractPP.settings);
                            ModelPhysicalSQLServerPP modelPhysicalSQLServerPP = new ModelPhysicalSQLServerPP();
                            modelPhysicalSQLServerPP.onEntry(ModelingPP.this.cTC);
                            modelPhysicalSQLServerPP.onExit(ModelingPP.this.cTC);
                            ModelPhysicalUDBPreferences modelPhysicalUDBPreferences = ModelPhysicalUDBPreferences.getInstance((PropertyStorage)preferences);
                            modelPhysicalUDBPreferences.loadFromSettings(AbstractPP.settings);
                            ModelPhysicalUDBPP modelPhysicalUDBPP = new ModelPhysicalUDBPP();
                            modelPhysicalUDBPP.onEntry(ModelingPP.this.cTC);
                            modelPhysicalUDBPP.onExit(ModelingPP.this.cTC);
                            ModelRelationalPreferences modelRelationalPreferences = ModelRelationalPreferences.getInstance((PropertyStorage)preferences);
                            modelRelationalPreferences.loadFromSettings(AbstractPP.settings);
                            ModelRelationalPP modelRelationalPP = new ModelRelationalPP();
                            modelRelationalPP.onEntry(ModelingPP.this.cTC);
                            modelRelationalPP.onExit(ModelingPP.this.cTC);
                            NamingStandardPreferences namingStandardPreferences = NamingStandardPreferences.getInstance((PropertyStorage)preferences);
                            namingStandardPreferences.loadFromSettings(AbstractPP.settings);
                            NamingStandardPP namingStandardPP = new NamingStandardPP();
                            namingStandardPP.onEntry(ModelingPP.this.cTC);
                            namingStandardPP.onExit(ModelingPP.this.cTC);
                            ThirdPartyJDBCDriversPreferences thirdPartyJDBCDriversPreferences = ThirdPartyJDBCDriversPreferences.getInstance((PropertyStorage)preferences);
                            thirdPartyJDBCDriversPreferences.loadFromSettings(AbstractPP.settings);
                            ThirdPartyJDBCDriversPP thirdPartyJDBCDriversPP = new ThirdPartyJDBCDriversPP();
                            thirdPartyJDBCDriversPP.onEntry(ModelingPP.this.cTC);
                            thirdPartyJDBCDriversPP.onExit(ModelingPP.this.cTC);
                            ModelSynchronizationPhysicalOraclePreferences modelSynchronizationPhysicalOraclePreferences = ModelSynchronizationPhysicalOraclePreferences.getInstance((PropertyStorage)preferences);
                            modelSynchronizationPhysicalOraclePreferences.loadFromSettings(AbstractPP.settings);
                            ModelSynchronizationPhysicalOraclePP modelSynchronizationPhysicalOraclePP = new ModelSynchronizationPhysicalOraclePP();
                            modelSynchronizationPhysicalOraclePP.onEntry(ModelingPP.this.cTC);
                            modelSynchronizationPhysicalOraclePP.onExit(ModelingPP.this.cTC);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to initialize settings from imported file: ", exception);
                    }
                }
            }
        };
        return abstractAction;
    }

    public Action createExportButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("OptionsDialog.Export")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                URLFilter uRLFilter = new URLFilter(){

                    public boolean accept(URL uRL) {
                        File file = new File(uRL.getPath());
                        return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("OptionsDialog.XMLFiles");
                    }
                };
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(0);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setURLFilter(uRLFilter);
                if (lastExpFolder != null) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
                } else {
                    String string = ModelingPP.this.getApplicationView().getSettings().getDefaultSavePath();
                    if (string != null && string.length() > 0) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        serializable = ModelingPP.this.getApplicationView().getUserHomeDirectory();
                        if (serializable != null) {
                            uRLChooser.setSelectedURL((URL)serializable);
                        }
                    }
                }
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.ExportSettings"));
                if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                    lastExpFolder = ((File)serializable).getParentFile();
                    AbstractPP.settings.setSettingsFileName(((File)serializable).toString());
                    AbstractPP.settings.saveSettings();
                    AbstractPP.settings.setSettingsFileName("settings.xml");
                }
            }
        };
        return abstractAction;
    }

    private ModelingPreferences getModelingPreferences(TraversableContext traversableContext) {
        return ModelingPreferences.getInstance(traversableContext.getPropertyStorage());
    }

    private CustomDesignRulesPersistence getCustomDesignRulesPersistence() {
        if (this.designRulesPersistence == null) {
            this.designRulesPersistence = new CustomDesignRulesPersistence(this.getApplicationView());
        }
        return this.designRulesPersistence;
    }
}

