/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelSynchronizationPhysicalOraclePreferences;
import oracle.dbtools.crest.imports.SyncObject;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

final class ModelSynchronizationPhysicalOraclePP
extends AbstractPP {
    private static final String DIALOG_NAME = Messages.getString("OptionsDialog.NameElementProvider");
    private JTable itemsTable;
    private List itemsList = new ArrayList();
    private JPanel main;

    public ModelSynchronizationPhysicalOraclePP() {
        this.setHelpID("MODEL_SYNC_PHYSICAL_ORACLE");
        this.main = new JPanel(new GridBagLayout());
        this.itemsTable = new JTable(new ItemsTableModel());
        JTableHeader jTableHeader = this.itemsTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        TableColumn tableColumn = this.itemsTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        tableColumn.setPreferredWidth(150);
        tableColumn.setMaxWidth(150);
        this.itemsTable.setSelectionMode(0);
        this.main.add((Component)new JScrollPane(this.itemsTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, -1));
        this.add(this.main, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.itemsList.clear();
        for (SyncObject syncObject : settings.getSyncObjects()) {
            if (!syncObject.getDatabase().equals("Oracle")) continue;
            this.itemsList.add(syncObject);
        }
        this.itemsTable.updateUI();
    }

    public void onExit(TraversableContext traversableContext) {
        Object object2;
        for (Object object2 : this.itemsList) {
            SyncObject syncObject = settings.getSyncObject(((SyncObject)object2).getType(), ((SyncObject)object2).getDatabase());
            if (syncObject == null) continue;
            syncObject.setUsed(((SyncObject)object2).isUsed());
        }
        object2 = this.getModelSynchronizationPhysicalOraclePreferences(traversableContext);
        ((ModelSynchronizationPhysicalOraclePreferences)((Object)object2)).rebuildHashStructure(settings);
    }

    @Override
    protected String getDialogName() {
        return DIALOG_NAME;
    }

    private ModelSynchronizationPhysicalOraclePreferences getModelSynchronizationPhysicalOraclePreferences(TraversableContext traversableContext) {
        return ModelSynchronizationPhysicalOraclePreferences.getInstance(traversableContext.getPropertyStorage());
    }

    class ItemsTableModel
    extends AbstractTableModel {
        ItemsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ModelSynchronizationPhysicalOraclePP.this.itemsList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Type";
            }
            return "Synchronize";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SyncObject syncObject = (SyncObject)ModelSynchronizationPhysicalOraclePP.this.itemsList.get(n);
            if (n2 == 0) {
                return syncObject.getType();
            }
            if (n2 == 1) {
                return syncObject.isUsed();
            }
            return n * n2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SyncObject syncObject = (SyncObject)ModelSynchronizationPhysicalOraclePP.this.itemsList.get(n);
            if (n2 == 1) {
                syncObject.setUsed((Boolean)object);
            }
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }
    }
}

