/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplate;
import oracle.dbtools.crest.util.options.oracle.OracleTableTemplate;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelPhysicalOraclePreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelPhysicalOraclePP";
    private static final String DU = "oracle_user";
    private static final String DT = "oracle_tablespace";
    private static final String UTT = "use_oracle_table_template";
    private static final String UIT = "use_oracle_index_template";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelPhysicalOraclePreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static ModelPhysicalOraclePreferences getInstance(PropertyStorage propertyStorage) {
        return new ModelPhysicalOraclePreferences(ModelPhysicalOraclePreferences.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public String getDefaultOracleUser() {
        return this._hash.getString(DU);
    }

    public void setDefaultOracleUser(String string) {
        this._hash.putString(DU, string);
    }

    public String getDefaultOracleTablespace() {
        return this._hash.getString(DT);
    }

    public void setDefaultOracleTablespace(String string) {
        this._hash.putString(DT, string);
    }

    public boolean getUseOracleTableTemplate() {
        return this._hash.getBoolean(UTT);
    }

    public void setUseOracleTableTemplate(boolean bl) {
        this._hash.putBoolean(UTT, bl);
    }

    public boolean getUseOracleIndexTemplate() {
        return this._hash.getBoolean(UIT);
    }

    public void setUseOracleIndexTemplate(boolean bl) {
        this._hash.putBoolean(UIT, bl);
    }

    public String getDefaultOracleTriggerName() {
        return this._hash.getString("oracle_trigger_name");
    }

    public void setDefaultOracleTriggerName(String string) {
        this._hash.putString("oracle_trigger_name", string);
    }

    public String getDefaultOracleSequenceName() {
        return this._hash.getString("oracle_sequence_name");
    }

    public void setDefaultOracleSequenceName(String string) {
        this._hash.putString("oracle_sequence_name", string);
    }

    public void setTableTemplate(OracleTableTemplate oracleTableTemplate) {
        HashStructure hashStructure = HashStructure.newInstance();
        hashStructure.putString("ott_temporary", oracleTableTemplate.getTemporary());
        hashStructure.putString("ott_preserve_rows", oracleTableTemplate.getPreserveRows());
        hashStructure.putString("ott_tableSpace", oracleTableTemplate.getTableSpace());
        hashStructure.putString("ott_organization", oracleTableTemplate.getOrganization());
        hashStructure.putString("ott_logging", oracleTableTemplate.getLogging());
        hashStructure.putString("ott_segment", oracleTableTemplate.getSegment());
        hashStructure.putString("ott_cache", oracleTableTemplate.getCache());
        hashStructure.putString("ott_monitoring", oracleTableTemplate.getMonitoring());
        hashStructure.putString("ott_parallel", oracleTableTemplate.getParallel());
        hashStructure.putString("ott_degree", oracleTableTemplate.getDegree());
        hashStructure.putString("ott_partitioned", oracleTableTemplate.getPartitioned());
        hashStructure.putString("ott_row_movement", oracleTableTemplate.getRowMovement());
        hashStructure.putString("ott_data_compression", oracleTableTemplate.getDataCompression());
        this._hash.putHashStructure("oracle_table_template", hashStructure);
    }

    public void setIndexTemplate(OracleIndexTemplate oracleIndexTemplate) {
        HashStructure hashStructure = HashStructure.newInstance();
        hashStructure.putString("oit_bitmap_index", String.valueOf(oracleIndexTemplate.isBitmapIndex()));
        hashStructure.putString("oit_partitioned", oracleIndexTemplate.getPartitioned());
        hashStructure.putString("oit_tablespace", oracleIndexTemplate.getTableSpace());
        hashStructure.putString("oit_logging", oracleIndexTemplate.getLogging());
        hashStructure.putString("oit_segment", oracleIndexTemplate.getSegment());
        hashStructure.putString("oit_compress", String.valueOf(oracleIndexTemplate.getCompress()));
        hashStructure.putString("oit_parallel", oracleIndexTemplate.getParallel());
        hashStructure.putString("oit_degree", oracleIndexTemplate.getDegree());
        hashStructure.putString("oit_sorted_rows", oracleIndexTemplate.getSortedRows());
        hashStructure.putString("oit_compute_stats", oracleIndexTemplate.getComputeStatistics());
        hashStructure.putString("oit_online", oracleIndexTemplate.getOnline());
        this._hash.putHashStructure("oracle_index_template", hashStructure);
    }

    private boolean contains(String string) {
        return this._hash.containsKey(string);
    }

    public void loadToSettings(Settings settings) {
        OracleTableTemplate oracleTableTemplate;
        HashStructure hashStructure;
        if (this.contains(DU)) {
            settings.setDefaultOracleUser(this.getDefaultOracleUser());
        }
        if (this.contains(DT)) {
            settings.setDefaultOracleTablespace(this.getDefaultOracleTablespace());
        }
        if (this.contains(UTT)) {
            settings.setUseOracleTableTemplate(this.getUseOracleTableTemplate());
        }
        if (this.contains(UIT)) {
            settings.setUseOracleIndexTemplate(this.getUseOracleIndexTemplate());
        }
        if (this.contains("oracle_trigger_name")) {
            settings.setDefaultOracleTriggerName(this.getDefaultOracleTriggerName());
        }
        if (this.contains("oracle_sequence_name")) {
            settings.setDefaultOracleSequenceName(this.getDefaultOracleSequenceName());
        }
        if ((hashStructure = this._hash.getHashStructure("oracle_table_template")) != null) {
            oracleTableTemplate = settings.getOracleTableTemplate();
            oracleTableTemplate.setTemporary(hashStructure.getString("ott_temporary"));
            oracleTableTemplate.setPreserveRows(hashStructure.getString("ott_preserve_rows"));
            oracleTableTemplate.setTableSpace(hashStructure.getString("ott_tableSpace"));
            oracleTableTemplate.setOrganization(hashStructure.getString("ott_organization"));
            oracleTableTemplate.setLogging(hashStructure.getString("ott_logging"));
            oracleTableTemplate.setSegment(hashStructure.getString("ott_segment"));
            oracleTableTemplate.setCache(hashStructure.getString("ott_cache"));
            oracleTableTemplate.setMonitoring(hashStructure.getString("ott_monitoring"));
            oracleTableTemplate.setParallel(hashStructure.getString("ott_parallel"));
            oracleTableTemplate.setDegree(hashStructure.getString("ott_degree"));
            oracleTableTemplate.setPartitioned(hashStructure.getString("ott_partitioned"));
            oracleTableTemplate.setRowMovement(hashStructure.getString("ott_row_movement"));
            oracleTableTemplate.setDataCompression(hashStructure.getString("ott_data_compression"));
        }
        if ((oracleTableTemplate = this._hash.getHashStructure("oracle_index_template")) != null) {
            OracleIndexTemplate oracleIndexTemplate = settings.getOracleIndexTemplate();
            oracleIndexTemplate.setBitmapIndex(Boolean.valueOf(oracleTableTemplate.getString("oit_bitmap_index")));
            oracleIndexTemplate.setPartitioned(oracleTableTemplate.getString("oit_partitioned"));
            oracleIndexTemplate.setTableSpace(oracleTableTemplate.getString("oit_tablespace"));
            oracleIndexTemplate.setLogging(oracleTableTemplate.getString("oit_logging"));
            oracleIndexTemplate.setSegment(oracleTableTemplate.getString("oit_segment"));
            oracleIndexTemplate.setCompress(Integer.parseInt(oracleTableTemplate.getString("oit_compress")));
            oracleIndexTemplate.setParallel(oracleTableTemplate.getString("oit_parallel"));
            oracleIndexTemplate.setDegree(oracleTableTemplate.getString("oit_degree"));
            oracleIndexTemplate.setSortedRows(oracleTableTemplate.getString("oit_sorted_rows"));
            oracleIndexTemplate.setComputeStatistics(oracleTableTemplate.getString("oit_compute_stats"));
            oracleIndexTemplate.setOnline(oracleTableTemplate.getString("oit_online"));
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setDefaultOracleTablespace(settings.getDefaultOracleTablespace());
        this.setDefaultOracleUser(settings.getDefaultOracleUser());
        this.setUseOracleIndexTemplate(settings.useOracleIndexTemplate());
        this.setUseOracleTableTemplate(settings.useOracleTableTemplate());
        this.setDefaultOracleTriggerName(settings.getDefaultOracleTriggerName());
        this.setDefaultOracleSequenceName(settings.getDefaultOracleSequenceName());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

