/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class DialogPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_DialogSettings";
    private static final String DIALOGS_SETTINGS = "dialogs_settings";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected DialogPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static DialogPreferences getInstance(PropertyStorage propertyStorage) {
        return new DialogPreferences(DialogPreferences.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public void setDialogSettings(Map map) {
        HashStructure hashStructure = HashStructure.newInstance();
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            Rectangle rectangle = (Rectangle)map.get(string);
            HashStructure hashStructure2 = HashStructure.newInstance();
            hashStructure2.putString("x", String.valueOf(rectangle.getX()));
            hashStructure2.putString("y", String.valueOf(rectangle.getY()));
            hashStructure2.putString("w", String.valueOf(rectangle.getWidth()));
            hashStructure2.putString("h", String.valueOf(rectangle.getHeight()));
            hashStructure.putHashStructure(string, hashStructure2);
        }
        this._hash.putHashStructure(DIALOGS_SETTINGS, hashStructure);
    }

    public HashStructure getDialogSettings() {
        return this._hash.getHashStructure(DIALOGS_SETTINGS);
    }

    private boolean contains(String string) {
        return this._hash.containsKey(string);
    }

    public void loadToSettings(Settings settings) {
        HashStructure hashStructure = this._hash.getHashStructure(DIALOGS_SETTINGS);
        if (hashStructure != null) {
            Set set = hashStructure.keySet();
            for (String string : set) {
                HashStructure hashStructure2 = hashStructure.getHashStructure(string);
                double d = Double.parseDouble(hashStructure2.getString("x"));
                double d2 = Double.parseDouble(hashStructure2.getString("y"));
                double d3 = Double.parseDouble(hashStructure2.getString("w"));
                double d4 = Double.parseDouble(hashStructure2.getString("h"));
                settings.getDialogs().put(string, settings.fixScreenLocation((int)d, (int)d2, (int)d3, (int)d4));
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

