/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class DiagramPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_DiagramPP";
    private static final String ST = "synchronize_tree";
    private static final String GS = "grid_size";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected DiagramPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static DiagramPreferences getInstance(PropertyStorage propertyStorage) {
        return new DiagramPreferences(DiagramPreferences.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public boolean isSynchronizeWithTree() {
        return this._hash.getBoolean(ST);
    }

    public void setSynchronizeWithTree(boolean bl) {
        this._hash.putBoolean(ST, bl);
    }

    public int getGridSize() {
        return this._hash.getInt(GS);
    }

    public void setGridSize(int n) {
        this._hash.putInt(GS, n);
    }

    private boolean contains(String string) {
        return this._hash.containsKey(string);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(ST)) {
            settings.setSynchronizeTree(this.isSynchronizeWithTree());
        }
        if (this.contains(GS)) {
            settings.setGridSize(this.getGridSize());
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setSynchronizeWithTree(settings.synchronizeTree());
        this.setGridSize(settings.getGridSize());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

