/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DiagramPreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.ide.panels.TraversableContext;

final class DiagramPP
extends AbstractPP {
    private static final long serialVersionUID = -6009897543848041925L;
    private JCheckBox chbSynchronizeTree;
    private JIntegerField ifGridSize;

    public DiagramPP() {
        this.setHelpID("DIAGRAM_PREFS_PANEL");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.General")));
        this.addItem(jPanel, new JLabel(""), 2, 0, 1, 1, 17, 1, 100);
        this.chbSynchronizeTree = new JCheckBox(Messages.getString("OptionsDialog.SynchronizeWithTree"));
        this.addItem(jPanel, this.chbSynchronizeTree, 1, 0, 1, 1, 17, 0, 100);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(Messages.getString("OptionsDialog.GridSize"));
        this.addItem(jPanel2, jLabel, 1, 0, 1, 1, 17, 0, 100);
        this.ifGridSize = new JIntegerField();
        this.ifGridSize.setPreferredSize(new Dimension(40, 20));
        this.addItem(jPanel2, this.ifGridSize, 2, 0, 1, 20, 17, 0, 100);
        this.addItem(jPanel, jPanel2, 1, 1, 1, 20, 17, 0, 100);
        this.getApplicationView();
        this.add(jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.chbSynchronizeTree.setSelected(settings.synchronizeTree());
        this.ifGridSize.setValue((long)settings.getGridSize());
    }

    public void onExit(TraversableContext traversableContext) {
        settings.setSynchronizeTree(this.chbSynchronizeTree.isSelected());
        int n = this.ifGridSize.getIntValue();
        if (n <= 0) {
            n = 10;
        }
        settings.setGridSize(n);
        DiagramPreferences diagramPreferences = this.getDiagramPreferences(traversableContext);
        diagramPreferences.setSynchronizeWithTree(this.chbSynchronizeTree.isSelected());
        diagramPreferences.setGridSize(n);
    }

    private DiagramPreferences getDiagramPreferences(TraversableContext traversableContext) {
        return DiagramPreferences.getInstance(traversableContext.getPropertyStorage());
    }
}

