/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DiagramLogicalModelPreferences;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

final class DiagramLogicalModelPP
extends AbstractPP {
    private static final long serialVersionUID = 2634829318573257787L;
    private JComboBox cbNotation;
    private static final String BACHMAN_IMAGE = "BACHMAN_IMAGE";
    private static final String BARKER_IMAGE = "BARKER_IMAGE";
    private final CardLayout clNotation = new CardLayout();
    private JCheckBox chbBoxInBox;
    private JComboBox cbDomainPresentation;
    private final String USE_DOMAN_NAME = Messages.getString("OptionsDialog.DomainName");
    private final String USE_LOGICAL_TYPE = Messages.getString("OptionsDialog.UsedLogicalType");
    private final String[] domain_presentation = new String[]{this.USE_DOMAN_NAME, this.USE_LOGICAL_TYPE};
    private JPanel mainPanel;

    public DiagramLogicalModelPP() {
        this.setHelpID("DIAGRAM_LOGICAL_MODEL_PREFS_PANEL");
        this.mainPanel = new JPanel(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.NotationType")));
        this.cbNotation = new JComboBox<Object>(Diagram.getNotations());
        this.cbNotation.setPreferredSize(new Dimension(160, 20));
        this.addItem(jPanel2, this.cbNotation, 0, 0, 1, 1, 17, 100, 100);
        ImageIcon imageIcon = (ImageIcon)GUIConfiguration.getInstance().getIcon("NOTATION_BACHMAN");
        JLabel jLabel = new JLabel(imageIcon, 0);
        ImageIcon imageIcon2 = (ImageIcon)GUIConfiguration.getInstance().getIcon("NOTATION_BARKER");
        JLabel jLabel2 = new JLabel(imageIcon2, 0);
        final JPanel jPanel3 = new JPanel(this.clNotation);
        jPanel3.add((Component)jLabel, BACHMAN_IMAGE);
        jPanel3.add((Component)jLabel2, BARKER_IMAGE);
        this.addItem(jPanel2, jPanel3, 1, 0, 1, 1, 17, 100, 100);
        this.addItem(jPanel, jPanel2, 0, 0, 1, 1, 17, 100, 100);
        this.addItem(this.mainPanel, jPanel, 0, 0, 1, 1, 17, 1, 100);
        this.cbNotation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (DiagramLogicalModelPP.this.cbNotation.getSelectedIndex()) {
                    case 0: {
                        DiagramLogicalModelPP.this.clNotation.show(jPanel3, DiagramLogicalModelPP.BACHMAN_IMAGE);
                        break;
                    }
                    case 1: {
                        DiagramLogicalModelPP.this.clNotation.show(jPanel3, DiagramLogicalModelPP.BARKER_IMAGE);
                        break;
                    }
                    default: {
                        DiagramLogicalModelPP.this.clNotation.show(jPanel3, DiagramLogicalModelPP.BACHMAN_IMAGE);
                    }
                }
            }
        });
        jPanel2 = new JPanel(new GridBagLayout());
        this.chbBoxInBox = new JCheckBox(Messages.getString("OptionsDialog.BoxInBoxPresentation"));
        this.addItem(jPanel2, this.chbBoxInBox, 0, 1, 1, 1, 17, 100, 100);
        this.addItem(this.mainPanel, jPanel2, 0, 1, 1, 1, 17, 100, 100);
        jPanel2 = new JPanel(new FlowLayout(0));
        JLabel jLabel3 = new JLabel(Messages.getString("OptionsDialog.DomainsPresentation"));
        this.cbDomainPresentation = new JComboBox<String>(new DefaultComboBoxModel<String>(this.domain_presentation));
        this.getApplicationView();
        if (ApplicationView.IS_VIEWER && !this.getApplicationView().getCurrentDesign().isNewDesign()) {
            this.cbDomainPresentation.setEnabled(false);
        } else {
            this.cbDomainPresentation.setEnabled(true);
        }
        this.addItem(jPanel2, jLabel3, 0, 0, 1, 1, 17, 1, 1);
        this.addItem(jPanel2, this.cbDomainPresentation, 1, 0, 1, 1, 17, 1, 1);
        this.addItem(this.mainPanel, jPanel2, 0, 2, 1, 1, 17, 1, 100);
        this.add(this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.chbBoxInBox.setSelected(settings.isBoxInBox());
        this.cbNotation.setSelectedIndex(settings.getNotation());
        if (settings.isLogicalTypeForDomainPresentation()) {
            this.cbDomainPresentation.setSelectedItem(this.USE_LOGICAL_TYPE);
        } else {
            this.cbDomainPresentation.setSelectedItem(this.USE_DOMAN_NAME);
        }
    }

    public void onExit(TraversableContext traversableContext) {
        settings.setBoxInBox(this.chbBoxInBox.isSelected());
        settings.setNotation(this.cbNotation.getSelectedIndex());
        this.getApplicationView();
        if (!ApplicationView.IS_VIEWER && !this.getApplicationView().getCurrentDesign().isNewDesign()) {
            settings.setLogicalTypeForDomainPresentation(this.cbDomainPresentation.getSelectedItem() == this.USE_LOGICAL_TYPE);
        }
        DiagramLogicalModelPreferences diagramLogicalModelPreferences = this.getDiagramLogicalModelPreferences(traversableContext);
        diagramLogicalModelPreferences.setBoxInBox(this.chbBoxInBox.isSelected());
        diagramLogicalModelPreferences.setNotation(this.cbNotation.getSelectedIndex());
        if (this.getCurrentDesign().getName().equals("Untitled_1") && this.getApplicationView().getDesigns().size() == 1) {
            this.getApplicationView();
            if (!ApplicationView.IS_VIEWER) {
                diagramLogicalModelPreferences.setLogicalTypeForDomainPresentation(this.cbDomainPresentation.getSelectedItem() == this.USE_LOGICAL_TYPE);
            }
        }
    }

    private DiagramLogicalModelPreferences getDiagramLogicalModelPreferences(TraversableContext traversableContext) {
        return DiagramLogicalModelPreferences.getInstance(traversableContext.getPropertyStorage());
    }
}

