/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DiagramFormatPreferences;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.ColorChooserDialog;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.TopViewColorDialog;
import oracle.dbtools.crest.util.gui.swing.JLWComboBox;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.format.DefaultLineWidthAndColor;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.TraversableContext;

final class DiagramFormatPP
extends AbstractPP {
    private static final long serialVersionUID = 1956410953457357656L;
    private List defaultFCList;
    private List defaultLWCList;
    private JTable tbDefaultFC;
    private JTable tbDefaultLWC;

    public DiagramFormatPP() {
        this.setHelpID("DIAGRAM_FORMAT_PREFS_PANEL");
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.createDefaultFCPanel(jTabbedPane);
        this.createDefaultLineFCPanel(jTabbedPane);
        this.add(jTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.defaultFCList.clear();
        for (Object object : settings.getDefaultFCObjects()) {
            this.defaultFCList.add(((DefaultFontAndColor)object).copy());
        }
        this.tbDefaultFC.updateUI();
        this.defaultLWCList.clear();
        for (Object object : settings.getDefaultLWCObjects()) {
            this.defaultLWCList.add(((DefaultLineWidthAndColor)object).copy());
        }
        this.tbDefaultLWC.updateUI();
    }

    public void onExit(TraversableContext traversableContext) {
        settings.getDefaultFCObjects().clear();
        for (Object object : this.defaultFCList) {
            settings.getDefaultFCObjects().add(object);
        }
        settings.getDefaultLWCObjects().clear();
        for (Object object : this.defaultLWCList) {
            settings.getDefaultLWCObjects().add(object);
        }
        if (this.getCurrentDesign().getName().equals("Untitled_1") && this.getApplicationView().getDesigns().size() == 1) {
            Object object;
            object = this.getDiagramFormatPreferences(traversableContext);
            ((DiagramFormatPreferences)((Object)object)).setDefaultFCObjects(this.defaultFCList);
            ((DiagramFormatPreferences)((Object)object)).setDefaultLWCObjects(this.defaultLWCList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(ApplyEvent applyEvent) {
        try {
            this.getCurrentDesign().setDlSettings(settings.saveSettingsToString());
        }
        finally {
            DefaultFontAndColor.clearModified();
        }
    }

    private void createDefaultFCPanel(JTabbedPane jTabbedPane) {
        this.defaultFCList = new ArrayList();
        this.tbDefaultFC = new JTable(new DefaultFCModel());
        this.tbDefaultFC.setSelectionMode(0);
        FontsAndColorsCellRenderer fontsAndColorsCellRenderer = new FontsAndColorsCellRenderer();
        TableColumn tableColumn = this.tbDefaultFC.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(fontsAndColorsCellRenderer);
        tableColumn = this.tbDefaultFC.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(fontsAndColorsCellRenderer);
        this.tbDefaultFC.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = DiagramFormatPP.this.tbDefaultFC.getSelectedRow()) != -1 && DiagramFormatPP.this.defaultFCList.size() > 0 && n < DiagramFormatPP.this.defaultFCList.size()) {
                    DefaultFontAndColor defaultFontAndColor = (DefaultFontAndColor)DiagramFormatPP.this.defaultFCList.get(n);
                    new TopViewColorDialog(defaultFontAndColor).setVisible(true);
                    DiagramFormatPP.this.tbDefaultFC.updateUI();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tbDefaultFC);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(Messages.getString("OptionsDialog.Modify"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DiagramFormatPP.this.tbDefaultFC.getSelectedRow();
                if (n != -1 && DiagramFormatPP.this.defaultFCList.size() > 0 && n < DiagramFormatPP.this.defaultFCList.size()) {
                    DefaultFontAndColor defaultFontAndColor = (DefaultFontAndColor)DiagramFormatPP.this.defaultFCList.get(n);
                    new TopViewColorDialog(defaultFontAndColor).setVisible(true);
                    DiagramFormatPP.this.tbDefaultFC.updateUI();
                }
            }
        });
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jPanel.add(jToolBar);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        jTabbedPane.add(Messages.getString("OptionsDialog.DefaultObjectFontsAndColors"), jPanel2);
    }

    private void createDefaultLineFCPanel(JTabbedPane jTabbedPane) {
        this.defaultLWCList = new ArrayList();
        this.tbDefaultLWC = new JTable(new DefaultLWCModel());
        this.tbDefaultLWC.setSelectionMode(0);
        TableColumn tableColumn = this.tbDefaultLWC.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new LineColorCellRenderer());
        tableColumn.setCellEditor(new ColorEditor());
        TableColumn tableColumn2 = this.tbDefaultLWC.getColumnModel().getColumn(2);
        tableColumn2.setCellRenderer(new LineWidthCellRenderer());
        tableColumn2.setCellEditor(new LWCCellEditor());
        tableColumn2.setMinWidth(130);
        tableColumn2.setMaxWidth(130);
        JScrollPane jScrollPane = new JScrollPane(this.tbDefaultLWC);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        jTabbedPane.add(Messages.getString("OptionsDialog.DefaultLineWidthsAndColors"), jPanel);
    }

    private DiagramFormatPreferences getDiagramFormatPreferences(TraversableContext traversableContext) {
        return DiagramFormatPreferences.getInstance(traversableContext.getPropertyStorage());
    }

    static class LWCCellEditor
    extends DefaultCellEditor {
        JLWComboBox cbox = (JLWComboBox)this.getComponent();

        LWCCellEditor() {
            super(new JLWComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cbox.setModel(new DefaultComboBoxModel<Object>(JLWComboBox.getItems().toArray()));
            DefaultLineWidthAndColor defaultLineWidthAndColor = (DefaultLineWidthAndColor)object;
            switch (defaultLineWidthAndColor.getWidth()) {
                case 1: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_1);
                    break;
                }
                case 2: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_2);
                    break;
                }
                case 3: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_3);
                    break;
                }
                case 4: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_4);
                    break;
                }
                case 5: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_5);
                    break;
                }
                case 6: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_6);
                }
            }
            return this.cbox;
        }
    }

    public class DefaultFCModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return DiagramFormatPP.this.defaultFCList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("OptionsDialog.DesignObject");
            }
            if (n == 1) {
                return Messages.getString("OptionsDialog.Background");
            }
            if (n == 2) {
                return Messages.getString("OptionsDialog.Foreground");
            }
            if (n == 3) {
                return Messages.getString("OptionsDialog.TitleFont");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DefaultFontAndColor defaultFontAndColor = (DefaultFontAndColor)DiagramFormatPP.this.defaultFCList.get(n);
            if (n2 == 0) {
                return defaultFontAndColor.getClassName();
            }
            if (n2 == 1 || n2 == 2) {
                return defaultFontAndColor;
            }
            if (n2 == 3) {
                return ((FontObject)defaultFontAndColor.getEditableFonts().get(0)).getFont().getName();
            }
            return n * n2;
        }
    }

    public static class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color currentColor;
        JButton button = new JButton();
        protected static final String EDIT = "edit";

        public ColorEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.button.setBackground(this.currentColor);
                ColorChooserDialog colorChooserDialog = new ColorChooserDialog(null, Messages.getString("OptionsDialog.PickColor"), this.currentColor);
                Color color = colorChooserDialog.showDialog();
                if (color != null) {
                    this.currentColor = color;
                }
                this.fireEditingStopped();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentColor = ((DefaultLineWidthAndColor)object).getColor();
            return this.button;
        }
    }

    public class DefaultLWCModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DiagramFormatPP.this.defaultLWCList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("OptionsDialog.DesignObject");
            }
            if (n == 1) {
                return Messages.getString("OptionsDialog.Color");
            }
            if (n == 2) {
                return Messages.getString("OptionsDialog.Width");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DefaultLineWidthAndColor defaultLineWidthAndColor = (DefaultLineWidthAndColor)DiagramFormatPP.this.defaultLWCList.get(n);
            if (n2 == 0) {
                return defaultLineWidthAndColor.getClassName();
            }
            if (n2 == 1 || n2 == 2) {
                return defaultLineWidthAndColor;
            }
            return n * n2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            DefaultLineWidthAndColor defaultLineWidthAndColor = (DefaultLineWidthAndColor)DiagramFormatPP.this.defaultLWCList.get(n);
            if (n2 == 1) {
                defaultLineWidthAndColor.setColor((Color)object);
            } else if (n2 == 2) {
                defaultLineWidthAndColor.setWidth(JLWComboBox.IndexOf(object) + 1);
            }
        }
    }

    static class LineWidthCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LineWidthCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DefaultLineWidthAndColor defaultLineWidthAndColor = (DefaultLineWidthAndColor)object;
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setBackground(Color.WHITE);
            switch (defaultLineWidthAndColor.getWidth()) {
                case 1: {
                    this.setIcon(JLWComboBox.ICON_1);
                    break;
                }
                case 2: {
                    this.setIcon(JLWComboBox.ICON_2);
                    break;
                }
                case 3: {
                    this.setIcon(JLWComboBox.ICON_3);
                    break;
                }
                case 4: {
                    this.setIcon(JLWComboBox.ICON_4);
                    break;
                }
                case 5: {
                    this.setIcon(JLWComboBox.ICON_5);
                    break;
                }
                case 6: {
                    this.setIcon(JLWComboBox.ICON_6);
                }
            }
            return this;
        }
    }

    static class LineColorCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LineColorCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DefaultLineWidthAndColor defaultLineWidthAndColor = (DefaultLineWidthAndColor)object;
            this.setOpaque(true);
            this.setBackground(defaultLineWidthAndColor.getColor());
            return this;
        }
    }

    static class FontsAndColorsCellRenderer
    extends JLabel
    implements TableCellRenderer {
        FontsAndColorsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DefaultFontAndColor defaultFontAndColor = (DefaultFontAndColor)object;
            this.setOpaque(true);
            if (n2 == 1) {
                this.setBackground(defaultFontAndColor.getBackgroundColor());
            } else {
                this.setBackground(defaultFontAndColor.getForegroundColor());
            }
            return this;
        }
    }
}

