/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class DiagramClassificationTypesPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_DiagramClassificationTypesPP";
    private static final String CT = "classification_types";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected DiagramClassificationTypesPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static DiagramClassificationTypesPreferences getInstance(PropertyStorage propertyStorage) {
        return new DiagramClassificationTypesPreferences(DiagramClassificationTypesPreferences.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public HashStructure getClassificationTypes() {
        return this._hash.getHashStructure(CT);
    }

    public void setClassificationTypes(List list) {
        int n = 0;
        Iterator iterator = list.iterator();
        HashStructure hashStructure = HashStructure.newInstance();
        while (iterator.hasNext()) {
            ++n;
            ClassificationType classificationType = (ClassificationType)iterator.next();
            HashStructure hashStructure2 = HashStructure.newInstance();
            hashStructure2.putString("name", classificationType.getTypeName());
            hashStructure2.putString("color", Integer.toString(classificationType.getTypeColor().getRGB()));
            hashStructure2.putString("prefix", classificationType.getTypePrefix());
            hashStructure2.putString("id", classificationType.getTypeID());
            hashStructure.putHashStructure(Integer.toString(n), hashStructure2);
        }
        this._hash.putHashStructure(CT, hashStructure);
    }

    private boolean contains(String string) {
        return this._hash.containsKey(string);
    }

    public void loadToSettings(Settings settings) {
        HashStructure hashStructure = this.getClassificationTypes();
        if (hashStructure != null) {
            Set set = hashStructure.keySet();
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                treeSet.add(new Integer((String)iterator.next()));
            }
            for (Integer n : treeSet) {
                HashStructure hashStructure2 = hashStructure.getHashStructure(Integer.toString(n));
                String string = hashStructure2.getString("id");
                String string2 = hashStructure2.getString("name");
                int n2 = hashStructure2.getInt("color");
                String string3 = hashStructure2.getString("prefix");
                ClassificationType classificationType = null;
                classificationType = !string.equalsIgnoreCase("") ? settings.getClassificationTypeByID(string) : settings.getClassificationTypeByName(string2);
                if (classificationType != null) {
                    classificationType.setTypeColor(new Color(n2));
                    classificationType.setTypePrefix(string3);
                    continue;
                }
                classificationType = new ClassificationType(string2, new Color(n2), "", string3);
                if (!"".equalsIgnoreCase(string)) {
                    classificationType.setTypeID(string);
                }
                settings.addClassificationType(classificationType);
            }
        }
    }

    public void loadFromSettings(Settings settings) {
        HashStructure hashStructure = this.getClassificationTypes();
        if (hashStructure != null) {
            hashStructure.clear();
        }
        this.setClassificationTypes(settings.getClassificationTypeList());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

