/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DiagramClassificationTypesPreferences;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.ColorChooserDialog;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

final class DiagramClassificationTypesPP
extends AbstractPP {
    private static final long serialVersionUID = -2643348634343833179L;
    private JTable classificationTypeTable;
    private JButton bnAddColumn;
    private JButton bnRemoveColumn;
    private static final String BTN_ADD = Messages.getString("OptionsDialog.Add");
    private static final String BTN_REMOVE = Messages.getString("OptionsDialog.Remove");
    private final List classificationTypeList = new ArrayList();
    private JPanel typePanel;

    public DiagramClassificationTypesPP() {
        this.setHelpID("DIAGRAM_CLASSIFICATION_TYPES_PREFS_PANEL");
        this.classificationTypeTable = new JTable(new ClassificationTypeModel());
        TableColumn tableColumn = this.classificationTypeTable.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new ClassificationTypeViewCellEditor());
        tableColumn.setCellRenderer(new ClassificationTypeCellRenderer());
        this.classificationTypeTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.classificationTypeTable);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.bnAddColumn = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        this.bnAddColumn.setToolTipText(BTN_ADD);
        this.bnAddColumn.addActionListener(new AddClassificationTypeAction());
        this.bnRemoveColumn = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.bnRemoveColumn.setToolTipText(BTN_REMOVE);
        this.bnRemoveColumn.addActionListener(new RemoveClassificationType());
        this.bnRemoveColumn.setEnabled(false);
        this.classificationTypeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = DiagramClassificationTypesPP.this.classificationTypeTable.getSelectedRow()) != -1 && DiagramClassificationTypesPP.this.classificationTypeList.size() > 0 && n < DiagramClassificationTypesPP.this.classificationTypeList.size()) {
                    ClassificationType classificationType = (ClassificationType)DiagramClassificationTypesPP.this.classificationTypeList.get(n);
                    DiagramClassificationTypesPP.this.bnRemoveColumn.setEnabled(!classificationType.isReadOnly());
                }
            }
        });
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.addSeparator();
        jToolBar.add(this.bnAddColumn);
        jToolBar.add(this.bnRemoveColumn);
        jPanel.add(jToolBar);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.Type")));
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
        this.add(jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.classificationTypeList.clear();
        for (ClassificationType classificationType : settings.getClassificationTypeList()) {
            this.classificationTypeList.add(classificationType.copy());
        }
        this.classificationTypeTable.updateUI();
    }

    public void onExit(TraversableContext traversableContext) {
        if (this.classificationTypeTable.getCellEditor() != null) {
            this.classificationTypeTable.getCellEditor().stopCellEditing();
        }
        settings.getClassificationTypeList().clear();
        for (Object object : this.classificationTypeList) {
            settings.addClassificationType(((ClassificationType)object).copy());
        }
        if (this.getCurrentDesign().getName().equals("Untitled_1") && this.getApplicationView().getDesigns().size() == 1) {
            Object object;
            object = this.getDiagramClassificationTypesPreferences(traversableContext);
            ((DiagramClassificationTypesPreferences)((Object)object)).setClassificationTypes(this.classificationTypeList);
        }
    }

    private DiagramClassificationTypesPreferences getDiagramClassificationTypesPreferences(TraversableContext traversableContext) {
        return DiagramClassificationTypesPreferences.getInstance(traversableContext.getPropertyStorage());
    }

    public class ClassificationTypeModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DiagramClassificationTypesPP.this.classificationTypeList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("OptionsDialog.Name");
            }
            if (n == 1) {
                return Messages.getString("OptionsDialog.Prefix");
            }
            return Messages.getString("OptionsDialog.Color");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            ClassificationType classificationType = (ClassificationType)DiagramClassificationTypesPP.this.classificationTypeList.get(n);
            if (n2 == 0) {
                return !classificationType.isReadOnly();
            }
            return true;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ClassificationType classificationType = (ClassificationType)DiagramClassificationTypesPP.this.classificationTypeList.get(n);
            if (n2 == 0) {
                return String.valueOf(classificationType.getTypeName());
            }
            if (n2 == 1) {
                return String.valueOf(classificationType.getTypePrefix());
            }
            if (n2 == 2) {
                return classificationType;
            }
            return n * n2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ClassificationType classificationType = (ClassificationType)DiagramClassificationTypesPP.this.classificationTypeList.get(n);
            if (n2 == 0) {
                classificationType.setTypeName((String)object);
            } else if (n2 == 1) {
                classificationType.setTypePrefix((String)object);
            }
        }
    }

    private class RemoveClassificationType
    implements ActionListener {
        private RemoveClassificationType() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ClassificationType classificationType;
            int n = DiagramClassificationTypesPP.this.classificationTypeTable.getSelectedRow();
            if (n != -1 && DiagramClassificationTypesPP.this.classificationTypeList.size() > 0 && n < DiagramClassificationTypesPP.this.classificationTypeList.size() && !(classificationType = (ClassificationType)DiagramClassificationTypesPP.this.classificationTypeList.get(n)).isReadOnly()) {
                DiagramClassificationTypesPP.this.classificationTypeList.remove(classificationType);
                DiagramClassificationTypesPP.this.classificationTypeTable.updateUI();
            }
        }
    }

    private class AddClassificationTypeAction
    implements ActionListener {
        private AddClassificationTypeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ClassificationType classificationType = new ClassificationType("Type_" + DiagramClassificationTypesPP.this.classificationTypeList.size(), Color.BLACK, new GUID().toString(), "");
            DiagramClassificationTypesPP.this.classificationTypeList.add(classificationType);
            DiagramClassificationTypesPP.this.classificationTypeTable.updateUI();
        }
    }

    static class ClassificationTypeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ClassificationTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ClassificationType classificationType = (ClassificationType)object;
            this.setOpaque(true);
            this.setBackground(classificationType.getTypeColor());
            this.setToolTipText(Messages.getString("OptionsDialog.ClickToEditTheClassificationTypeColor"));
            return this;
        }
    }

    class ClassificationTypeViewCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton colorEditButton = new JButton();
        ClassificationType classificationType;

        ClassificationTypeViewCellEditor() {
            this.colorEditButton.setOpaque(true);
            this.colorEditButton.addActionListener(this);
            this.colorEditButton.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Color color = new ColorChooserDialog((Dialog)new JDialog(DiagramClassificationTypesPP.this.getApplicationView().getFrame()), Messages.getString("OptionsDialog.SelectColor"), this.classificationType.getTypeColor()).showDialog();
            if (color != null) {
                this.colorEditButton.setBackground(color);
                this.classificationType.setTypeColor(color);
            }
            this.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.classificationType;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.classificationType = (ClassificationType)object;
            return this.colorEditButton;
        }
    }
}

