/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class DDLPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_DDLPP";
    private static final String DB2_TC = "db2_term_char";
    private static final String TST = "type_subst_triggers";
    private static final String T_FK_ARC = "fkarct_triggers";
    private static final String T_FK_NT = "fk_none_transferable_triggers";
    private static final String S_CB_DDL = "show_char_byte_in_ddl";
    private static final String USE_DT_KIND_C = "use_data_type_kind_in_compare";
    private static final String USE_SP_C = "use_schema_property_in_compare";
    private static final String USE_COP_C = "use_columns_order_property_in_compare";
    private static final String USE_CS_C = "use_case_sensitive_names_in_compare";
    private static final String NN_SF = "not_null_short_form_generation";
    private static final String UQI = "use_quoted_identifiers";
    private static final String CDI = "create_domains_during_import";
    private static final String A_PKC = "automatic_pk_generation";
    private static final String A_UKC = "automatic_uk_generation";
    private static final String A_FKC = "automatic_fk_generation";
    private static final String G_COMM = "generate_comments_in_rdbms";
    private static final String G_IN_C_CC = "generate_inline_column_cc";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected DDLPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static DDLPreferences getInstance(PropertyStorage propertyStorage) {
        return new DDLPreferences(DDLPreferences.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public String getDb2TermChar() {
        return this._hash.getString(DB2_TC);
    }

    public void setDb2TermChar(String string) {
        this._hash.putString(DB2_TC, string);
    }

    public boolean isSubstTrigger() {
        return this._hash.getBoolean(TST);
    }

    public void setSubstTrigger(boolean bl) {
        this._hash.putBoolean(TST, bl);
    }

    public boolean isfKArcTriggers() {
        return this._hash.getBoolean(T_FK_ARC);
    }

    public void setfKArcTriggers(boolean bl) {
        this._hash.putBoolean(T_FK_ARC, bl);
    }

    public boolean isfKNoneTransferableTriggers() {
        return this._hash.getBoolean(T_FK_NT);
    }

    public void setfKNoneTransferableTriggers(boolean bl) {
        this._hash.putBoolean(T_FK_NT, bl);
    }

    public boolean isShowByteCharInDDL() {
        return this._hash.getBoolean(S_CB_DDL);
    }

    public void setShowByteCharInDDL(boolean bl) {
        this._hash.putBoolean(S_CB_DDL, bl);
    }

    public boolean isUseDataTypeKind() {
        return this._hash.getBoolean(USE_DT_KIND_C);
    }

    public void setUseDataTypeKind(boolean bl) {
        this._hash.putBoolean(USE_DT_KIND_C, bl);
    }

    public boolean isCaseSensitiveNames() {
        return this._hash.getBoolean(USE_CS_C);
    }

    public void setCaseSensitiveNames(boolean bl) {
        this._hash.putBoolean(USE_CS_C, bl);
    }

    public boolean isNotNullShortForm() {
        return this._hash.getBoolean(NN_SF);
    }

    public void setNotNullShortForm(boolean bl) {
        this._hash.putBoolean(NN_SF, bl);
    }

    public boolean isUseQuotedIdentifiers() {
        return this._hash.getBoolean(UQI);
    }

    public void setUseQuotedIdentifiers(boolean bl) {
        this._hash.putBoolean(UQI, bl);
    }

    public boolean isCreateDomainsDuringImport() {
        return this._hash.getBoolean(CDI);
    }

    public void setCreateDomainsDuringImport(boolean bl) {
        this._hash.putBoolean(CDI, bl);
    }

    public boolean isGenerateCommentsInRDBMS() {
        return this._hash.getBoolean(G_COMM);
    }

    public void setGenerateCommentsInRDBMS(boolean bl) {
        this._hash.putBoolean(G_COMM, bl);
    }

    public boolean isGenerateInlineColumnCC() {
        return this._hash.getBoolean(G_IN_C_CC);
    }

    public void setGenerateInlineColumnCC(boolean bl) {
        this._hash.putBoolean(G_IN_C_CC, bl);
    }

    public boolean isAutomaticPKGeneration() {
        return this._hash.getBoolean(A_PKC);
    }

    public void setAutomaticPKGeneration(boolean bl) {
        this._hash.putBoolean(A_PKC, bl);
    }

    public boolean isAutomaticUKGeneration() {
        return this._hash.getBoolean(A_UKC);
    }

    public void setAutomaticUKGeneration(boolean bl) {
        this._hash.putBoolean(A_UKC, bl);
    }

    public boolean isAutomaticFKGeneration() {
        return this._hash.getBoolean(A_FKC);
    }

    public void setAutomaticFKGeneration(boolean bl) {
        this._hash.putBoolean(A_FKC, bl);
    }

    public boolean isUseSchemaProperty() {
        return this._hash.getBoolean(USE_SP_C);
    }

    public void setUseSchemaProperty(boolean bl) {
        this._hash.putBoolean(USE_SP_C, bl);
    }

    public boolean isUseColumnsOrderProperty() {
        return this._hash.getBoolean(USE_COP_C);
    }

    public void setUseColumnsOrderProperty(boolean bl) {
        this._hash.putBoolean(USE_COP_C, bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private boolean contains(String string) {
        return this._hash.containsKey(string);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(TST)) {
            settings.setGenerateTypeSubstTriggers(this.isSubstTrigger());
        }
        if (this.contains(T_FK_ARC)) {
            settings.setGenerateFKArcTriggers(this.isfKArcTriggers());
        }
        if (this.contains(T_FK_NT)) {
            settings.setGenerateFKNoneTransferableTriggers(this.isfKArcTriggers());
        }
        if (this.contains(S_CB_DDL)) {
            settings.setShowByteCharInDDL(this.isShowByteCharInDDL());
        }
        if (this.contains(USE_DT_KIND_C)) {
            settings.setUseDataTypeKindInCompare(this.isUseDataTypeKind());
        }
        if (this.contains(USE_SP_C)) {
            settings.setUseSchemaPropertyInCompare(this.isUseSchemaProperty());
        }
        if (this.contains(USE_COP_C)) {
            settings.setUseColumnsOrderPropertyInCompare(this.isUseColumnsOrderProperty());
        }
        if (this.contains(USE_CS_C)) {
            settings.setCaseSensitiveNamesInCompare(this.isCaseSensitiveNames());
        }
        if (this.contains(NN_SF)) {
            settings.setNotNullShortFormGeneration(this.isNotNullShortForm());
        }
        if (this.contains(UQI)) {
            settings.setUseQuotedIdentifiers(this.isUseQuotedIdentifiers());
        }
        if (this.contains(CDI)) {
            settings.setCreateDomainsDuringImport(this.isCreateDomainsDuringImport());
        }
        if (this.contains(G_COMM)) {
            settings.setGenerateCommentsInRDBMS(this.isGenerateCommentsInRDBMS());
        }
        if (this.contains(G_IN_C_CC)) {
            settings.setGenerateInlineColumnCC(this.isGenerateInlineColumnCC());
        }
        if (this.contains(A_PKC)) {
            settings.setAutomaticPKGeneration(this.isAutomaticPKGeneration());
        }
        if (this.contains(A_UKC)) {
            settings.setAutomaticUKGeneration(this.isAutomaticUKGeneration());
        }
        if (this.contains(A_FKC)) {
            settings.setAutomaticFKGeneration(this.isAutomaticFKGeneration());
        }
        if (this.contains(DB2_TC)) {
            settings.setDB2TerminationCharacter(this.getDb2TermChar() != null ? this.getDb2TermChar().charAt(0) : " ".charAt(0));
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setSubstTrigger(settings.isGenerateTypeSubstTriggers());
        this.setfKArcTriggers(settings.isGenerateFKArcTriggers());
        this.setfKNoneTransferableTriggers(settings.isGenerateFKNoneTransferableTriggers());
        this.setShowByteCharInDDL(settings.isShowByteCharInDDL());
        this.setUseDataTypeKind(settings.isUseDataTypeKindInCompare());
        this.setUseSchemaProperty(settings.isUseSchemaPropertyInCompare());
        this.setUseColumnsOrderProperty(settings.isUseColumnsOrderPropertyInCompare());
        this.setCaseSensitiveNames(settings.isCaseSensitiveNamesInCompare());
        this.setNotNullShortForm(settings.notNullShortFormGeneration());
        this.setUseQuotedIdentifiers(settings.isUseQuotedIdentifiers());
        this.setCreateDomainsDuringImport(settings.isCreateDomainsDuringImport());
        this.setAutomaticPKGeneration(settings.isAutomaticFKGeneration());
        this.setAutomaticUKGeneration(settings.isAutomaticUKGeneration());
        this.setAutomaticFKGeneration(settings.isAutomaticFKGeneration());
        this.setDb2TermChar(Character.toString(settings.getDB2TerminationCharacter()));
        this.setGenerateCommentsInRDBMS(settings.isGenerateCommentsInRDBMS());
        this.setGenerateInlineColumnCC(settings.isGenerateInlineColumnCC());
    }
}

