/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DDLMigrationPreferences;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.ide.panels.TraversableContext;

final class DDLMigrationPP
extends AbstractPP {
    private static final long serialVersionUID = 8774573172670882506L;
    private List substitutionList;
    private JTable tbSubstituiton;
    private JButton bnAddColumn;
    private JButton bnRemoveColumn;
    private JButton bnSelectAll;
    private JButton bnDeselectAll;
    private static final String BTN_ADD = Messages.getString("OptionsDialog.Add");
    private static final String BTN_REMOVE = Messages.getString("OptionsDialog.Remove");
    private JPanel substPanel;

    public DDLMigrationPP() {
        this.setHelpID("DDL_MIGRATION_PREFS_PANEL");
        this.substPanel = new JPanel(new GridBagLayout());
        this.substPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.NameSubstitution")));
        this.substitutionList = new ArrayList();
        SubstitutionModel substitutionModel = new SubstitutionModel();
        this.tbSubstituiton = new JTable(substitutionModel);
        this.tbSubstituiton.setSelectionMode(0);
        this.tbSubstituiton.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = DDLMigrationPP.this.tbSubstituiton.getSelectedRow();
                if (n == -1) {
                    DDLMigrationPP.this.bnRemoveColumn.setEnabled(false);
                } else {
                    DDLMigrationPP.this.bnRemoveColumn.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tbSubstituiton);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.bnAddColumn = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        this.bnAddColumn.setToolTipText(BTN_ADD);
        this.bnAddColumn.addActionListener(new AddSubstitutionAction());
        this.bnRemoveColumn = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.bnRemoveColumn.setToolTipText(BTN_REMOVE);
        this.bnRemoveColumn.addActionListener(new RemoveSubstitutionAction());
        this.bnRemoveColumn.setEnabled(false);
        this.bnSelectAll = new JButton(gUIConfiguration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        this.bnSelectAll.setToolTipText(Messages.getString("OptionsDialog.SelectAll"));
        this.bnSelectAll.addActionListener(new SelectAllSubstitutionAction());
        this.bnDeselectAll = new JButton(gUIConfiguration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        this.bnDeselectAll.setToolTipText(Messages.getString("OptionsDialog.DeselectAll"));
        this.bnDeselectAll.addActionListener(new DeselectAllSubstitutionAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.addSeparator();
        jToolBar.add(this.bnAddColumn);
        jToolBar.add(this.bnRemoveColumn);
        jToolBar.addSeparator();
        jToolBar.add(this.bnSelectAll);
        jToolBar.add(this.bnDeselectAll);
        jPanel.add(jToolBar);
        this.substPanel.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.substPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, -1));
        this.add(this.substPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.substitutionList.clear();
        for (SubstitutionPattern substitutionPattern : settings.getSubstitutionList()) {
            SubstitutionPattern substitutionPattern2 = new SubstitutionPattern(substitutionPattern.getSourceString(), substitutionPattern.getReplacementString(), substitutionPattern.isSelected(), substitutionPattern.isCaseSensitive(), substitutionPattern.getComments());
            this.substitutionList.add(substitutionPattern2);
        }
        this.tbSubstituiton.updateUI();
    }

    public void onExit(TraversableContext traversableContext) {
        if (this.tbSubstituiton.getCellEditor() != null) {
            this.tbSubstituiton.getCellEditor().stopCellEditing();
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.substitutionList.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        settings.getSubstitutionList().clear();
        settings.getSubstitutionList().addAll(arrayList);
        if (this.getCurrentDesign().getName().equals("Untitled_1") && this.getApplicationView().getDesigns().size() == 1) {
            DDLMigrationPreferences dDLMigrationPreferences = this.getDDLMigrationPreferences(traversableContext);
            dDLMigrationPreferences.setSubstList(this.substitutionList);
        }
    }

    private DDLMigrationPreferences getDDLMigrationPreferences(TraversableContext traversableContext) {
        return DDLMigrationPreferences.getInstance(traversableContext.getPropertyStorage());
    }

    private class RemoveSubstitutionAction
    implements ActionListener {
        private RemoveSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = DDLMigrationPP.this.tbSubstituiton.getSelectedRow();
            if (n != -1) {
                if (DDLMigrationPP.this.substitutionList.size() > 0 && n < DDLMigrationPP.this.substitutionList.size()) {
                    SubstitutionPattern substitutionPattern = (SubstitutionPattern)DDLMigrationPP.this.substitutionList.get(n);
                    DDLMigrationPP.this.substitutionList.remove(substitutionPattern);
                    DDLMigrationPP.this.tbSubstituiton.updateUI();
                    DDLMigrationPP.this.bnRemoveColumn.setEnabled(true);
                }
            } else {
                DDLMigrationPP.this.bnRemoveColumn.setEnabled(false);
            }
        }
    }

    private class AddSubstitutionAction
    implements ActionListener {
        private AddSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SubstitutionPattern substitutionPattern = new SubstitutionPattern();
            DDLMigrationPP.this.substitutionList.add(substitutionPattern);
            DDLMigrationPP.this.tbSubstituiton.getSelectionModel().setSelectionInterval(DDLMigrationPP.this.tbSubstituiton.getRowCount() - 1, DDLMigrationPP.this.tbSubstituiton.getRowCount() - 1);
            DDLMigrationPP.this.tbSubstituiton.updateUI();
        }
    }

    private class DeselectAllSubstitutionAction
    implements ActionListener {
        private DeselectAllSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (SubstitutionPattern substitutionPattern : DDLMigrationPP.this.substitutionList) {
                substitutionPattern.setSelected(false);
            }
            DDLMigrationPP.this.tbSubstituiton.updateUI();
        }
    }

    private class SelectAllSubstitutionAction
    implements ActionListener {
        private SelectAllSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (SubstitutionPattern substitutionPattern : DDLMigrationPP.this.substitutionList) {
                substitutionPattern.setSelected(true);
            }
            DDLMigrationPP.this.tbSubstituiton.updateUI();
        }
    }

    public class SubstitutionModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4792571976549726998L;

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return DDLMigrationPP.this.substitutionList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("OptionsDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("OptionsDialog.CaseSensitive");
            }
            if (n == 2) {
                return Messages.getString("OptionsDialog.Old");
            }
            if (n == 3) {
                return Messages.getString("OptionsDialog.New");
            }
            if (n == 4) {
                return Messages.getString("OptionsDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SubstitutionPattern substitutionPattern = (SubstitutionPattern)DDLMigrationPP.this.substitutionList.get(n);
            if (n2 == 0) {
                return substitutionPattern.isSelected();
            }
            if (n2 == 1) {
                return substitutionPattern.isCaseSensitive();
            }
            if (n2 == 2) {
                return substitutionPattern.getSourceString();
            }
            if (n2 == 3) {
                return substitutionPattern.getReplacementString();
            }
            if (n2 == 4) {
                return substitutionPattern.getComments();
            }
            return n * n2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SubstitutionPattern substitutionPattern = (SubstitutionPattern)DDLMigrationPP.this.substitutionList.get(n);
            if (n2 == 0) {
                substitutionPattern.setSelected((Boolean)object);
            } else if (n2 == 1) {
                substitutionPattern.setCaseSensitive((Boolean)object);
            } else if (n2 == 2) {
                substitutionPattern.setSourceString(this.checkValue((String)object, true));
            } else if (n2 == 3) {
                substitutionPattern.setReplacementString(this.checkValue((String)object, false));
            } else if (n2 == 4) {
                substitutionPattern.setComments((String)object);
            }
        }

        private String checkValue(String string, boolean bl) {
            block4: {
                if (string.trim().equals("")) break block4;
                if (bl) {
                    for (SubstitutionPattern substitutionPattern : DDLMigrationPP.this.substitutionList) {
                        if (substitutionPattern.getReplacementString().indexOf(string) <= -1) continue;
                        JOptionPane.showMessageDialog(new JDialog(DDLMigrationPP.this.getApplicationView().getFrame()), new Object[]{Messages.getString("OptionsDialog.OldStringCanNotBePartOfNewString")}, Messages.getString("OptionsDialog.ErrorMessage"), 0);
                        return "";
                    }
                } else {
                    for (SubstitutionPattern substitutionPattern : DDLMigrationPP.this.substitutionList) {
                        if (substitutionPattern.getSourceString().indexOf(string) <= -1) continue;
                        JOptionPane.showMessageDialog(DDLMigrationPP.this.getApplicationView().getFrame(), new Object[]{Messages.getString("OptionsDialog.NewStringCanNotBePartOfOldString")}, Messages.getString("OptionsDialog.ErrorMessage"), 0);
                        return "";
                    }
                }
            }
            return string;
        }
    }
}

