/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.fcp.preferences.OldConnection;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class DBMConnectionPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_DBMConnections";
    private static final String DBM_CONNECTIONS = "dbmconnections";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected DBMConnectionPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static DBMConnectionPreferences getInstance(PropertyStorage propertyStorage) {
        return new DBMConnectionPreferences(DBMConnectionPreferences.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public void removeOldConnections() {
        HashStructure hashStructure = HashStructure.newInstance();
        this._hash.putHashStructure(DBM_CONNECTIONS, hashStructure);
    }

    public void loadToSettings(Settings settings) {
        HashStructure hashStructure = this._hash.getHashStructure(DBM_CONNECTIONS);
        if (hashStructure != null) {
            OldConnection.getDBMConnections().clear();
            Set set = hashStructure.keySet();
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                treeSet.add(new Integer((String)iterator.next()));
            }
            for (Integer n : treeSet) {
                HashStructure hashStructure2 = hashStructure.getHashStructure(Integer.toString(n));
                OldConnection oldConnection = new OldConnection();
                Set set2 = hashStructure2.keySet();
                for (String string : set2) {
                    if (string == null) continue;
                    HashStructure hashStructure3 = hashStructure2.getHashStructure(string);
                    Object object = this.getObjectFromElement(hashStructure3);
                    if (string == null || object == null) continue;
                    oldConnection.put(string, object);
                }
                OldConnection.getDBMConnections().add(oldConnection);
            }
        }
    }

    private Object getObjectFromElement(HashStructure hashStructure) {
        String string3 = "";
        String string2 = "";
        Set set = hashStructure.keySet();
        for (String string3 : set) {
            string2 = hashStructure.getString(string3);
        }
        Object object = null;
        try {
            Class<?> clazz = Class.forName(string3);
            Method method = null;
            Constructor<?> constructor = null;
            try {
                method = clazz.getMethod("valueOf", String.class);
            }
            catch (Exception exception) {
                constructor = clazz.getConstructor(String.class);
            }
            if (method != null) {
                object = method.invoke(null, string2);
            } else if (constructor != null) {
                object = constructor.newInstance(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

