/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.plSqlSourceEditors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import javax.swing.Action;
import oracle.dbtools.crest.fcp.Icons;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public class PlSqlSourceEditorToolbar
implements EditorPlugin,
Controller {
    private static final Logger LOGGER = new Logger(PlSqlSourceEditorToolbar.class);
    private static final String SAVE_SOURCE = Messages.getString("PlSqlSourceEditorToolbar.Save");
    private static int DM_SAVE_SOURCE_CMD_ID = Ide.findOrCreateCmdID((String)"DM_SAVE_SOURCE_CMD_ID");
    private IdeAction saveSourceAction = IdeAction.get((int)DM_SAVE_SOURCE_CMD_ID);
    private CodeEditor codeEditor;

    public PlSqlSourceEditorToolbar() {
        this.saveSourceAction.addController((Controller)this);
        this.saveSourceAction.setEnabled(true);
        this.saveSourceAction.putValue("SmallIcon", (Object)Icons.getSaveIcon());
        this.saveSourceAction.putValue("ShortDescription", (Object)SAVE_SOURCE);
    }

    public void install(BasicEditorPane basicEditorPane) {
        ToolButton toolButton = new ToolButton((Action)this.saveSourceAction);
        this.codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        Toolbar toolbar = this.codeEditor.getToolbar();
        toolbar.add((Component)toolButton, toolbar.getComponentCount());
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DM_SAVE_SOURCE_CMD_ID) {
            try {
                context.getNode().save();
                OutlineWindow.getInstance().refresh((Editor)this.codeEditor);
            }
            catch (IOException iOException) {
                LOGGER.error(SAVE_SOURCE, iOException);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }
}

