/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.fcp.extension.SubordinateTablesReader;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.util.logging.Logger;

public class SubordinateTablesOracle
extends SubordinateTablesReader {
    private static final Logger LOGGER = new Logger(SubordinateTablesOracle.class);

    public SubordinateTablesOracle(Connection connection, List list) {
        super(connection, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAllObjects(boolean bl) {
        Statement statement = null;
        if (this.tableObjects.size() > 0) {
            try {
                String string = "select a.owner,a.table_name from sys.all_constraints a, (select owner,constraint_name from sys.all_constraints where owner = ? and table_name = ? and constraint_type in ('P','U')) b where a.constraint_type = 'R' and a.r_constraint_name = b.constraint_name and a.r_owner = b.owner";
                ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
                arrayList.addAll(this.tableObjects);
                statement = this.connection.prepareStatement(string);
                for (int i = 0; i < arrayList.size(); ++i) {
                    DBObject dBObject = (DBObject)arrayList.get(i);
                    statement.setString(1, dBObject.getSchema());
                    statement.setString(2, dBObject.getName());
                    ResultSet resultSet = null;
                    resultSet = statement.executeQuery();
                    if (resultSet == null) continue;
                    while (resultSet.next()) {
                        String string2;
                        String string3 = resultSet.getString(1);
                        if (this.hasDBObject(this.tableObjects, string3, string2 = resultSet.getString(2))) continue;
                        DBObject dBObject2 = new DBObject(true, string2, "TABLE", string3);
                        if (bl) {
                            arrayList.add(dBObject2);
                        }
                        this.tableObjects.add(dBObject2);
                        this.selectedObjects.add(dBObject2);
                    }
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LOGGER.error("SubordinateTablesOracle.getAllObjects():", sQLException);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.error("SubordinateTablesOracle.getAllObjects():", sQLException);
                    }
                }
            }
        }
        return this.selectedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFKs_fromChilds(Connection connection, List list, Design design, RDBMSSite rDBMSSite) {
        Object object2;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (Object object2 : list) {
            if (!"TABLE".equalsIgnoreCase(((DBObject)object2).getType())) continue;
            arrayList.add((DBObject)object2);
        }
        object2 = null;
        Statement statement = null;
        if (arrayList.size() > 0) {
            try {
                String string = "select a.owner,a.table_name, a.constraint_name, a.delete_rule,a.r_constraint_name, a.deferred, a.deferrable from sys.all_constraints a, (select owner,constraint_name from sys.all_constraints where owner = ? and table_name = ? and constraint_type in ('P','U')) b where a.constraint_type = 'R' and a.r_constraint_name = b.constraint_name and a.r_owner = b.owner";
                ArrayList<DBObject> arrayList2 = new ArrayList<DBObject>();
                arrayList2.addAll(arrayList);
                object2 = connection.prepareStatement(string);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    DBObject dBObject = (DBObject)arrayList2.get(i);
                    Table table = this.getTable(dBObject.getSchema(), dBObject.getName(), design, rDBMSSite);
                    if (table == null) continue;
                    object2.setString(1, dBObject.getSchema());
                    object2.setString(2, dBObject.getName());
                    ResultSet resultSet = null;
                    resultSet = object2.executeQuery();
                    if (resultSet == null) continue;
                    while (resultSet.next()) {
                        Object object3;
                        Index index;
                        String string2;
                        String string3 = resultSet.getString(1);
                        Table table2 = this.getTable(string3, string2 = resultSet.getString(2), design, rDBMSSite);
                        if (table2 == null) continue;
                        String string4 = resultSet.getString(3);
                        String string5 = resultSet.getString(4);
                        String string6 = resultSet.getString(5);
                        Index index2 = table.getIndexByName(string6);
                        if (index2 == null || (index = table2.getIndexByName(string4)) != null) continue;
                        FKIndexAssociation fKIndexAssociation = table2.addFK(index2);
                        fKIndexAssociation.setName(string4);
                        fKIndexAssociation.getLocalFKIndex().setName(string4);
                        fKIndexAssociation.setDeleteRule(string5);
                        if (statement == null) {
                            object3 = "select column_name from all_cons_columns where owner = ? and table_name = ? and constraint_name = ? order by position";
                            statement = connection.prepareStatement((String)object3);
                        }
                        statement.setString(1, string3);
                        statement.setString(2, string2);
                        statement.setString(3, string4);
                        object3 = null;
                        object3 = statement.executeQuery();
                        if (object3 != null) {
                            int n = 0;
                            while (object3.next()) {
                                String string7 = object3.getString(1);
                                Column column = (Column)table2.getElementByName(string7);
                                Column column2 = null;
                                try {
                                    column2 = (Column)index2.getElement(n);
                                }
                                catch (Exception exception) {
                                    continue;
                                }
                                if (column != null && column2 != null) {
                                    column.addFKAssociation(column2, fKIndexAssociation);
                                    fKIndexAssociation.getLocalFKIndex().add(column);
                                }
                                ++n;
                            }
                            object3.close();
                        }
                        fKIndexAssociation.resetMandatoryUsingColumns();
                        fKIndexAssociation.resetEdgeParams();
                    }
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LOGGER.error("SubordinateTablesOracle.getAllObjects():", sQLException);
            }
            finally {
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    LOGGER.error("SubordinateTablesOracle.getAllObjects():", sQLException);
                }
            }
        }
    }

    private Table getTable(String string, String string2, Design design, RDBMSSite rDBMSSite) {
        RelationalDesign relationalDesign = design.getRelationalDesign();
        if (relationalDesign != null) {
            StorageDesign storageDesign = relationalDesign.getStorageDesign(rDBMSSite);
            Iterator iterator = storageDesign.getTableProxySet().iterator();
            while (iterator.hasNext()) {
                TableProxy tableProxy = (TableProxy)iterator.next();
                StorageObject storageObject = tableProxy.getUserSchema();
                String string3 = "";
                if (storageObject != null) {
                    string3 = storageObject.getName();
                }
                Table table = (Table)tableProxy.getObject();
                if (storageObject == null) {
                    string3 = table.getProperty("SCHEMA");
                }
                if ((string3 == null || !string3.equalsIgnoreCase(string) || !string2.equalsIgnoreCase(tableProxy.getName())) && (string3 != null || !string2.equalsIgnoreCase(tableProxy.getName()))) continue;
                return table;
            }
        }
        return null;
    }
}

