/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.fcp.extension.SubordinateTablesReader;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHAlterTableOraclev10g;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.util.logging.Logger;

public class SubordinateTablesJDBC
extends SubordinateTablesReader {
    private static final Logger LOGGER = new Logger(SubordinateTablesJDBC.class);
    static final String SCHEMA_PROPERTY = "schema";

    public SubordinateTablesJDBC(Connection connection, List list) {
        super(connection, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(boolean bl, String string) {
        if (this.tableObjects.size() > 0) {
            try {
                DatabaseMetaData databaseMetaData = this.connection.getMetaData();
                ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
                arrayList.addAll(this.tableObjects);
                for (int i = 0; i < arrayList.size(); ++i) {
                    DBObject dBObject = (DBObject)arrayList.get(i);
                    ResultSet resultSet = null;
                    try {
                        resultSet = this.getExportedKeys(databaseMetaData, dBObject.getSchema(), dBObject.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (resultSet == null) continue;
                    while (resultSet.next()) {
                        DBObject dBObject2;
                        String string2 = resultSet.getString(5);
                        String string3 = resultSet.getString(6);
                        String string4 = resultSet.getString(7);
                        String string5 = dBObject.getSchema();
                        if (string3 != null && !"".equals(string3)) {
                            string5 = string3;
                        } else if (string2 != null && !"".equals(string2)) {
                            string5 = string2;
                        }
                        if (this.hasDBObject(this.tableObjects, string5, string4)) continue;
                        if ("MICROSOFT".equals(string)) {
                            dBObject2 = new DBObjectSqlServer(true, string4, "TABLE", string5);
                            ((DBObjectSqlServer)dBObject2).setDb(string2);
                        } else {
                            dBObject2 = new DBObject(true, string4, "TABLE", string5);
                        }
                        if (bl) {
                            arrayList.add(dBObject2);
                        }
                        this.tableObjects.add(dBObject2);
                        this.selectedObjects.add(dBObject2);
                    }
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LOGGER.error("SubordinateTablesJDBC.getAllObjects():", sQLException);
            }
        }
        return this.selectedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFKs_fromChilds(Connection connection, List list, Design design, RDBMSSite rDBMSSite) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : list) {
            if (!"TABLE".equalsIgnoreCase(((DBObject)object).getType())) continue;
            arrayList.add(object);
        }
        if (arrayList.size() > 0) {
            try {
                Object object;
                object = connection.getMetaData();
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    Object object9;
                    DBObject dBObject = (DBObject)arrayList.get(i);
                    ResultSet resultSet = null;
                    try {
                        resultSet = this.getExportedKeys((DatabaseMetaData)object, dBObject.getSchema(), dBObject.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ArrayList<FKHelper> arrayList2 = new ArrayList<FKHelper>();
                    Table table = this.getTable(dBObject.getSchema(), dBObject.getName(), design, rDBMSSite);
                    if (table == null) continue;
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String string = resultSet.getString(4);
                            String string2 = resultSet.getString(5);
                            object9 = resultSet.getString(6);
                            object8 = resultSet.getString(7);
                            object7 = resultSet.getString(8);
                            object6 = resultSet.getString(11);
                            object5 = resultSet.getString(12);
                            object4 = resultSet.getString(13);
                            Object object10 = dBObject.getSchema();
                            if (object9 != null && !"".equals(object9)) {
                                object10 = object9;
                            } else if (string2 != null && !"".equals(string2)) {
                                object10 = string2;
                            }
                            if ((object3 = this.getTable((String)object10, (String)object8, design, rDBMSSite)) == null) continue;
                            object2 = this.getFKHelperForChildTable((Table)object3, arrayList2, (String)object5);
                            ((FKHelper)object2).fk_NAME = object5;
                            ((FKHelper)object2).pk_NAME = object4;
                            ((FKHelper)object2).pkTable = table;
                            ((FKHelper)object2).fkDELETE_RULE = object6;
                            if (object7 != null) {
                                ((FKHelper)object2).fkColNames.add(object7);
                                ((FKHelper)object2).pkColNames.add(string);
                                continue;
                            }
                            System.out.println("Unable to find FK column!");
                        }
                        resultSet.close();
                    }
                    for (FKHelper fKHelper : arrayList2) {
                        object9 = fKHelper.pkTable;
                        object8 = fKHelper.chTable;
                        object7 = null;
                        if (object8 != null) {
                            object7 = ((Table)object8).getIndexByName(fKHelper.fk_NAME);
                        }
                        if (object9 == null || object8 == null || object7 != null) continue;
                        object6 = null;
                        object6 = fKHelper.pk_NAME == null ? SHAlterTableOraclev10g.getUniqueIndexForColumnNames((Table)object9, fKHelper.pkColNames) : ((Table)object9).getIndexByName(fKHelper.pk_NAME);
                        object5 = null;
                        object4 = null;
                        if (object6 != null) {
                            for (int j = 0; j < fKHelper.fkColNames.size(); ++j) {
                                String string;
                                Column column;
                                object3 = (String)fKHelper.pkColNames.get(j);
                                if (object3 != null && (object4 = (Column)((ContainerObject)object9).getElementByName((String)object3)) == null) {
                                    object4 = ((Table)object9).createColumn();
                                    ((DesignObject)object4).setName((String)object3);
                                    ((Index)object6).add((ContainedObject)object4);
                                }
                                if ((column = (Column)((ContainerObject)object8).getElementByName((String)(object2 = (String)fKHelper.fkColNames.get(j)))) == null) {
                                    column = ((Table)object8).createColumn();
                                    column.setName((String)object2);
                                }
                                if ((string = fKHelper.fk_NAME) != null) {
                                    FKIndexAssociation[] fKIndexAssociationArray = ((Table)object8).getFKAssociations();
                                    for (int k = 0; k < fKIndexAssociationArray.length; ++k) {
                                        FKIndexAssociation fKIndexAssociation = fKIndexAssociationArray[k];
                                        if (!fKIndexAssociation.getLocalFKIndex().getName().equalsIgnoreCase(string)) continue;
                                        object5 = fKIndexAssociation;
                                        break;
                                    }
                                }
                                if (object5 == null) {
                                    int n;
                                    object5 = ((Table)object8).addFK((KeyObject)object6);
                                    if (string != null) {
                                        ((FKIndexAssociation)object5).setName(string);
                                        ((FKIndexAssociation)object5).getLocalFKIndex().setName(string);
                                    }
                                    try {
                                        n = Integer.valueOf(fKHelper.fkDELETE_RULE);
                                    }
                                    catch (Exception exception) {
                                        n = 3;
                                    }
                                    switch (n) {
                                        case 3: {
                                            ((FKIndexAssociation)object5).setDeleteRule("NO ACTION");
                                            break;
                                        }
                                        case 0: {
                                            ((FKIndexAssociation)object5).setDeleteRule("CASCADE");
                                            break;
                                        }
                                        case 2: {
                                            ((FKIndexAssociation)object5).setDeleteRule("SET NULL");
                                            break;
                                        }
                                        case 1: {
                                            ((FKIndexAssociation)object5).setDeleteRule("RESTRICT");
                                        }
                                    }
                                }
                                column.addFKAssociation((Column)object4, (FKIndexAssociation)object5);
                                ((FKIndexAssociation)object5).getLocalFKIndex().add(column);
                            }
                        }
                        if (object5 == null) continue;
                        ((FKIndexAssociation)object5).resetMandatoryUsingColumns();
                    }
                }
            }
            catch (SQLException sQLException) {
                LOGGER.error("SubordinateTablesJDBC.generateFKs_fromChilds():", sQLException);
            }
        }
    }

    private Table getTable(String string, String string2, Design design, RDBMSSite rDBMSSite) {
        RelationalDesign relationalDesign = design.getRelationalDesign();
        if (relationalDesign != null) {
            StorageDesign storageDesign = relationalDesign.getStorageDesign(rDBMSSite);
            Iterator iterator = storageDesign.getTableProxySet().iterator();
            while (iterator.hasNext()) {
                TableProxy tableProxy = (TableProxy)iterator.next();
                StorageObject storageObject = tableProxy.getUserSchema();
                String string3 = "";
                if (storageObject != null) {
                    string3 = storageObject.getName();
                }
                Table table = (Table)tableProxy.getObject();
                if (storageObject == null) {
                    string3 = table.getProperty("SCHEMA");
                }
                if ((string3 == null || !string3.equalsIgnoreCase(string) || !string2.equalsIgnoreCase(tableProxy.getName())) && (string3 != null || !string2.equalsIgnoreCase(tableProxy.getName()))) continue;
                return table;
            }
        }
        return null;
    }

    protected ResultSet getExportedKeys(DatabaseMetaData databaseMetaData, String string, String string2) throws Exception {
        return databaseMetaData.getExportedKeys(null, string, string2);
    }

    private FKHelper getFKHelperForChildTable(Table table, List<FKHelper> list, String string) {
        FKHelper fKHelper2;
        for (FKHelper fKHelper2 : list) {
            if (fKHelper2.chTable != table) continue;
            if (string != null && !"".equals(string)) {
                if (!string.equalsIgnoreCase(fKHelper2.fk_NAME)) continue;
                return fKHelper2;
            }
            return fKHelper2;
        }
        fKHelper2 = new FKHelper();
        fKHelper2.chTable = table;
        list.add(fKHelper2);
        return fKHelper2;
    }

    private static class FKHelper {
        public List pkColNames = new ArrayList();
        public List fkColNames = new ArrayList();
        public String fkDELETE_RULE = "";
        public String fk_NAME = null;
        public String pk_NAME = null;
        public Table pkTable = null;
        public Table chTable = null;

        private FKHelper() {
        }
    }
}

