/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHForeignKeySQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHProcedureSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHTableSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHViewSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHForeignKeySQLServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHPartitionColumnSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHProcedureSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHTableSQLServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHUserSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHViewSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ExtractionHandlerSQLServer
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private List mohObjects = null;
    private List mohObjectsv2k5 = null;
    private ApplicationView view;
    private static final Logger LOGGER = new Logger(ExtractionHandlerSQLServer.class);

    public ExtractionHandlerSQLServer(ApplicationView applicationView) {
        this.view = applicationView;
    }

    @Override
    public void init(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                LOGGER.error(throwable);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DBObject> getUsers(String string, Connection connection) throws Exception {
        Object object;
        ArrayList<DBUserSqlServer> arrayList = new ArrayList<DBUserSqlServer>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("NAME").append(' ').append(',');
                ((StringBuffer)object).append("UID").append(' ').append(',');
                ((StringBuffer)object).append("sid").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(string).append(".dbo.sysusers").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("sid").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("DBMExtractionHandlerSQLServer.getUsers(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    object = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    String string3 = "0x" + resultSet.getString(3);
                    String string4 = this.getLogin(string3, connection);
                    String string5 = string4 + " / " + (String)object;
                    if (string4 == null && !((String)object).equalsIgnoreCase("guest")) {
                        string5 = "BUILTIN\\Admin / " + (String)object;
                    }
                    DBUserSqlServer dBUserSqlServer = new DBUserSqlServer(false, string5, "Login / User");
                    dBUserSqlServer.setUid(string2);
                    dBUserSqlServer.setDb(string);
                    arrayList.add(dBUserSqlServer);
                }
            }
            object = arrayList;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(resultSet, statement);
            throw throwable;
        }
        JDBCUtils.close(resultSet, statement);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLogin(String string, Connection connection) throws Exception {
        StringBuffer stringBuffer;
        ResultSet resultSet = null;
        Statement statement = connection.createStatement();
        try {
            CharSequence charSequence;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("loginname").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append("master.dbo.syslogins").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("sid").append('=').append(string);
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("DBMExtractionHandlerSQLServer.getLogin(): " + sQLException.getMessage());
            }
            charSequence = null;
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                }
            }
            stringBuffer = charSequence;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(resultSet, statement);
            throw throwable;
        }
        JDBCUtils.close(resultSet, statement);
        return stringBuffer;
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 1: {
                return this.getMOHObjectsv2k5();
            }
            case 9: {
                return this.getMOHObjectsv2k5();
            }
        }
        return this.getMOHObjectsv2k();
    }

    private List getMOHObjectsv2k5() {
        if (this.mohObjectsv2k5 == null) {
            this.mohObjectsv2k5 = new ArrayList();
            this.mohObjectsv2k5.add(new MOHUserSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHTableSQLServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHForeignKeySQLServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHPartitionColumnSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHViewSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHProcedureSqlServerv2k5(this, this.view));
        }
        return this.mohObjectsv2k5;
    }

    public List getMOHObjectsv2k() {
        if (this.mohObjects == null) {
            this.mohObjects = new ArrayList();
            this.mohObjects.add(new MOHUserSqlServer(this, this.view));
            this.mohObjects.add(new MOHTableSQLServer(this, this.view));
            this.mohObjects.add(new MOHForeignKeySQLServer(this, this.view));
            this.mohObjects.add(new MOHViewSqlServer(this, this.view));
            this.mohObjects.add(new MOHProcedureSqlServer(this, this.view));
        }
        return this.mohObjects;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 1: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k5.RDBMS_TYPE);
            }
            case 9: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k5.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k5.RDBMS_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDesign(Connection connection, List list, ImportLogger importLogger, ProgressDialog progressDialog) throws Exception {
        List list2 = this.getMOHObjects();
        if (list.size() > 0 && list2.size() > 0 && connection != null) {
            try {
                int n = 0;
                double d = 10.0;
                int n2 = list2.size();
                for (AbstractMOHandler abstractMOHandler : list2) {
                    abstractMOHandler.generate(connection, list, importLogger);
                    abstractMOHandler.clearHandledObjects(list);
                    ++n;
                    progressDialog.setProgress((int)(d += 75.0 / (double)n2));
                }
                for (AbstractMOHandler abstractMOHandler : list2) {
                    abstractMOHandler.postGenerateProcessing(connection);
                }
            }
            catch (Exception exception) {
                importLogger.addError(exception.getMessage());
            }
        }
    }
}

