/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.oracle.MOHCollectionTypeOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDirectoryOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHObjectColumnsOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHProcedureOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSequenceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSynonymOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHUserOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHViewOracle;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHBitmapIndexesv10g;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHBitmapIndexesv9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTableOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeIncompleteOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeOraclev9i;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;

class ExtractionHandlerOracle
extends AbstractDBMExtractionHandler {
    private List mohObjectsv9i = null;
    private List mohObjectsv10g = null;
    private ApplicationView view;

    public ExtractionHandlerOracle(ApplicationView applicationView) {
        this.view = applicationView;
    }

    @Override
    public void init(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return this.getMOHObjectsv9i();
            }
            case 10: {
                return this.getMOHObjectsv10g();
            }
            case 11: {
                return this.getMOHObjectsv10g();
            }
        }
        return this.getMOHObjectsv10g();
    }

    public List getMOHObjectsv9i() {
        if (this.mohObjectsv9i == null) {
            this.mohObjectsv9i = new ArrayList();
            this.mohObjectsv9i.add(new MOHTypeIncompleteOraclev9i(this, this.view));
            this.mohObjectsv9i.add(new MOHTypeOraclev9i(this, this.view));
            this.mohObjectsv9i.add(new MOHCollectionTypeOracle(this, this.view));
            this.mohObjectsv9i.add(new MOHDirectoryOracle(this, this.view));
            this.mohObjectsv9i.add(new MOHUserOracle(this, this.view));
            this.mohObjectsv9i.add(new MOHTableOraclev9i(this, this.view));
            this.mohObjectsv9i.add(new MOHBitmapIndexesv9i(this, this.view));
            this.mohObjectsv9i.add(new MOHObjectColumnsOracle(this, this.view));
            this.mohObjectsv9i.add(new MOHViewOracle(this, this.view));
            this.mohObjectsv9i.add(new MOHProcedureOracle(this, this.view));
            this.mohObjectsv9i.add(new MOHSequenceOracle(this, this.view));
            this.mohObjectsv9i.add(new MOHSynonymOracle(this, this.view));
        }
        return this.mohObjectsv9i;
    }

    public List getMOHObjectsv10g() {
        if (this.mohObjectsv10g == null) {
            this.mohObjectsv10g = new ArrayList();
            this.mohObjectsv10g.add(new MOHTypeIncompleteOraclev9i(this, this.view));
            this.mohObjectsv10g.add(new MOHTypeOraclev9i(this, this.view));
            this.mohObjectsv10g.add(new MOHCollectionTypeOracle(this, this.view));
            this.mohObjectsv10g.add(new MOHDirectoryOracle(this, this.view));
            this.mohObjectsv10g.add(new MOHUserOracle(this, this.view));
            this.mohObjectsv10g.add(new MOHTableOraclev9i(this, this.view));
            this.mohObjectsv10g.add(new MOHBitmapIndexesv10g(this, this.view));
            this.mohObjectsv10g.add(new MOHObjectColumnsOracle(this, this.view));
            this.mohObjectsv10g.add(new MOHViewOracle(this, this.view));
            this.mohObjectsv10g.add(new MOHProcedureOracle(this, this.view));
            this.mohObjectsv10g.add(new MOHSequenceOracle(this, this.view));
            this.mohObjectsv10g.add(new MOHSynonymOracle(this, this.view));
        }
        return this.mohObjectsv10g;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev9i.RDBMS_TYPE);
            }
            case 10: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev10g.RDBMS_TYPE);
            }
            case 11: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev11g.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev11g.RDBMS_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDesign(Connection connection, List list, ImportLogger importLogger, ProgressDialog progressDialog) throws Exception {
        List list2 = this.getMOHObjects();
        if (list.size() > 0 && list2.size() > 0 && connection != null) {
            try {
                int n = 0;
                double d = 10.0;
                int n2 = list2.size();
                for (AbstractMOHandler abstractMOHandler : list2) {
                    abstractMOHandler.generate(connection, list, importLogger);
                    abstractMOHandler.clearHandledObjects(list);
                    ++n;
                    progressDialog.setProgress((int)(d += 75.0 / (double)n2));
                }
                for (AbstractMOHandler abstractMOHandler : list2) {
                    abstractMOHandler.postGenerateProcessing(connection);
                }
            }
            catch (Exception exception) {
                importLogger.addError(exception.getMessage());
            }
        }
    }
}

