/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.odbc.MOHForeignKeyODBC;
import oracle.dbtools.crest.imports.metadata.odbc.MOHTableODBC;
import oracle.dbtools.crest.imports.metadata.odbc.MOHViewODBC;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class ExtractionHandlerODBC
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private static final String DB_NAME_UDB = "UDB";
    private static final String DB_NAME_ORACLE = "ORACLE";
    private static final String DB_NAME_SQL_SERVER = "SQL SERVER";
    private List mohObjects = null;
    private ApplicationView view;

    public ExtractionHandlerODBC(ApplicationView applicationView) {
        this.view = applicationView;
    }

    @Override
    public void init(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public List getMOHObjects() {
        if (this.mohObjects == null) {
            this.mohObjects = new ArrayList();
            this.mohObjects.add(new MOHTableODBC(this, this.view));
            this.mohObjects.add(new MOHForeignKeyODBC(this, this.view));
            this.mohObjects.add(new MOHViewODBC(this, this.view));
        }
        return this.mohObjects;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        if (this.dbMajorVersion == -1) {
            String string = this.dbProductVersion.indexOf(46) > -1 ? this.dbProductVersion.substring(0, this.dbProductVersion.indexOf(46)) : this.dbProductVersion;
            try {
                this.dbMajorVersion = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_ORACLE) > -1) {
            switch (this.dbMajorVersion) {
                case 8: 
                case 9: {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev9i.RDBMS_TYPE);
                }
                case 10: {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev10g.RDBMS_TYPE);
                }
                case 11: {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev11g.RDBMS_TYPE);
                }
            }
            return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev11g.RDBMS_TYPE);
        }
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_SQL_SERVER) > -1) {
            return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k.RDBMS_TYPE);
        }
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_UDB) > -1) {
            switch (this.dbMajorVersion) {
                case 7: {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv71.RDBMS_TYPE);
                }
                case 8: 
                case 9: {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
                }
            }
            return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev11g.RDBMS_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDesign(Connection connection, List list, ImportLogger importLogger, ProgressDialog progressDialog) throws Exception {
        List list2 = this.getMOHObjects();
        if (list.size() > 0 && list2.size() > 0 && connection != null) {
            try {
                int n = 0;
                double d = 10.0;
                int n2 = list2.size();
                for (AbstractMOHandler abstractMOHandler : list2) {
                    abstractMOHandler.setSupportInformation_Schema(true);
                    abstractMOHandler.generate(connection, list, importLogger);
                    abstractMOHandler.clearHandledObjects(list);
                    ++n;
                    progressDialog.setProgress((int)(d += 75.0 / (double)n2));
                }
                for (AbstractMOHandler abstractMOHandler : list2) {
                    abstractMOHandler.postGenerateProcessing(connection);
                }
            }
            catch (Exception exception) {
                importLogger.addError(exception.getMessage());
            }
        }
    }
}

