/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.udb.MOHAliasUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHDatatypeUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHForeignKeyUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHOwnerUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTableUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTypeIncompleteUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTypeUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHViewUDB;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHForeignKeyUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHTableUDBv81;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class ExtractionHandlerDB2
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private List mohObjectsv7 = null;
    private List mohObjectsv8 = null;
    private ApplicationView view;

    public ExtractionHandlerDB2(ApplicationView applicationView) {
        this.view = applicationView;
    }

    @Override
    public void init(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 7: {
                return this.getMOHObjectsv7();
            }
            case 8: {
                return this.getMOHObjectsv8();
            }
            case 9: {
                return this.getMOHObjectsv8();
            }
        }
        return this.getMOHObjectsv8();
    }

    public List getMOHObjectsv7() {
        if (this.mohObjectsv7 == null) {
            this.mohObjectsv7 = new ArrayList();
            this.mohObjectsv7.add(new MOHOwnerUDB(this, this.view));
            this.mohObjectsv7.add(new MOHTypeIncompleteUDB(this, this.view));
            this.mohObjectsv7.add(new MOHDatatypeUDB(this, this.view));
            this.mohObjectsv7.add(new MOHTypeUDB(this, this.view));
            this.mohObjectsv7.add(new MOHTableUDB(this, this.view));
            this.mohObjectsv7.add(new MOHForeignKeyUDB(this, this.view));
            this.mohObjectsv7.add(new MOHViewUDB(this, this.view));
            this.mohObjectsv7.add(new MOHAliasUDB(this, this.view));
        }
        return this.mohObjectsv7;
    }

    public List getMOHObjectsv8() {
        if (this.mohObjectsv8 == null) {
            this.mohObjectsv8 = new ArrayList();
            this.mohObjectsv8.add(new MOHOwnerUDB(this, this.view));
            this.mohObjectsv8.add(new MOHTypeIncompleteUDB(this, this.view));
            this.mohObjectsv8.add(new MOHDatatypeUDB(this, this.view));
            this.mohObjectsv8.add(new MOHTypeUDB(this, this.view));
            this.mohObjectsv8.add(new MOHTableUDBv81(this, this.view));
            this.mohObjectsv8.add(new MOHForeignKeyUDBv81(this, this.view));
            this.mohObjectsv8.add(new MOHViewUDB(this, this.view));
            this.mohObjectsv8.add(new MOHAliasUDB(this, this.view));
        }
        return this.mohObjectsv8;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 7: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv71.RDBMS_TYPE);
            }
            case 8: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
            }
            case 9: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
    }

    private void initSchemas(List list) {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            if (!"SCHEMA".equalsIgnoreCase(dBObject.getType())) continue;
            arrayList.add(dBObject);
        }
        MOHOwnerUDB.setSchemas(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDesign(Connection connection, List list, ImportLogger importLogger, ProgressDialog progressDialog) throws Exception {
        List list2 = this.getMOHObjects();
        if (list.size() > 0 && list2.size() > 0 && connection != null) {
            this.initSchemas(list);
            try {
                int n = 0;
                double d = 10.0;
                int n2 = list2.size();
                for (AbstractMOHandler abstractMOHandler : list2) {
                    abstractMOHandler.generate(connection, list, importLogger);
                    abstractMOHandler.clearHandledObjects(list);
                    ++n;
                    progressDialog.setProgress((int)(d += 75.0 / (double)n2));
                }
                for (AbstractMOHandler abstractMOHandler : list2) {
                    abstractMOHandler.postGenerateProcessing(connection);
                }
            }
            catch (Exception exception) {
                importLogger.addError(exception.getMessage());
            }
        }
    }
}

