/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerDB2;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerODBC;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerOracle;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerSQLServer;
import oracle.dbtools.crest.fcp.extension.Messages;
import oracle.dbtools.crest.fcp.extension.SubordinateTablesJDBC;
import oracle.dbtools.crest.fcp.extension.SubordinateTablesOracle;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.navigator.xml.AbstractNodeInstance;
import oracle.dbtools.thirdparty.db2.DB2ConnectionPanel;
import oracle.dbtools.thirdparty.udb.UDBConnectionPanel;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.ideimpl.explorer.dnd.MultiTransferable;

public class EXTDropHandler
implements DropTargetListener {
    private static final String DB_TYPE_ORACLE = "ORACLE";
    public static final String DB_TYPE_MS_SQL_SERVER = "MICROSOFT";
    private static final String DB_TYPE_DB2 = "DB2";
    private static final String DB_TYPE_JDBC = "JDBC";
    private static final String PROPERTY_SCHEMA = "SCHEMA";
    private static final String PROPERTY_CATALOG = "CATALOG";
    private static final String PROPERTY_TABLE_CATALOG = "TABLE_CATALOG";
    private static final String PROPERTY_OBJECT_NAME = "OBJECT_NAME";
    private static final String PROPERTY_TABLE_NAME = "TABLE_NAME";
    private static final String PROPERTY_DIRECTORY_NAME = "DIRECTORY_NAME";
    private static final String PROPERTY_SYNONYM_NAME = "SYNONYM_NAME";
    private static final String PROPERTY_NAME = "NAME";
    private static final String PROPERTY_TYPE = "TYPE";
    private static final String PROPERTY_UTYPES = "UTYPES";
    private static final String PROPERTY_TABLE = "TABLE";
    private static final String PROPERTY_VIEW = "VIEW";
    private static final String PROPERTY_MATERIALIZED_VIEW = "MATERIALIZED VIEW";
    private static final String PROPERTY_SYNONYM = "SYNONYM";
    private static final String PROPERTY_PUBLIC_SYNONYM = "PUBLIC_SYNONYM";
    private static final String PROPERTY_SEQUENCE = "SEQUENCE";
    private static final String PROPERTY_DIRECTORY = "DIRECTORY";
    private static final String PROPERTY_PROCEDURE = "PROCEDURE";
    private static final String PROPERTY_PROCEDURES = "PROCEDURES";
    private static final String PROPERTY_ALIASES = "ALIASES";
    private ApplicationView appView;
    private List selectedObjects = new ArrayList();
    private List droppedTables = new ArrayList();
    private List droppedViews = new ArrayList();
    private List droppedTypes = new ArrayList();
    private Connection currentConnection;
    private String currentConnectionName;
    private Point currentPoint;
    private List types;
    private PreparedStatement objectTypeStatement;
    private PreparedStatement objectTypeStatementUDB;
    private boolean copy_mode = false;
    private static final Logger LOGGER = new Logger(EXTDropHandler.class);

    public void setApplicationView(ApplicationView applicationView) {
        this.appView = applicationView;
        this.types = new ArrayList();
        this.types.add(PROPERTY_TABLE);
        this.types.add(PROPERTY_VIEW);
        this.types.add(PROPERTY_MATERIALIZED_VIEW);
        this.types.add(PROPERTY_SYNONYM);
        this.types.add(PROPERTY_PUBLIC_SYNONYM);
        this.types.add(PROPERTY_SEQUENCE);
        this.types.add(PROPERTY_DIRECTORY);
        this.types.add(PROPERTY_PROCEDURE);
        this.types.add(PROPERTY_PROCEDURES);
        this.types.add(PROPERTY_ALIASES);
    }

    private boolean isRelationalModelSelected() {
        return this.appView.getCurrentDPV().getDesignPart() instanceof RelationalDesign;
    }

    private boolean isDatatypeModelSelected() {
        return this.appView.getCurrentDPV().getDesignPart() instanceof DataTypesDesign;
    }

    private boolean isSupportedNode(Object object) {
        if (object != null && object instanceof ExplorerNode) {
            ObjectNode objectNode;
            Object object2;
            ObjectFolder objectFolder;
            Object object3;
            PlSqlNode plSqlNode;
            Object object4;
            ExplorerNode explorerNode = (ExplorerNode)object;
            Object object5 = explorerNode.getUserObject();
            if (this.isRelationalModelSelected()) {
                ObjectFolder objectFolder2;
                Object object6;
                if (object5 instanceof ObjectNode) {
                    ObjectNode objectNode2 = (ObjectNode)object5;
                    Object object7 = objectNode2.getProperty(PROPERTY_TYPE);
                    if (object7 != null) {
                        for (String string : this.types) {
                            if (!string.equalsIgnoreCase((String)object7)) continue;
                            return true;
                        }
                    }
                } else if (object5 instanceof PlSqlNode) {
                    PlSqlNode plSqlNode2 = (PlSqlNode)object5;
                    Object object8 = plSqlNode2.getProperty(PROPERTY_TYPE);
                    if (object8 != null) {
                        for (String string : this.types) {
                            if (!string.equalsIgnoreCase((String)object8)) continue;
                            return true;
                        }
                    }
                } else if (object5 instanceof ObjectFolder && (object6 = (objectFolder2 = (ObjectFolder)object5).getProperty(PROPERTY_TYPE)) != null) {
                    for (String string : this.types) {
                        if (!string.equalsIgnoreCase((String)object6)) continue;
                        return true;
                    }
                }
            } else if (this.isDatatypeModelSelected() && (object5 instanceof PlSqlNode ? (object4 = (plSqlNode = (PlSqlNode)object5).getProperty(PROPERTY_TYPE)) != null && PROPERTY_TYPE.equalsIgnoreCase((String)object4) : (object5 instanceof ObjectFolder ? (object3 = (objectFolder = (ObjectFolder)object5).getProperty(PROPERTY_TYPE)) != null && (PROPERTY_TYPE.equalsIgnoreCase((String)object3) || PROPERTY_UTYPES.equalsIgnoreCase((String)object3)) : object5 instanceof ObjectNode && (object2 = (objectNode = (ObjectNode)object5).getProperty(PROPERTY_TYPE)) != null && PROPERTY_UTYPES.equalsIgnoreCase((String)object2)))) {
                return true;
            }
        }
        return false;
    }

    private boolean isDragFlavorSupported(DropTargetDragEvent dropTargetDragEvent) {
        if (this.isRelationalModelSelected() || this.isDatatypeModelSelected()) {
            if (dropTargetDragEvent.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
                try {
                    Object object = dropTargetDragEvent.getTransferable().getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
                    boolean bl = this.isSupportedNode(object);
                    if (bl) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {}
            } else if (dropTargetDragEvent.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                try {
                    Object object = dropTargetDragEvent.getTransferable().getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR);
                    if (object != null && object instanceof TransferablesList) {
                        TransferablesList transferablesList = (TransferablesList)object;
                        for (Object e : transferablesList) {
                            Object object2;
                            boolean bl;
                            MultiTransferable multiTransferable;
                            if (!(e instanceof MultiTransferable) || !(multiTransferable = (MultiTransferable)e).isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) || !(bl = this.isSupportedNode(object2 = multiTransferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR)))) continue;
                            return true;
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private DataFlavor chooseDropFlavor(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor dataFlavor = null;
        if (dropTargetDropEvent.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
            dataFlavor = TransferableTreeNode.TREE_NODE_FLAVOR;
        } else if (dropTargetDropEvent.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
            dataFlavor = TransferablesList.TRANSFERABLE_LIST_FLAVOR;
        }
        return dataFlavor;
    }

    private boolean isDragOk(DropTargetDragEvent dropTargetDragEvent) {
        if (ApplicationView.IS_VIEWER && !this.appView.getCurrentDesign().isNewDesign()) {
            return false;
        }
        if (!this.isDragFlavorSupported(dropTargetDragEvent)) {
            return false;
        }
        return (dropTargetDragEvent.getDropAction() & 3) > 0 || (dropTargetDragEvent.getDropAction() & 0x40000000) > 0;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor dataFlavor = this.chooseDropFlavor(dropTargetDropEvent);
        if (dataFlavor == null) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        int n = dropTargetDropEvent.getDropAction();
        if ((n & 3) == 0) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        this.copy_mode = (n & 1) != 0;
        Object object = null;
        try {
            dropTargetDropEvent.acceptDrop(3);
            object = dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
            if (object == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        this.selectedObjects.clear();
        this.droppedTables.clear();
        this.droppedViews.clear();
        this.droppedTypes.clear();
        this.currentConnection = null;
        this.currentConnectionName = "";
        this.objectTypeStatement = null;
        this.objectTypeStatementUDB = null;
        this.currentPoint = dropTargetDropEvent.getLocation();
        if (object instanceof ExplorerNode) {
            this.dropObject(object);
            this.addDesignConnectionStamp();
            new Thread(new Runner()).start();
        } else if (object instanceof TransferablesList) {
            try {
                TransferablesList transferablesList = (TransferablesList)object;
                for (Object e : transferablesList) {
                    Object object2;
                    MultiTransferable multiTransferable;
                    if (!(e instanceof MultiTransferable) || !(multiTransferable = (MultiTransferable)e).isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) || (object2 = multiTransferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR)) == null || !(object2 instanceof ExplorerNode)) continue;
                    this.dropObject(object2);
                }
                this.addDesignConnectionStamp();
                new Thread(new Runner()).start();
            }
            catch (Exception exception) {}
        } else {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        dropTargetDropEvent.dropComplete(true);
        if (this.objectTypeStatement != null) {
            try {
                this.objectTypeStatement.close();
            }
            catch (SQLException sQLException) {
                LOGGER.error("EXTDropHandler.drop():", sQLException);
            }
            this.objectTypeStatement = null;
        }
        if (this.objectTypeStatementUDB != null) {
            try {
                this.objectTypeStatementUDB.close();
            }
            catch (SQLException sQLException) {
                LOGGER.error("EXTDropHandler.drop():", sQLException);
            }
            this.objectTypeStatementUDB = null;
        }
    }

    private void addDesignConnectionStamp() {
        RelationalDesign relationalDesign = this.appView.getCurrentDesign().getRelationalDesign();
        if (relationalDesign != null && this.currentConnection != null) {
            try {
                String string = this.currentConnectionName;
                if (string.toUpperCase().startsWith("IDECONNECTIONS%23")) {
                    string = string.substring(17);
                }
                String string2 = this.currentConnection.getMetaData().getURL();
                String string3 = this.currentConnection.getMetaData().getUserName();
                String string4 = this.currentConnection.getMetaData().getDatabaseProductName();
                int n = 0;
                if ("Oracle".equalsIgnoreCase(string4)) {
                    n = 1;
                } else if ("Microsoft SQL Server".equalsIgnoreCase(string4)) {
                    n = 2;
                } else if (DB2ConnectionPanel.CONNECTION_TYPE.equalsIgnoreCase(string4)) {
                    n = 3;
                } else if (UDBConnectionPanel.CONNECTION_TYPE.equalsIgnoreCase(string4)) {
                    n = 4;
                }
                int n2 = relationalDesign.addImportConnectionStamp(new DBConnectionStamp(string, string2, string3, n));
                relationalDesign.setImportConnectionStampIndex(n2);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean schemaExists(String string) {
        for (DBObject dBObject : this.selectedObjects) {
            if (!dBObject.getSchema().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void clearImportedTables(RDBMSSite rDBMSSite) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.selectedObjects);
        for (DBObject dBObject : arrayList) {
            if (!PROPERTY_TABLE.equalsIgnoreCase(dBObject.getType())) continue;
            Table table = this.getTable(dBObject.getSchema(), dBObject.getName(), rDBMSSite);
            if (table != null) {
                this.droppedTables.remove(dBObject.getName());
                this.selectedObjects.remove(dBObject);
                continue;
            }
            if (this.droppedTables.contains(dBObject.getName())) continue;
            this.droppedTables.add(dBObject.getName());
        }
    }

    private Table getTable(String string, String string2, RDBMSSite rDBMSSite) {
        RelationalDesign relationalDesign = this.appView.getCurrentDesign().getRelationalDesign();
        if (relationalDesign != null) {
            StorageDesign storageDesign = relationalDesign.getStorageDesign(rDBMSSite);
            Iterator iterator = storageDesign.getTableProxySet().iterator();
            while (iterator.hasNext()) {
                TableProxy tableProxy = (TableProxy)iterator.next();
                StorageObject storageObject = tableProxy.getUserSchema();
                String string3 = "";
                if (storageObject != null) {
                    string3 = storageObject.getName();
                }
                Table table = (Table)tableProxy.getObject();
                if (storageObject == null) {
                    string3 = table.getProperty(PROPERTY_SCHEMA);
                }
                if ((string3 == null || !string3.equalsIgnoreCase(string) || !string2.equalsIgnoreCase(tableProxy.getName())) && (string3 != null || !string2.equalsIgnoreCase(tableProxy.getName()))) continue;
                return table;
            }
        }
        return null;
    }

    private String getObjectTypeKind(String string, String string2) {
        if (this.currentConnection != null) {
            try {
                String string3;
                if (this.objectTypeStatement == null) {
                    string3 = " select typecode from sys.all_types where owner = ? and type_name = ?";
                    this.objectTypeStatement = this.currentConnection.prepareStatement(string3);
                }
                string3 = "OBJECT";
                if (this.objectTypeStatement != null) {
                    ResultSet resultSet = null;
                    this.objectTypeStatement.setString(1, string2);
                    this.objectTypeStatement.setString(2, string);
                    resultSet = this.objectTypeStatement.executeQuery();
                    if (resultSet != null) {
                        if (resultSet.next()) {
                            string3 = resultSet.getString(1);
                        }
                        resultSet.close();
                        return string3;
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("EXTDropHandler.getObjectTypeKind():", exception);
            }
        }
        return "OBJECT";
    }

    private String getObjectTypeKindUDB(String string, String string2) {
        if (this.currentConnection != null) {
            try {
                String string3;
                if (this.objectTypeStatementUDB == null) {
                    string3 = "select metatype from syscat.datatypes where typeschema = ? and typename = ?";
                    this.objectTypeStatementUDB = this.currentConnection.prepareStatement(string3);
                }
                string3 = PROPERTY_TYPE;
                if (this.objectTypeStatementUDB != null) {
                    ResultSet resultSet = null;
                    this.objectTypeStatementUDB.setString(1, string2);
                    this.objectTypeStatementUDB.setString(2, string);
                    resultSet = this.objectTypeStatementUDB.executeQuery();
                    if (resultSet != null) {
                        if (resultSet.next()) {
                            String string4 = resultSet.getString(1);
                            string3 = string4 != null && "T".equalsIgnoreCase(string4) ? "DATATYPE" : PROPERTY_TYPE;
                        }
                        resultSet.close();
                        return string3;
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("EXTDropHandler.getObjectTypeKindUDB():", exception);
            }
        }
        return PROPERTY_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dropObject(Object object) {
        ObjectFolder objectFolder;
        Object object2;
        ExplorerNode explorerNode = (ExplorerNode)object;
        Object object3 = explorerNode.getUserObject();
        if (object3 == null) return;
        if (object3 instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)object3;
            Object object4 = objectNode.getProperty(PROPERTY_TYPE);
            if (object4 == null) return;
            try {
                objectNode.ensureOpen();
                try {
                    String string;
                    if (this.currentConnection == null) {
                        this.currentConnectionName = objectNode.getConnectionName();
                        this.currentConnection = objectNode.getNodeInstance().getObjectFactory().getConnection();
                        if (this.appView.getCurrentDPV().getDesignPart() instanceof RelationalDesign) {
                            this.appView.getCurrentDesign().setRelationalDesign((RelationalDesign)this.appView.getCurrentDPV().getDesignPart());
                        }
                    }
                    if ((string = this.currentConnection.getMetaData().getDatabaseProductName()) == null) return;
                    if (string.toUpperCase().contains(DB_TYPE_ORACLE)) {
                        Object object5;
                        String string2 = (String)objectNode.getNodeInstance().getProperty(PROPERTY_SCHEMA);
                        if (!this.schemaExists(string2)) {
                            object5 = new DBObject(true, string2, "USER", string2);
                            this.selectedObjects.add(object5);
                        }
                        if (PROPERTY_TABLE.equalsIgnoreCase(String.valueOf(object4)) || PROPERTY_MATERIALIZED_VIEW.equalsIgnoreCase(String.valueOf(object4))) {
                            object5 = objectNode.getShortLabel();
                            if (object5 == null) return;
                            DBObject dBObject = new DBObject(true, (String)object5, PROPERTY_TABLE, string2);
                            this.selectedObjects.add(dBObject);
                            this.droppedTables.add(object5);
                            return;
                        } else if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(object4))) {
                            object5 = objectNode.getShortLabel();
                            if (object5 == null) return;
                            DBObject dBObject = new DBObject(true, (String)object5, PROPERTY_VIEW, string2);
                            this.selectedObjects.add(dBObject);
                            this.droppedViews.add(object5);
                            return;
                        } else if (PROPERTY_SEQUENCE.equalsIgnoreCase(String.valueOf(object4))) {
                            object5 = objectNode.getShortLabel();
                            if (object5 == null) return;
                            DBObject dBObject = new DBObject(true, (String)object5, PROPERTY_SEQUENCE, string2);
                            this.selectedObjects.add(dBObject);
                            return;
                        } else if (PROPERTY_SYNONYM.equalsIgnoreCase(String.valueOf(object4)) || PROPERTY_PUBLIC_SYNONYM.equalsIgnoreCase(String.valueOf(object4))) {
                            object5 = objectNode.getShortLabel();
                            if (object5 == null) return;
                            DBObject dBObject = new DBObject(true, (String)object5, PROPERTY_SYNONYM, string2);
                            this.selectedObjects.add(dBObject);
                            return;
                        } else {
                            if (!PROPERTY_DIRECTORY.equalsIgnoreCase(String.valueOf(object4)) || (object5 = objectNode.getShortLabel()) == null) return;
                            DBObject dBObject = new DBObject(true, (String)object5, PROPERTY_DIRECTORY, string2);
                            this.selectedObjects.add(dBObject);
                            return;
                        }
                    } else if (string.toUpperCase().contains(DB_TYPE_MS_SQL_SERVER)) {
                        Object object6;
                        String string3 = (String)objectNode.getNodeInstance().getProperty(PROPERTY_SCHEMA);
                        String string4 = (String)objectNode.getNodeInstance().getProperty(PROPERTY_CATALOG);
                        if (string4 == null) {
                            string4 = "";
                        }
                        if (!this.schemaExists(string3)) {
                            object6 = new DBUserSqlServer(true, string3, "USER", string3);
                            ((DBObjectSqlServer)object6).setDb(string4);
                            this.selectedObjects.add(object6);
                        }
                        if (PROPERTY_TABLE.equalsIgnoreCase(String.valueOf(object4))) {
                            object6 = objectNode.getShortLabel();
                            if (object6 == null) return;
                            DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(true, (String)object6, PROPERTY_TABLE, string3);
                            dBObjectSqlServer.setDb(string4);
                            this.selectedObjects.add(dBObjectSqlServer);
                            this.droppedTables.add(object6);
                            return;
                        } else if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(object4))) {
                            object6 = objectNode.getShortLabel();
                            if (object6 == null) return;
                            DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(true, (String)object6, PROPERTY_VIEW, string3);
                            dBObjectSqlServer.setDb(string4);
                            this.selectedObjects.add(dBObjectSqlServer);
                            this.droppedViews.add(object6);
                            return;
                        } else {
                            if (!PROPERTY_PROCEDURES.equalsIgnoreCase(String.valueOf(object4)) || (object6 = objectNode.getShortLabel()) == null) return;
                            DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(true, (String)object6, PROPERTY_PROCEDURE, string3);
                            dBObjectSqlServer.setDb(string4);
                            this.selectedObjects.add(dBObjectSqlServer);
                            return;
                        }
                    } else if (string.toUpperCase().contains(DB_TYPE_DB2)) {
                        Object object7;
                        String string5 = (String)objectNode.getNodeInstance().getProperty(PROPERTY_SCHEMA);
                        if (string5 != null) {
                            string5 = string5.trim();
                        }
                        if (!this.schemaExists(string5)) {
                            object7 = new DBObject(true, string5, PROPERTY_SCHEMA, string5);
                            this.selectedObjects.add(object7);
                        }
                        if (PROPERTY_TABLE.equalsIgnoreCase(String.valueOf(object4))) {
                            object7 = objectNode.getShortLabel();
                            if (object7 == null) return;
                            DBObject dBObject = new DBObject(true, (String)object7, PROPERTY_TABLE, string5);
                            this.selectedObjects.add(dBObject);
                            this.droppedTables.add(object7);
                            return;
                        } else if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(object4))) {
                            object7 = objectNode.getShortLabel();
                            if (object7 == null) return;
                            DBObject dBObject = new DBObject(true, (String)object7, PROPERTY_VIEW, string5);
                            this.selectedObjects.add(dBObject);
                            this.droppedViews.add(object7);
                            return;
                        } else if (PROPERTY_UTYPES.equalsIgnoreCase(String.valueOf(object4))) {
                            object7 = objectNode.getShortLabel();
                            if (object7 == null) return;
                            String string6 = this.getObjectTypeKindUDB((String)object7, string5);
                            DBObject dBObject = new DBObject(true, (String)object7, string6, string5);
                            this.selectedObjects.add(dBObject);
                            this.droppedTypes.add(object7);
                            return;
                        } else {
                            if (!PROPERTY_ALIASES.equalsIgnoreCase(String.valueOf(object4)) || (object7 = objectNode.getShortLabel()) == null) return;
                            DBObject dBObject = new DBObject(true, (String)object7, "ALIAS", string5);
                            this.selectedObjects.add(dBObject);
                            this.droppedTypes.add(object7);
                            return;
                        }
                    } else {
                        Object object8;
                        String string7 = (String)objectNode.getNodeInstance().getProperty(PROPERTY_SCHEMA);
                        if (string7 != null) {
                            string7 = string7.trim();
                        }
                        if (!this.schemaExists(string7)) {
                            object8 = new DBObject(true, string7, PROPERTY_SCHEMA, string7);
                            this.selectedObjects.add(object8);
                        }
                        if (PROPERTY_TABLE.equalsIgnoreCase(String.valueOf(object4))) {
                            object8 = objectNode.getShortLabel();
                            if (object8 == null) return;
                            DBObject dBObject = new DBObject(true, (String)object8, PROPERTY_TABLE, string7);
                            this.selectedObjects.add(dBObject);
                            this.droppedTables.add(object8);
                            return;
                        } else {
                            if (!PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(object4)) || (object8 = objectNode.getShortLabel()) == null) return;
                            DBObject dBObject = new DBObject(true, (String)object8, PROPERTY_VIEW, string7);
                            this.selectedObjects.add(dBObject);
                            this.droppedViews.add(object8);
                            return;
                        }
                    }
                }
                finally {
                    objectNode.close();
                }
            }
            catch (Exception exception) {}
            return;
        }
        if (object3 instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)object3;
            Object object9 = plSqlNode.getProperty(PROPERTY_TYPE);
            if (object9 == null) return;
            try {
                plSqlNode.ensureOpen();
                try {
                    Object object10;
                    String string;
                    if (this.currentConnection == null) {
                        this.currentConnectionName = plSqlNode.getConnectionName();
                        this.currentConnection = plSqlNode.getNodeInstance().getObjectFactory().getConnection();
                        if (this.isRelationalModelSelected()) {
                            this.appView.getCurrentDesign().setRelationalDesign((RelationalDesign)this.appView.getCurrentDPV().getDesignPart());
                        }
                    }
                    if (!(string = this.currentConnection.getMetaData().getDatabaseProductName()).toUpperCase().contains(DB_TYPE_ORACLE)) return;
                    String string8 = (String)plSqlNode.getNodeInstance().getProperty(PROPERTY_SCHEMA);
                    if (!this.schemaExists(string8)) {
                        object10 = new DBObject(true, string8, "USER", string8);
                        this.selectedObjects.add(object10);
                    }
                    if (PROPERTY_TYPE.equalsIgnoreCase(String.valueOf(object9))) {
                        object10 = plSqlNode.getShortLabel();
                        if (object10 == null) return;
                        String string9 = this.getObjectTypeKind((String)object10, string8);
                        DBObject dBObject = new DBObject(true, (String)object10, string9, string8);
                        this.selectedObjects.add(dBObject);
                        this.droppedTypes.add(object10);
                        return;
                    } else {
                        if (!PROPERTY_PROCEDURE.equalsIgnoreCase(String.valueOf(object9)) || (object10 = plSqlNode.getShortLabel()) == null) return;
                        DBObject dBObject = new DBObject(true, (String)object10, PROPERTY_PROCEDURE, string8);
                        this.selectedObjects.add(dBObject);
                        return;
                    }
                }
                finally {
                    plSqlNode.close();
                }
            }
            catch (Exception exception) {}
            return;
        }
        if (!(object3 instanceof ObjectFolder) || (object2 = (objectFolder = (ObjectFolder)object3).getProperty(PROPERTY_TYPE)) == null) return;
        if (this.isRelationalModelSelected()) {
            try {
                Object object11;
                String string;
                if (this.currentConnection == null) {
                    this.currentConnectionName = objectFolder.getConnectionName();
                    this.currentConnection = objectFolder.getFolderInstance().getObjectFactory().getConnection();
                    if (this.appView.getCurrentDPV().getDesignPart() instanceof RelationalDesign) {
                        this.appView.getCurrentDesign().setRelationalDesign((RelationalDesign)this.appView.getCurrentDPV().getDesignPart());
                    }
                }
                if ((string = this.currentConnection.getMetaData().getDatabaseProductName()) == null) return;
                if (string.toUpperCase().contains(DB_TYPE_ORACLE)) {
                    Object object12;
                    String string10 = (String)objectFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                    if (!this.schemaExists(string10)) {
                        object12 = new DBObject(true, string10, "USER", string10);
                        this.selectedObjects.add(object12);
                    }
                    if (PROPERTY_TABLE.equalsIgnoreCase((String)object2) || PROPERTY_MATERIALIZED_VIEW.equalsIgnoreCase(String.valueOf(object2))) {
                        object12 = objectFolder.getFolderInstance().listChildren();
                        Iterator iterator = object12.iterator();
                        while (iterator.hasNext()) {
                            AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                            String string11 = (String)abstractNodeInstance.getProperty(PROPERTY_OBJECT_NAME);
                            if (string11 == null) {
                                string11 = (String)abstractNodeInstance.getProperty(PROPERTY_NAME);
                            }
                            if (string11 == null || "".equalsIgnoreCase(string11) || this.droppedTables.contains(string11)) continue;
                            DBObject dBObject = new DBObject(true, string11, PROPERTY_TABLE, string10);
                            this.selectedObjects.add(dBObject);
                            this.droppedTables.add(string11);
                        }
                        return;
                    }
                    if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(object2))) {
                        object12 = objectFolder.getFolderInstance().listChildren();
                        Iterator iterator = object12.iterator();
                        while (iterator.hasNext()) {
                            AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                            String string12 = (String)abstractNodeInstance.getProperty(PROPERTY_OBJECT_NAME);
                            if (string12 == null || "".equalsIgnoreCase(string12) || this.droppedViews.contains(string12)) continue;
                            DBObject dBObject = new DBObject(true, string12, PROPERTY_VIEW, string10);
                            this.selectedObjects.add(dBObject);
                            this.droppedViews.add(string12);
                        }
                        return;
                    }
                    if (PROPERTY_SEQUENCE.equalsIgnoreCase(String.valueOf(object2))) {
                        object12 = objectFolder.getFolderInstance().listChildren();
                        Iterator iterator = object12.iterator();
                        while (iterator.hasNext()) {
                            AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                            String string13 = (String)abstractNodeInstance.getProperty(PROPERTY_OBJECT_NAME);
                            if (string13 == null || "".equalsIgnoreCase(string13)) continue;
                            DBObject dBObject = new DBObject(true, string13, PROPERTY_SEQUENCE, string10);
                            this.selectedObjects.add(dBObject);
                        }
                        return;
                    }
                    if (PROPERTY_SYNONYM.equalsIgnoreCase(String.valueOf(object2)) || PROPERTY_PUBLIC_SYNONYM.equalsIgnoreCase(String.valueOf(object2))) {
                        object12 = objectFolder.getFolderInstance().listChildren();
                        Iterator iterator = object12.iterator();
                        while (iterator.hasNext()) {
                            AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                            String string14 = (String)abstractNodeInstance.getProperty(PROPERTY_SYNONYM_NAME);
                            if (string14 == null || "".equalsIgnoreCase(string14)) continue;
                            DBObject dBObject = new DBObject(true, string14, PROPERTY_SYNONYM, string10);
                            this.selectedObjects.add(dBObject);
                        }
                        return;
                    }
                    if (PROPERTY_DIRECTORY.equalsIgnoreCase(String.valueOf(object2))) {
                        object12 = objectFolder.getFolderInstance().listChildren();
                        Iterator iterator = object12.iterator();
                        while (iterator.hasNext()) {
                            AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                            String string15 = (String)abstractNodeInstance.getProperty(PROPERTY_DIRECTORY_NAME);
                            if (string15 == null || "".equalsIgnoreCase(string15)) continue;
                            DBObject dBObject = new DBObject(true, string15, PROPERTY_DIRECTORY, string10);
                            this.selectedObjects.add(dBObject);
                        }
                        return;
                    }
                    if (!PROPERTY_PROCEDURE.equalsIgnoreCase(String.valueOf(object2))) return;
                    object12 = objectFolder.getFolderInstance().listChildren();
                    Iterator iterator = object12.iterator();
                    while (iterator.hasNext()) {
                        AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                        String string16 = (String)abstractNodeInstance.getProperty(PROPERTY_NAME);
                        if (string16 == null || "".equalsIgnoreCase(string16)) continue;
                        DBObject dBObject = new DBObject(true, string16, PROPERTY_PROCEDURE, string10);
                        this.selectedObjects.add(dBObject);
                    }
                    return;
                }
                if (string.toUpperCase().contains(DB_TYPE_MS_SQL_SERVER)) {
                    Object object13;
                    String string17 = (String)objectFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                    String string18 = (String)objectFolder.getFolderInstance().getProperty(PROPERTY_CATALOG);
                    if (string18 == null) {
                        string18 = "";
                    }
                    if (!this.schemaExists(string17)) {
                        object13 = new DBUserSqlServer(true, string17, "USER", string17);
                        ((DBObjectSqlServer)object13).setDb(string18);
                        this.selectedObjects.add(object13);
                    }
                    if (PROPERTY_TABLE.equalsIgnoreCase(String.valueOf(object2))) {
                        object13 = objectFolder.getFolderInstance().listChildren();
                        Iterator iterator = object13.iterator();
                        while (iterator.hasNext()) {
                            AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                            String string19 = (String)abstractNodeInstance.getProperty(PROPERTY_TABLE_NAME);
                            if (string19 == null || "".equalsIgnoreCase(string19)) continue;
                            DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(true, string19, PROPERTY_TABLE, string17);
                            if ("".equalsIgnoreCase(string18)) {
                                string18 = (String)abstractNodeInstance.getProperty(PROPERTY_TABLE_CATALOG);
                            }
                            if (string18 == null) {
                                string18 = "";
                            }
                            dBObjectSqlServer.setDb(string18);
                            this.selectedObjects.add(dBObjectSqlServer);
                            this.droppedTables.add(string19);
                        }
                        return;
                    }
                    if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(object2))) {
                        object13 = objectFolder.getFolderInstance().listChildren();
                        Iterator iterator = object13.iterator();
                        while (iterator.hasNext()) {
                            AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                            String string20 = (String)abstractNodeInstance.getProperty(PROPERTY_TABLE_NAME);
                            if (string20 == null || "".equalsIgnoreCase(string20)) continue;
                            DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(true, string20, PROPERTY_VIEW, string17);
                            if ("".equalsIgnoreCase(string18)) {
                                string18 = (String)abstractNodeInstance.getProperty(PROPERTY_TABLE_CATALOG);
                            }
                            if (string18 == null) {
                                string18 = "";
                            }
                            dBObjectSqlServer.setDb(string18);
                            this.selectedObjects.add(dBObjectSqlServer);
                            this.droppedViews.add(string20);
                        }
                        return;
                    }
                    if (!PROPERTY_PROCEDURES.equalsIgnoreCase(String.valueOf(object2))) return;
                    object13 = objectFolder.getFolderInstance().listChildren();
                    Iterator iterator = object13.iterator();
                    while (iterator.hasNext()) {
                        AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                        String string21 = (String)abstractNodeInstance.getProperty(PROPERTY_NAME);
                        if (string21 == null || "".equalsIgnoreCase(string21)) continue;
                        DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(true, string21, PROPERTY_PROCEDURE, string17);
                        if ("".equalsIgnoreCase(string18)) {
                            string18 = (String)abstractNodeInstance.getProperty(PROPERTY_TABLE_CATALOG);
                        }
                        if (string18 == null) {
                            string18 = "";
                        }
                        dBObjectSqlServer.setDb(string18);
                        this.selectedObjects.add(dBObjectSqlServer);
                    }
                    return;
                }
                if (string.toUpperCase().contains(DB_TYPE_DB2)) {
                    Object object14;
                    String string22 = (String)objectFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                    if (string22 != null) {
                        string22 = string22.trim();
                    }
                    if (!this.schemaExists(string22)) {
                        object14 = new DBObject(true, string22, PROPERTY_SCHEMA, string22);
                        this.selectedObjects.add(object14);
                    }
                    if (PROPERTY_TABLE.equalsIgnoreCase((String)object2)) {
                        object14 = objectFolder.getFolderInstance().listChildren();
                        Iterator iterator = object14.iterator();
                        while (iterator.hasNext()) {
                            AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                            String string23 = (String)abstractNodeInstance.getProperty(PROPERTY_OBJECT_NAME);
                            if (string23 == null) {
                                string23 = (String)abstractNodeInstance.getProperty(PROPERTY_NAME);
                            }
                            if (string23 == null || "".equalsIgnoreCase(string23) || this.droppedTables.contains(string23)) continue;
                            DBObject dBObject = new DBObject(true, string23, PROPERTY_TABLE, string22);
                            this.selectedObjects.add(dBObject);
                            this.droppedTables.add(string23);
                        }
                        return;
                    }
                    if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(object2))) {
                        object14 = objectFolder.getFolderInstance().listChildren();
                        Iterator iterator = object14.iterator();
                        while (iterator.hasNext()) {
                            AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                            String string24 = (String)abstractNodeInstance.getProperty(PROPERTY_OBJECT_NAME);
                            if (string24 == null) {
                                string24 = (String)abstractNodeInstance.getProperty(PROPERTY_NAME);
                            }
                            if (string24 == null || "".equalsIgnoreCase(string24) || this.droppedViews.contains(string24)) continue;
                            DBObject dBObject = new DBObject(true, string24, PROPERTY_VIEW, string22);
                            this.selectedObjects.add(dBObject);
                            this.droppedViews.add(string24);
                        }
                        return;
                    }
                    if (!PROPERTY_ALIASES.equalsIgnoreCase(String.valueOf(object2))) return;
                    object14 = objectFolder.getFolderInstance().listChildren();
                    Iterator iterator = object14.iterator();
                    while (iterator.hasNext()) {
                        AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                        String string25 = (String)abstractNodeInstance.getProperty(PROPERTY_OBJECT_NAME);
                        if (string25 == null) {
                            string25 = (String)abstractNodeInstance.getProperty(PROPERTY_NAME);
                        }
                        if (string25 == null || "".equalsIgnoreCase(string25) || this.droppedViews.contains(string25)) continue;
                        DBObject dBObject = new DBObject(true, string25, "ALIAS", string22);
                        this.selectedObjects.add(dBObject);
                        this.droppedViews.add(string25);
                    }
                    return;
                }
                String string26 = (String)objectFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                if (string26 != null) {
                    string26 = string26.trim();
                }
                if (!this.schemaExists(string26)) {
                    object11 = new DBObject(true, string26, PROPERTY_SCHEMA, string26);
                    this.selectedObjects.add(object11);
                }
                if (PROPERTY_TABLE.equalsIgnoreCase((String)object2)) {
                    object11 = objectFolder.getFolderInstance().listChildren();
                    Iterator iterator = object11.iterator();
                    while (iterator.hasNext()) {
                        AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                        String string27 = (String)abstractNodeInstance.getProperty(PROPERTY_OBJECT_NAME);
                        if (string27 == null) {
                            string27 = (String)abstractNodeInstance.getProperty(PROPERTY_NAME);
                        }
                        if (string27 == null || "".equalsIgnoreCase(string27) || this.droppedTables.contains(string27)) continue;
                        DBObject dBObject = new DBObject(true, string27, PROPERTY_TABLE, string26);
                        this.selectedObjects.add(dBObject);
                        this.droppedTables.add(string27);
                    }
                    return;
                }
                if (!PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(object2))) return;
                object11 = objectFolder.getFolderInstance().listChildren();
                Iterator iterator = object11.iterator();
                while (iterator.hasNext()) {
                    AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                    String string28 = (String)abstractNodeInstance.getProperty(PROPERTY_OBJECT_NAME);
                    if (string28 == null) {
                        string28 = (String)abstractNodeInstance.getProperty(PROPERTY_NAME);
                    }
                    if (string28 == null || "".equalsIgnoreCase(string28) || this.droppedViews.contains(string28)) continue;
                    DBObject dBObject = new DBObject(true, string28, PROPERTY_VIEW, string26);
                    this.selectedObjects.add(dBObject);
                    this.droppedViews.add(string28);
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        if (!this.isDatatypeModelSelected()) return;
        try {
            String string;
            if (this.currentConnection == null) {
                this.currentConnectionName = objectFolder.getConnectionName();
                this.currentConnection = objectFolder.getFolderInstance().getObjectFactory().getConnection();
            }
            if ((string = this.currentConnection.getMetaData().getDatabaseProductName()).toUpperCase().contains(DB_TYPE_ORACLE)) {
                Object object15;
                String string29 = (String)objectFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                if (!this.schemaExists(string29)) {
                    object15 = new DBObject(true, string29, "USER", string29);
                    this.selectedObjects.add(object15);
                }
                if (!PROPERTY_TYPE.equalsIgnoreCase(String.valueOf(object2))) return;
                object15 = objectFolder.getFolderInstance().listChildren();
                Iterator iterator = object15.iterator();
                while (iterator.hasNext()) {
                    AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                    String string30 = (String)abstractNodeInstance.getProperty(PROPERTY_NAME);
                    if (string30 == null || "".equalsIgnoreCase(string30)) continue;
                    DBObject dBObject = new DBObject(true, string30, "OBJECT", string29);
                    this.selectedObjects.add(dBObject);
                    this.droppedTypes.add(string30);
                }
                return;
            } else {
                Object object16;
                if (!string.toUpperCase().contains(DB_TYPE_DB2)) return;
                String string31 = (String)objectFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                if (string31 != null) {
                    string31 = string31.trim();
                }
                if (!this.schemaExists(string31)) {
                    object16 = new DBObject(true, string31, PROPERTY_SCHEMA, string31);
                    this.selectedObjects.add(object16);
                }
                if (!PROPERTY_UTYPES.equalsIgnoreCase(String.valueOf(object2))) return;
                object16 = objectFolder.getFolderInstance().listChildren();
                Iterator iterator = object16.iterator();
                while (iterator.hasNext()) {
                    AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)iterator.next();
                    String string32 = (String)abstractNodeInstance.getProperty(PROPERTY_NAME);
                    if (string32 == null || "".equalsIgnoreCase(string32)) continue;
                    DBObject dBObject = new DBObject(true, string32, PROPERTY_TYPE, string31);
                    this.selectedObjects.add(dBObject);
                    this.droppedTypes.add(string32);
                }
            }
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List getTopViews(List list, DesignPartView designPartView) {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (MultiShapedDesignObject multiShapedDesignObject : list) {
            TopView topView = multiShapedDesignObject.getFirstViewForDPV(designPartView);
            if (topView == null) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (EXTDropHandler.this.currentConnection != null) {
                ImportLogger importLogger = new ImportLogger();
                ProgressDialog progressDialog = new ProgressDialog(EXTDropHandler.this.appView, "", 0, 100);
                try {
                    Object object;
                    Object object22;
                    Iterator<Object> iterator;
                    ArrayList<Object> arrayList;
                    progressDialog.setProgress(5);
                    progressDialog.setNote(Messages.getString("EXTDropHandler.DropObjects"));
                    int n = 20;
                    int n2 = 20;
                    if (EXTDropHandler.this.isRelationalModelSelected()) {
                        n = ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).getMaxTopPoint();
                        n2 = ((DPVRelational)EXTDropHandler.this.appView.getCurrentDPV()).getMaxTopPoint();
                    }
                    try {
                        EXTDropHandler.this.appView.getCurrentDesign().setPropagatePKChahges(false);
                        arrayList = EXTDropHandler.this.currentConnection.getMetaData().getDatabaseProductName();
                        iterator = EXTDropHandler.this.currentConnection.getMetaData().getDatabaseProductVersion();
                        if (arrayList != null) {
                            ArrayList arrayList2;
                            boolean bl = false;
                            if (((String)((Object)arrayList)).toUpperCase().contains(EXTDropHandler.DB_TYPE_DB2)) {
                                if (iterator != null && (((String)((Object)iterator)).toUpperCase().contains("Z") || ((String)((Object)iterator)).toUpperCase().contains("390"))) {
                                    bl = true;
                                }
                                if (((String)((Object)arrayList)).toUpperCase().contains("Z") || ((String)((Object)arrayList)).toUpperCase().contains("390")) {
                                    bl = true;
                                }
                            }
                            if (((String)((Object)arrayList)).toUpperCase().contains(EXTDropHandler.DB_TYPE_ORACLE)) {
                                object22 = new ExtractionHandlerOracle(EXTDropHandler.this.appView);
                                ((ExtractionHandlerOracle)object22).init(EXTDropHandler.this.currentConnection);
                                EXTDropHandler.this.appView.getCurrentDesign().setSelectedRDBMSSite(((ExtractionHandlerOracle)object22).getRDBMSSite());
                                object = new SubordinateTablesOracle(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects);
                                if (EXTDropHandler.this.copy_mode) {
                                    EXTDropHandler.this.selectedObjects = ((SubordinateTablesOracle)object).getAllObjects(true);
                                }
                                EXTDropHandler.this.clearImportedTables(((ExtractionHandlerOracle)object22).getRDBMSSite());
                                if (EXTDropHandler.this.selectedObjects.size() > 0) {
                                    arrayList2 = new ArrayList();
                                    arrayList2.addAll(EXTDropHandler.this.selectedObjects);
                                    ((ExtractionHandlerOracle)object22).generateDesign(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects, importLogger, progressDialog);
                                    ((SubordinateTablesOracle)object).generateFKs_fromChilds(EXTDropHandler.this.currentConnection, arrayList2, EXTDropHandler.this.appView.getCurrentDesign(), ((ExtractionHandlerOracle)object22).getRDBMSSite());
                                }
                            } else if (((String)((Object)arrayList)).toUpperCase().contains(EXTDropHandler.DB_TYPE_MS_SQL_SERVER)) {
                                object22 = new ExtractionHandlerSQLServer(EXTDropHandler.this.appView);
                                ((ExtractionHandlerSQLServer)object22).init(EXTDropHandler.this.currentConnection);
                                EXTDropHandler.this.appView.getCurrentDesign().setSelectedRDBMSSite(((ExtractionHandlerSQLServer)object22).getRDBMSSite());
                                object = new SubordinateTablesJDBC(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects);
                                if (EXTDropHandler.this.copy_mode) {
                                    EXTDropHandler.this.selectedObjects = ((SubordinateTablesJDBC)object).getAllObjects(true, EXTDropHandler.DB_TYPE_MS_SQL_SERVER);
                                }
                                EXTDropHandler.this.clearImportedTables(((ExtractionHandlerSQLServer)object22).getRDBMSSite());
                                if (EXTDropHandler.this.selectedObjects.size() > 0) {
                                    arrayList2 = new ArrayList();
                                    arrayList2.addAll(EXTDropHandler.this.selectedObjects);
                                    ((ExtractionHandlerSQLServer)object22).generateDesign(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects, importLogger, progressDialog);
                                    ((SubordinateTablesJDBC)object).generateFKs_fromChilds(EXTDropHandler.this.currentConnection, arrayList2, EXTDropHandler.this.appView.getCurrentDesign(), ((ExtractionHandlerSQLServer)object22).getRDBMSSite());
                                }
                            } else if (((String)((Object)arrayList)).toUpperCase().contains(EXTDropHandler.DB_TYPE_DB2) && !bl) {
                                object22 = new ExtractionHandlerDB2(EXTDropHandler.this.appView);
                                ((ExtractionHandlerDB2)object22).init(EXTDropHandler.this.currentConnection);
                                EXTDropHandler.this.appView.getCurrentDesign().setSelectedRDBMSSite(((ExtractionHandlerDB2)object22).getRDBMSSite());
                                object = new SubordinateTablesJDBC(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects);
                                if (EXTDropHandler.this.copy_mode) {
                                    EXTDropHandler.this.selectedObjects = ((SubordinateTablesJDBC)object).getAllObjects(true, EXTDropHandler.DB_TYPE_DB2);
                                }
                                EXTDropHandler.this.clearImportedTables(((ExtractionHandlerDB2)object22).getRDBMSSite());
                                if (EXTDropHandler.this.selectedObjects.size() > 0) {
                                    arrayList2 = new ArrayList();
                                    arrayList2.addAll(EXTDropHandler.this.selectedObjects);
                                    ((ExtractionHandlerDB2)object22).generateDesign(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects, importLogger, progressDialog);
                                    ((SubordinateTablesJDBC)object).generateFKs_fromChilds(EXTDropHandler.this.currentConnection, arrayList2, EXTDropHandler.this.appView.getCurrentDesign(), ((ExtractionHandlerDB2)object22).getRDBMSSite());
                                }
                            } else {
                                object22 = new ExtractionHandlerODBC(EXTDropHandler.this.appView);
                                ((ExtractionHandlerODBC)object22).init(EXTDropHandler.this.currentConnection);
                                EXTDropHandler.this.appView.getCurrentDesign().setSelectedRDBMSSite(((ExtractionHandlerODBC)object22).getRDBMSSite());
                                object = new SubordinateTablesJDBC(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects);
                                if (EXTDropHandler.this.copy_mode) {
                                    EXTDropHandler.this.selectedObjects = ((SubordinateTablesJDBC)object).getAllObjects(true, EXTDropHandler.DB_TYPE_JDBC);
                                }
                                EXTDropHandler.this.clearImportedTables(((ExtractionHandlerODBC)object22).getRDBMSSite());
                                if (EXTDropHandler.this.selectedObjects.size() > 0) {
                                    arrayList2 = new ArrayList();
                                    arrayList2.addAll(EXTDropHandler.this.selectedObjects);
                                    ((ExtractionHandlerODBC)object22).generateDesign(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects, importLogger, progressDialog);
                                    ((SubordinateTablesJDBC)object).generateFKs_fromChilds(EXTDropHandler.this.currentConnection, arrayList2, EXTDropHandler.this.appView.getCurrentDesign(), ((ExtractionHandlerODBC)object22).getRDBMSSite());
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        EXTDropHandler.this.appView.getCurrentDesign().setPropagatePKChahges(false);
                    }
                    progressDialog.setNote(Messages.getString("EXTDropHandler.RearrangeObjects"));
                    progressDialog.setProgress(85);
                    try {
                        if (EXTDropHandler.this.isRelationalModelSelected()) {
                            arrayList = new ArrayList();
                            iterator = new ArrayList();
                            if (EXTDropHandler.this.droppedTables.size() > 0) {
                                for (Object object22 : EXTDropHandler.this.droppedTables) {
                                    if (object22 == null || (object = EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getTableSet().getByName((String)object22)) == null) continue;
                                    arrayList.add(object);
                                }
                            }
                            if (EXTDropHandler.this.droppedViews.size() > 0) {
                                for (Object object22 : EXTDropHandler.this.droppedViews) {
                                    if (object22 == null || (object = EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getTableViewSet().getByName((String)object22)) == null) continue;
                                    iterator.add(object);
                                }
                            }
                            if (EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().isEmpty()) {
                                if (EXTDropHandler.this.appView.getCurrentDPV() != EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()) {
                                    ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewDiagram();
                                    ((DPVRelational)EXTDropHandler.this.appView.getCurrentDPV()).rearrangeNewDiagram();
                                } else {
                                    ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewDiagram();
                                }
                            } else if (EXTDropHandler.this.appView.getCurrentDPV() != EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()) {
                                ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewTables(EXTDropHandler.this.getTopViews(arrayList, EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()), n);
                                ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewViews(EXTDropHandler.this.getTopViews(iterator, EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()));
                                ((DPVRelational)EXTDropHandler.this.appView.getCurrentDPV()).rearrangeNewTables(EXTDropHandler.this.getTopViews(arrayList, EXTDropHandler.this.appView.getCurrentDPV()), n2);
                                ((DPVRelational)EXTDropHandler.this.appView.getCurrentDPV()).rearrangeNewViews(EXTDropHandler.this.getTopViews(iterator, EXTDropHandler.this.appView.getCurrentDPV()));
                            } else {
                                ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewTables(EXTDropHandler.this.getTopViews(arrayList, EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()), n);
                                ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewViews(EXTDropHandler.this.getTopViews(iterator, EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()));
                            }
                        } else if (EXTDropHandler.this.isDatatypeModelSelected() && EXTDropHandler.this.droppedTypes.size() > 0) {
                            arrayList = new ArrayList<Object>();
                            for (String string : EXTDropHandler.this.droppedTypes) {
                                if (string == null || (object22 = EXTDropHandler.this.appView.getCurrentDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string)) == null) continue;
                                arrayList.add(object22);
                            }
                            EXTDropHandler.this.appView.getCurrentDesign().getDataTypesDesign().rearrangeTypes(arrayList, EXTDropHandler.this.currentPoint);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    EXTDropHandler.this.appView.getCurrentDesign().setDirty(true);
                    EXTDropHandler.this.appView.getCurrentDesign().getStorageDesign(EXTDropHandler.this.appView.getCurrentDesign().getSelectedRDBMSSite()).setOpen(true);
                    EXTDropHandler.this.appView.getCurrentDesign().getStorageDesign(EXTDropHandler.this.appView.getCurrentDesign().getSelectedRDBMSSite()).setDirty(true);
                    progressDialog.setProgress(100);
                    System.gc();
                }
                finally {
                    progressDialog.close();
                }
            }
        }
    }
}

