/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.model.Displayable;
import oracle.ide.model.Locatable;

public class DisplayableLocatableNode
extends DefaultMutableTreeNode
implements Displayable,
Locatable {
    private static final Logger LOGGER = new Logger(DisplayableLocatableNode.class);
    protected File filePath;
    protected Class objectClass;
    protected URL url;
    protected StorableObject storableObject;

    public DisplayableLocatableNode(StorableObject storableObject) {
        this(storableObject.getName(), new File(storableObject instanceof ModelIDObject ? ((ModelIDObject)storableObject).getSegmentedStorageName() : storableObject.getStorageName()), storableObject.getClass());
        this.setStorableObject(storableObject);
    }

    public DisplayableLocatableNode(String string) {
        this.setURL(string);
    }

    public DisplayableLocatableNode(File file) {
        this.setFileURL(file.getPath());
        this.setFilePath(file);
    }

    public DisplayableLocatableNode(String string, File file, Class clazz) {
        super(string);
        this.setFilePath(file);
        this.setObjectClass(clazz);
        if (file != null) {
            this.setFileURL(file.getPath());
        }
    }

    public StorableObject getStorableObject() {
        return this.storableObject;
    }

    public void setStorableObject(StorableObject storableObject) {
        this.storableObject = storableObject;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public void setFilePath(File file) {
        this.filePath = file;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class clazz) {
        this.objectClass = clazz;
    }

    protected void setFileURL(String string) {
        this.setURL("file://" + string);
    }

    protected void setURL(String string) {
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.error(malformedURLException);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public String getShortLabel() {
        return super.toString();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return NavigationTreeRenderer.getIcon(this.objectClass);
    }

    public String getToolTipText() {
        return null;
    }

    public static DisplayableLocatableNode[] convert(File[] fileArray) {
        if (fileArray == null) {
            return null;
        }
        DisplayableLocatableNode[] displayableLocatableNodeArray = new DisplayableLocatableNode[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            displayableLocatableNodeArray[i] = new DisplayableLocatableNode(fileArray[i]);
        }
        return displayableLocatableNodeArray;
    }

    public static File[] convertToFileArray(Locatable[] locatableArray, boolean bl) {
        List<File> list = DisplayableLocatableNode.convertToFileList(locatableArray, bl);
        return list.toArray(new File[0]);
    }

    public static List<File> convertToFileList(Locatable[] locatableArray, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (locatableArray != null && locatableArray.length > 0) {
            for (int i = 0; i < locatableArray.length; ++i) {
                StorableObject storableObject;
                DisplayableLocatableNode displayableLocatableNode = (DisplayableLocatableNode)locatableArray[i];
                arrayList.add(displayableLocatableNode.getFilePath());
                if (!bl || (storableObject = displayableLocatableNode.getStorableObject()) == null || !(storableObject instanceof Design)) continue;
                Design design = (Design)storableObject;
                String string = design.getStoragePath();
                DisplayableLocatableNode.addFolderEntries(new File(string), arrayList);
            }
        }
        return arrayList;
    }

    private static void addFolderEntries(File file, List<File> list) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                DisplayableLocatableNode.addFolderEntries(file2, list);
                continue;
            }
            if (!VCSClientHelper.accept(file2)) continue;
            list.add(file2);
        }
    }
}

